/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.settings;

import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.settings.PDKRequestResult;
import com.sap.portal.developmentTools.general.uploader.PARArchiveUploaderConstants;
import com.sap.portal.util.Stream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

public class PDKInstallation
implements PARArchiveUploaderConstants {
    public static final int DEFAULT_IRJ_PORT = 8080;
    public static final String DEFAULT_SERVER_NAME = "localhost";
    public static final String DEFAULT_WEBAPP_NAME = "irj";
    public static final String STANDARD_ROOT_DIR;
    public static final String DEFAULT_IRJ_HOME;
    public static final String THIS_PROP_GROUP = "com.sapportals.portal.prt.opentools.general.PDKInstallation";
    public static final String IRJ_HOME_PROPERTY_NAME = "IRJ_HOME";
    public static final String IRJ_PORT_PROPERTY_NAME = "IRJ_PORT";
    public static final String IRJ_WEBAPP_NAME_PROPERTY_NAME = "IRJ_WEBAPP_NAME";
    public static final String IRJ_SERVER_NAME_PROPERTY_NAME = "IRJ_SERVER";
    private static PDKInstallation singletonInstance;
    private int irjPort;
    private String irjServerName;
    private String irjWebappName;
    private String irjWebAppFileHome;
    private HashMap cookies = new HashMap();

    private PDKInstallation() throws Exception {
        this.reload();
    }

    public static PDKInstallation getInstance() throws Exception {
        if (singletonInstance == null) {
            singletonInstance = new PDKInstallation();
        }
        return singletonInstance;
    }

    public String getIrjRootURL() {
        return "http://" + this.irjServerName + ":" + this.irjPort + "/" + this.irjWebappName;
    }

    public String getIrjWebAppFileHome() {
        return this.irjWebAppFileHome;
    }

    public void updateIrjWebappFileHome() throws IOException {
        PDKRequestResult result = this.sendRequestToUploaderComponent("getRootDir", new Properties());
        Object f = result.getResultData();
        if (f != null) {
            this.irjWebAppFileHome = ((File)f).getAbsolutePath();
        }
    }

    public boolean isConfiguredOnce() {
        return true;
    }

    public boolean isServerReachable() {
        boolean reachable = true;
        try {
            this.pingPDK();
            reachable = true;
        }
        catch (IOException e) {
            reachable = false;
        }
        return reachable;
    }

    public List getInstalledServices() throws IOException {
        PDKRequestResult result = null;
        try {
            result = this.sendRequestToUploaderComponent("getList", new Properties());
            if (result.getResultType() != 0) {
                throw new IOException("Sorry, server is unreachable/has not the com.sap.pdk.util.DevelopmentTools-component installed");
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(result.getXmlData());
            this.writeServiceFileToDisk(bais);
        }
        catch (ConnectException e) {
            result = this.readServiceListFromDisk();
        }
        return (List)result.getResultData();
    }

    public void updateInstalledServicesOnDisk() throws IOException {
        PDKRequestResult result = this.sendRequestToUploaderComponent("getList", new Properties());
        if (result.getResultType() != 0) {
            throw new IOException("Sorry, server is unreachable/has not the com.sap.pdk.util.DevelopmentTools-component installed");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(result.getXmlData());
        this.writeServiceFileToDisk(bais);
    }

    private void writeServiceFileToDisk(ByteArrayInputStream bais) throws IOException {
        File serviceListXMLFile = this.getServiceListFile();
        if (!serviceListXMLFile.exists()) {
            serviceListXMLFile.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(serviceListXMLFile);
        Stream.copyStream(bais, fos);
        fos.close();
    }

    private File getServiceListFile() {
        return new File(OpentoolsFactory.getIDEInstance().getUserDirectory(), "PDKServicesListCache.xml");
    }

    private PDKRequestResult readServiceListFromDisk() throws IOException {
        File serviceListXMLFile = this.getServiceListFile();
        FileInputStream fis = new FileInputStream(serviceListXMLFile);
        PDKRequestResult result = PDKRequestResult.createResultObject(fis);
        fis.close();
        return result;
    }

    private static String encodePropertiesForURLString(Properties p) {
        String name;
        StringBuffer result = new StringBuffer();
        Enumeration<?> en = p.propertyNames();
        if (en.hasMoreElements()) {
            name = (String)en.nextElement();
            result.append(PDKInstallation.encodeStringForURL(name));
            result.append('=');
            result.append(PDKInstallation.encodeStringForURL((String)((Hashtable)p).get(name)));
        }
        while (en.hasMoreElements()) {
            result.append('&');
            name = (String)en.nextElement();
            result.append(PDKInstallation.encodeStringForURL(name));
            result.append('=');
            result.append(PDKInstallation.encodeStringForURL((String)((Hashtable)p).get(name)));
        }
        return result.toString();
    }

    private static String encodeStringForURL(String string) {
        StringBuffer result = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char now = string.charAt(n);
            if (now == ' ') {
                result.append('+');
            } else {
                result.append('%');
                result.append(Integer.toHexString(now));
            }
            ++n;
        }
        return result.toString();
    }

    public boolean uploadPARArchive(File parArchive) throws IOException {
        String fileName = parArchive.getAbsolutePath();
        Properties params = new Properties();
        ((Hashtable)params).put("fileName", fileName);
        PDKRequestResult result = this.sendRequestToUploaderComponent("upload", params);
        return result.getResultType() == 1;
    }

    public void pingPDK() throws IOException {
        PDKRequestResult result = this.sendRequestToUploaderComponent("getRootDir", new Properties());
        if (result == null) {
            throw new IOException("Could not connect to the PDK.");
        }
        if (result.getResultType() != 2) {
            throw new IOException(result.getResultData().toString());
        }
    }

    private PDKRequestResult sendRequestToUploaderComponent(String eventName, Properties params) throws IOException {
        return null;
    }

    private void updateCookieState(HttpURLConnection connection) {
    }

    private void addCookieState(HttpURLConnection connection) {
    }

    public void loadCookieStateFromFile(File file) throws IOException, ClassNotFoundException {
        FileInputStream is = new FileInputStream(file);
        ObjectInputStream objectReader = new ObjectInputStream(is);
        this.cookies = (HashMap)objectReader.readObject();
        objectReader.close();
    }

    public void writeCookieStateToFile(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        ObjectOutputStream objectWriter = new ObjectOutputStream(os);
        objectWriter.writeObject(this.cookies);
        objectWriter.close();
    }

    public void setIrjPort(int irjPort) {
        this.irjPort = irjPort;
    }

    public void setIrjServerName(String irjServerName) {
        this.irjServerName = irjServerName;
    }

    public void setIrjWebappName(String irjWebappName) {
        this.irjWebappName = irjWebappName;
    }

    public void doSave() throws Exception {
    }

    public void reload() throws Exception {
        if (this.irjServerName == null) {
            this.irjServerName = DEFAULT_SERVER_NAME;
        }
        if (this.irjWebAppFileHome == null) {
            this.irjWebAppFileHome = DEFAULT_IRJ_HOME;
        }
        if (this.irjWebappName == null) {
            this.irjWebappName = DEFAULT_WEBAPP_NAME;
        }
    }

    static {
        File[] roots = File.listRoots();
        String tmp = null;
        int i = 0;
        while (i < roots.length) {
            File root = roots[i];
            if (root.getAbsolutePath().startsWith("c") || root.getAbsolutePath().startsWith("C")) {
                tmp = root.getAbsolutePath();
                break;
            }
            ++i;
        }
        STANDARD_ROOT_DIR = tmp == null ? roots[0].getAbsolutePath() : tmp;
        DEFAULT_IRJ_HOME = STANDARD_ROOT_DIR + "tomcat" + File.separator + "webapps" + File.separator + DEFAULT_WEBAPP_NAME;
    }
}

