/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.settings;

import com.sap.portal.developmentTools.general.api.IPropertySystem;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.settings.PDKInstallation;
import com.sap.portal.util.Strings;
import java.io.File;
import java.io.IOException;

public class IDESettings {
    private static IDESettings singletonInstance = new IDESettings();
    private static final String THIS_PROP_GROUP = "com.sapportals.portal.prt.opentools.general.IDESettings";
    private static final String PROJECT_ROOT_ROOT_FOLDER_PROPERTY_NAME = "projectRootFolder";
    private static final String ETZ_ARCHIVE_FILE_NAME_PROPERTY_NAME = "etzArchive";
    public static final String URLWSDL_NAME_PROPERTY_NAME = "urlwsdl";
    public static final String WSDLSERVICENAME_PROPERTY_NAME = "servicewsdl";
    public static final String WSDLALIASNAME_PROPERTY_NAME = "aliaswsdl";
    public static final String WSDLPACKAGENAME_PROPERTY_NAME = "packagenamewsdl";
    public static final String MINOCCURSNIL_PROPERTY_NAME = "minoccNill";
    private static final String PAR_ARCHIVE_FILE_NAME_PROPERTY_NAME = "parArchive";
    private static final String ZIP_ARCHIVE_SRC_PROPERTY_NAME = "autoZip";
    private static final String AUTO_UPLOAD_PROPERTY_NAME = "autoUpload";
    private static final String REMEMBER_PASSWD_PROPERTY_NAME = "rememberedPasswd";
    private static final String OPEN_PAR_DEFAULT_FOLDER_PROPERTY_NAME = "defaultOpenParFolder";
    public static final String QUICKSTART_PROFILE_NAME_PROPERTY = "quickstart";
    public static final String QUICKSTART_PROFILE_BROWSER_CMD_LINE = "browser_cmd";
    private static final String DEFAULT_PROJECT_ROOT_ROOT_FOLDER = PDKInstallation.STANDARD_ROOT_DIR + "SAP";
    private static final boolean DEFAULT_AUTO_UPLOAD = false;
    private static final boolean DEFAULT_ZIP_ARCHIVE_SRC = false;
    private static final boolean DEFAULT_REMEMBERED_PASSWD = false;
    private static final String DEFAULT_OPEN_PAR_DEFAULT_FOLDER;
    private static final String DEFAULT_BROWSER_CMD_LINE = "cmd /C start iexplore";

    private IDESettings() {
    }

    public static IDESettings getInstance() {
        return singletonInstance;
    }

    public String getProjectRootRootFolder() {
        String projectRootRootFolder = null;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            projectRootRootFolder = ps.loadProperty(THIS_PROP_GROUP, PROJECT_ROOT_ROOT_FOLDER_PROPERTY_NAME, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (projectRootRootFolder == null) {
            projectRootRootFolder = DEFAULT_PROJECT_ROOT_ROOT_FOLDER;
        }
        return projectRootRootFolder;
    }

    public void setProjectRootRootFolder(String projectRootRootFolder) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, PROJECT_ROOT_ROOT_FOLDER_PROPERTY_NAME, projectRootRootFolder, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isRememberedPasswd(Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        boolean rememberPasswd = false;
        try {
            String tmp = ps.loadProperty(THIS_PROP_GROUP, REMEMBER_PASSWD_PROPERTY_NAME, project);
            rememberPasswd = tmp.equals("true");
        }
        catch (Exception e) {
            // empty catch block
        }
        return rememberPasswd;
    }

    public void setRememberPasswd(boolean rememberPasswd, Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, REMEMBER_PASSWD_PROPERTY_NAME, String.valueOf(rememberPasswd), project);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public boolean isAutoUpload(Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        boolean autoUpload = false;
        try {
            String tmp = ps.loadProperty(THIS_PROP_GROUP, AUTO_UPLOAD_PROPERTY_NAME, project);
            autoUpload = tmp.equals("true");
        }
        catch (Exception e) {
            // empty catch block
        }
        return autoUpload;
    }

    public void setAutoUpload(boolean autoUpload, Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, AUTO_UPLOAD_PROPERTY_NAME, String.valueOf(autoUpload), project);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public boolean isZipArchiveSrc(Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        boolean zipArchiveSrc = false;
        try {
            String tmp = ps.loadProperty(THIS_PROP_GROUP, ZIP_ARCHIVE_SRC_PROPERTY_NAME, project);
            zipArchiveSrc = tmp.equals("true");
        }
        catch (Exception e) {
            // empty catch block
        }
        return zipArchiveSrc;
    }

    public void setZipArchiveSrc(boolean zipArchiveSrc, Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, ZIP_ARCHIVE_SRC_PROPERTY_NAME, String.valueOf(zipArchiveSrc), project);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getParArchiveName(Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        String parArchiveName = null;
        try {
            parArchiveName = ps.loadProperty(THIS_PROP_GROUP, PAR_ARCHIVE_FILE_NAME_PROPERTY_NAME, project);
            if (parArchiveName == null) {
                parArchiveName = OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project) + File.separator + OpentoolsFactory.getIDEInstance().getProjectName(project) + ".par";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (parArchiveName == null) {
            parArchiveName = "";
        }
        return parArchiveName;
    }

    public String getArchiveName(Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        String parArchiveName = null;
        try {
            parArchiveName = ps.loadProperty(THIS_PROP_GROUP, PAR_ARCHIVE_FILE_NAME_PROPERTY_NAME, project);
            if (parArchiveName == null) {
                parArchiveName = OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project) + File.separator + OpentoolsFactory.getIDEInstance().getProjectName(project);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (parArchiveName == null) {
            parArchiveName = "";
        }
        return parArchiveName;
    }

    public String getEtzArchiveName(Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        String etzArchiveName = null;
        try {
            etzArchiveName = ps.loadProperty(THIS_PROP_GROUP, ETZ_ARCHIVE_FILE_NAME_PROPERTY_NAME, project);
            if (etzArchiveName == null) {
                etzArchiveName = OpentoolsFactory.getIDEInstance().getProjectName(project);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (etzArchiveName == null) {
            etzArchiveName = "";
        }
        return etzArchiveName;
    }

    public String getURLWSDL(Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        String urlwsdl = null;
        try {
            urlwsdl = ps.loadProperty(THIS_PROP_GROUP, URLWSDL_NAME_PROPERTY_NAME, project);
            if (urlwsdl == null) {
                urlwsdl = "";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return urlwsdl;
    }

    public void setURLWSDL(Object project, String url) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, URLWSDL_NAME_PROPERTY_NAME, url, project);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getProperty(String name, Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            return ps.loadProperty(THIS_PROP_GROUP, name, project);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setProperty(String name, String value, Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, name, value, project);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getParShortName(Object project) {
        String parArchiveName = this.getArchiveName(project);
        try {
            int lastDotIndex;
            int lastSlashIndex = parArchiveName.lastIndexOf(File.separatorChar);
            if (lastSlashIndex < 0) {
                lastSlashIndex = 0;
            }
            if ((lastDotIndex = parArchiveName.lastIndexOf(46)) < lastSlashIndex) {
                lastDotIndex = parArchiveName.length();
            }
            return parArchiveName.substring(lastSlashIndex + 1);
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setParArchiveName(Object project, String parArchiveName) {
        if (Strings.endsWithIgnoreCase(parArchiveName, ".par") || Strings.endsWithIgnoreCase(parArchiveName, ".zar")) {
            parArchiveName = parArchiveName.substring(0, parArchiveName.length() - 4);
        }
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, PAR_ARCHIVE_FILE_NAME_PROPERTY_NAME, parArchiveName, project);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setEtzArchiveName(Object project, String etzArchiveName) {
        if (Strings.endsWithIgnoreCase(etzArchiveName, ".etz")) {
            etzArchiveName = etzArchiveName.substring(0, etzArchiveName.length() - 4);
        }
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, ETZ_ARCHIVE_FILE_NAME_PROPERTY_NAME, etzArchiveName, project);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getOpenParDefaultFolder() {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        String openParDefaultFolder = null;
        try {
            openParDefaultFolder = ps.loadProperty(THIS_PROP_GROUP, OPEN_PAR_DEFAULT_FOLDER_PROPERTY_NAME, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (openParDefaultFolder == null) {
            openParDefaultFolder = DEFAULT_OPEN_PAR_DEFAULT_FOLDER;
        }
        return openParDefaultFolder;
    }

    public void setOpenParDefaultFolder(String openParDefaultFolder) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, OPEN_PAR_DEFAULT_FOLDER_PROPERTY_NAME, openParDefaultFolder, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setQuickstartProfileName(Object project, String profileName) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, QUICKSTART_PROFILE_NAME_PROPERTY, profileName, project);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getQuickstartProfileName(Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        String profileName = null;
        try {
            profileName = ps.loadProperty(THIS_PROP_GROUP, QUICKSTART_PROFILE_NAME_PROPERTY, project);
        }
        catch (Exception e) {
            // empty catch block
        }
        return profileName;
    }

    public String getInvokeBrowserCmd() {
        String cmd = null;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            cmd = ps.loadProperty(THIS_PROP_GROUP, QUICKSTART_PROFILE_BROWSER_CMD_LINE, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cmd == null) {
            cmd = DEFAULT_BROWSER_CMD_LINE;
        }
        return cmd;
    }

    public void setInvokeBrowserCmd(String cmdString) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, QUICKSTART_PROFILE_BROWSER_CMD_LINE, cmdString, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        String defaultOpenPARDefaultFolder = null;
        try {
            int i;
            File[] roots;
            try {
                defaultOpenPARDefaultFolder = PDKInstallation.getInstance().getIrjWebAppFileHome() + "WEB-INF" + File.separator + "deployment";
            }
            catch (IOException e) {
                roots = File.listRoots();
                i = 0;
            }
            while (i < roots.length) {
                File root = roots[i];
                if (root.getAbsolutePath().startsWith("c") || root.getAbsolutePath().startsWith("C")) {
                    defaultOpenPARDefaultFolder = root.getAbsolutePath();
                    break;
                }
                ++i;
            }
            if (defaultOpenPARDefaultFolder == null) {
                defaultOpenPARDefaultFolder = roots[0].getAbsolutePath();
            }
            Object var6_2 = null;
            DEFAULT_OPEN_PAR_DEFAULT_FOLDER = defaultOpenPARDefaultFolder;
            return;
            catch (Exception e) {
                e.printStackTrace();
                Object var6_3 = null;
                DEFAULT_OPEN_PAR_DEFAULT_FOLDER = defaultOpenPARDefaultFolder;
                return;
            }
            Object var6_1 = null;
            DEFAULT_OPEN_PAR_DEFAULT_FOLDER = defaultOpenPARDefaultFolder;
            return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            DEFAULT_OPEN_PAR_DEFAULT_FOLDER = defaultOpenPARDefaultFolder;
            throw throwable;
        }
    }
}

