/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.iDE;

import com.sap.portal.developmentTools.general.api.IDE;
import com.sap.portal.developmentTools.general.api.IPropertySystem;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.api.StringBasedFileFilter;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public abstract class AbstractIDE
implements IDE {
    public static boolean mm_tests = false;
    private static final String THIS_PROP_GROUP = "com.sap.portal.developmentTools.general.iDE.AbstractIDE";
    private static final String CATEGS_PROPNAME = "classpathCategories";

    public void adjustProjectClassPathTo(Object project, List paths, Object category) throws Exception {
        HashMap<Object, List> categoryToClassPathList = new HashMap<Object, List>();
        IPropertySystem ips = OpentoolsFactory.getPropertySystemInstance();
        String classpathCategoriesString = ips.loadProperty(THIS_PROP_GROUP, CATEGS_PROPNAME, project);
        if (classpathCategoriesString != null) {
            StringTokenizer categTokenizer = new StringTokenizer(classpathCategoriesString, ">");
            while (categTokenizer.hasMoreTokens()) {
                String categoryHere = categTokenizer.nextToken();
                String categoryValue = ips.loadProperty(THIS_PROP_GROUP, "classpathCategories." + categoryHere, project);
                StringTokenizer valueTokenizer = new StringTokenizer(categoryValue, ">");
                ArrayList<String> classPath = new ArrayList<String>();
                while (valueTokenizer.hasMoreTokens()) {
                    String fileName = valueTokenizer.nextToken();
                    classPath.add(fileName);
                }
                categoryToClassPathList.put(categoryHere, classPath);
            }
        }
        categoryToClassPathList.put(category, paths);
        ArrayList fullClassPath = new ArrayList();
        Iterator it = categoryToClassPathList.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            fullClassPath.addAll(list);
        }
        this.defineFullProjectClasspath(project, fullClassPath);
        StringBuffer allCategoriesPropertyValue = new StringBuffer();
        Iterator iterator = categoryToClassPathList.keySet().iterator();
        while (iterator.hasNext()) {
            String categoryHere = (String)iterator.next();
            allCategoriesPropertyValue.append(">");
            allCategoriesPropertyValue.append(categoryHere);
            ArrayList classpathHere = (ArrayList)categoryToClassPathList.get(categoryHere);
            StringBuffer classPathAsString = new StringBuffer();
            Iterator citerator = ((AbstractList)classpathHere).iterator();
            while (citerator.hasNext()) {
                String file = (String)citerator.next();
                classPathAsString.append(">");
                classPathAsString.append(file);
            }
            ips.saveProperty(THIS_PROP_GROUP, "classpathCategories." + categoryHere, classPathAsString.toString(), project);
        }
        ips.saveProperty(THIS_PROP_GROUP, CATEGS_PROPNAME, allCategoriesPropertyValue.toString(), project);
    }

    public String[] getSegmentsForFile(Object project, File fileInProject) {
        String projectPath = this.getCurrentProjectFolder(project);
        String fileRelativePath = fileInProject.getAbsolutePath().substring(projectPath.length());
        ArrayList<String> al = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(fileRelativePath, File.separator);
        while (st.hasMoreTokens()) {
            al.add(st.nextToken());
        }
        return al.toArray(new String[al.size()]);
    }

    protected abstract void defineFullProjectClasspath(Object var1, List var2) throws Exception;

    public static String getSlashSeparatedNameFromStringArray(String[] nameSegements, char delim) {
        StringBuffer retVal = new StringBuffer();
        int i = 0;
        while (i < nameSegements.length) {
            retVal.append(delim);
            retVal.append(nameSegements[i]);
            ++i;
        }
        return retVal.substring(1);
    }

    public static String[] getFileNameSegmentsForSlashSeparatedFileName(String fileName) {
        ArrayList<String> retVal = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(fileName, "\\/");
        while (st.hasMoreTokens()) {
            retVal.add(st.nextToken());
        }
        return retVal.toArray(new String[retVal.size()]);
    }

    public static String cleanJSPFileName(String jspFilename) {
        if (jspFilename == null) {
            jspFilename = "";
        }
        while (jspFilename.endsWith(".")) {
            jspFilename = jspFilename.substring(0, jspFilename.length() - 1);
        }
        while (jspFilename.startsWith(".")) {
            jspFilename = jspFilename.substring(0, jspFilename.length() - 1);
        }
        if (jspFilename.length() >= 4 && jspFilename.substring(jspFilename.length() - 4, jspFilename.length()).equalsIgnoreCase(".jsp")) {
            jspFilename = jspFilename.substring(0, jspFilename.length() - 4);
        }
        jspFilename = jspFilename + ".jsp";
        return jspFilename;
    }

    public abstract String getTemplateFolderPath();

    public abstract void registerServiceApiCoreSeparationValidator(Object var1) throws Exception;

    public abstract Object prepareNewProject(File var1, String[] var2, String[] var3, boolean var4) throws Exception;

    public abstract Object prepareNewProject(File var1, String[] var2, String[] var3, String var4) throws Exception;

    public abstract Object prepareNewProject(File var1, String[] var2, String[] var3) throws Exception;

    public abstract int addOutPathInProject(Object var1, String[] var2) throws Exception;

    public abstract int addSrcPathInProject(Object var1, String[] var2) throws Exception;

    public abstract File createJavaSourceFileInCurrentProject(Object var1, String var2, int var3) throws Exception;

    public abstract File getUserDirectory();

    public abstract List getAllNonAbstractClassesDerivedFromInCurrentProject(Object var1, String var2);

    public abstract void updateProjectFromFilesSystem(Object var1, StringBasedFileFilter var2) throws Exception;

    public abstract File getSrcPath(Object var1, int var2) throws Exception;

    public abstract File getOutPath(Object var1, int var2) throws Exception;

    public abstract int getOutPathCount(Object var1) throws Exception;

    public abstract int getSourcePathCount(Object var1) throws Exception;

    public abstract void addLibrariesReferences(Object var1, String[] var2) throws Exception;

    public abstract void addLibraryReference(Object var1, String var2) throws Exception;

    public abstract boolean rebuildCurrentProject(Object var1, int[] var2, int var3) throws Exception;

    public abstract void openFileInEditor(Object var1, String[] var2) throws Exception;

    public abstract List getAllFilesInProject(Object var1, StringBasedFileFilter var2, StringBasedFileFilter var3) throws IOException;

    public abstract File getFileObjectFor(Object var1, String[] var2) throws IOException;

    public abstract boolean deleteFileFromProject(Object var1, String[] var2) throws IOException;

    public abstract File createFileInProject(Object var1, String[] var2, boolean var3) throws Exception;

    public abstract int getIdeType();

    public abstract String getCurrentProjectName();

    public abstract String getProjectName(Object var1);

    public abstract Object getCurrentProjectEP6();

    public abstract String getCurrentProjectFolder(Object var1);
}

