/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.gui.swt;

import com.sap.portal.developmentTools.general.api.IDE;
import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.Labeled;
import com.sap.portal.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.portal.developmentTools.general.gui.swt.LabeledPackageBrowsableTextField;
import com.sap.portal.developmentTools.general.gui.swt.LabeledTextField;
import com.sap.portal.developmentTools.general.gui.swt.Validateable;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.general.wizards.webservices.IWebservicesWizardStringLiterals;
import com.sap.portal.util.JavaIdentifier;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class WebWsdlPropertiesComposite
extends Composite
implements Labeled,
Validateable,
IWebservicesWizardStringLiterals {
    private LabeledTextField mm_alias;
    private LabeledTextField mm_serviceName;
    private LabeledPackageBrowsableTextField mm_package;
    private Button mm_minOccursEqualsNillable;
    private Object mm_project;
    private IGUI guiSystem = OpentoolsFactory.getGuiSystem();

    public WebWsdlPropertiesComposite(Composite parent, int style, Object project) {
        super(parent, style);
        this.mm_project = project;
        try {
            this.init();
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            this.guiSystem.showErrorMessage("Error", "An error occurred initializing the properties composite", e, this.getShell());
        }
    }

    private void init() throws Exception {
        GridData gridData = new GridData(768);
        Composite container = super.getParent();
        container.setLayout((Layout)new GridLayout());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(gridData);
        this.mm_serviceName = new LabeledTextField(this, 0, "Service Name:  ");
        IDESettings is = IDESettings.getInstance();
        if (is.getProperty("servicewsdl", this.mm_project) != null) {
            this.mm_serviceName.setValue(is.getProperty("servicewsdl", this.mm_project));
        } else {
            this.mm_serviceName.setValue("ServiceName");
        }
        this.mm_serviceName.setLayoutData(new GridData(768));
        this.mm_alias = new LabeledTextField(this, 0, "Alias:  ");
        if (is.getProperty("aliaswsdl", this.mm_project) != null && !is.getProperty("aliaswsdl", this.mm_project).equalsIgnoreCase("alias")) {
            this.mm_alias.setValue(is.getProperty("aliaswsdl", this.mm_project));
        } else {
            this.mm_alias.setValue("com.sap.portal.prt.soap.Alias");
        }
        this.mm_alias.setLayoutData(new GridData(768));
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        IFolder[] sourceFolders = new IFolder[ideInstance.getSourcePathCount(this.mm_project)];
        int i = 0;
        while (i < sourceFolders.length) {
            File sourceFolderNow = ideInstance.getSrcPath(this.mm_project, i);
            String relativePath = sourceFolderNow.getAbsolutePath().substring(ideInstance.getCurrentProjectFolder(this.mm_project).length());
            sourceFolders[i] = ((IProject)this.mm_project).getFolder((IPath)new Path(relativePath));
            ++i;
        }
        this.mm_package = new LabeledPackageBrowsableTextField(this, 0, "Package:  ", sourceFolders, null);
        if (is.getProperty("packagenamewsdl", this.mm_project) != null) {
            this.mm_package.setValue(is.getProperty("packagenamewsdl", this.mm_project));
        } else {
            this.mm_package.setValue("com.company.global.enterprise.portal.wsdl.webservices.service.packagename");
        }
        this.mm_package.setLayoutData(new GridData(768));
        this.mm_minOccursEqualsNillable = new Button((Composite)this, 32);
        this.mm_minOccursEqualsNillable.setText("To interpret 'MinOccurs=0' as 'Nillable=true'");
        this.mm_minOccursEqualsNillable.setLayoutData((Object)new GridData(768));
        if (is.getProperty("minoccNill", this.mm_project) != null && is.getProperty("minoccNill", this.mm_project).equals("true")) {
            this.mm_minOccursEqualsNillable.setSelection(true);
        }
        this.alignLabels();
        container.layout();
    }

    private void alignLabels() {
        LabeledThingsGroup labelGroup = new LabeledThingsGroup();
        labelGroup.add(this.mm_serviceName);
        labelGroup.add(this.mm_alias);
        labelGroup.add(this.mm_package);
        labelGroup.alignTextFields();
    }

    public String getAlias() {
        return this.mm_alias.getValue();
    }

    public boolean isMinOccurAsNillable() {
        return this.mm_minOccursEqualsNillable.getSelection();
    }

    public String getServiceName() {
        return this.mm_serviceName.getValue();
    }

    public String getPackage() {
        return this.mm_package.getValue();
    }

    public String validate() {
        if (!this.isClassNameValid()) {
            return "The service name must contain a valid Java class name.";
        }
        if (!this.isPackageNameValid()) {
            if (this.getPackage() == null || this.getPackage().trim().equals("")) {
                return "The package cannot be empty.";
            }
            return "The package must contain a valid package name.";
        }
        if (this.getAlias().trim().equalsIgnoreCase("") || this.getAlias() == null) {
            return "The alias cannot be empty.";
        }
        return null;
    }

    public void addModifyListener(ModifyListener listener) {
        this.mm_alias.getTextField().addModifyListener(listener);
        this.mm_package.getTextField().addModifyListener(listener);
        this.mm_serviceName.getTextField().addModifyListener(listener);
    }

    public void setLabelWidth(int width) {
        this.mm_alias.setLabelWidth(width);
        this.mm_package.setLabelWidth(width);
        this.mm_serviceName.setLabelWidth(width);
    }

    public int getMinimumLabelWidth() {
        return Math.max(this.mm_serviceName.getMinimumLabelWidth(), this.mm_package.getMinimumLabelWidth());
    }

    public void setProject(IProject project) {
        this.mm_project = project;
    }

    public boolean isClassNameValid() {
        String value = this.getServiceName();
        if (value == null) {
            return false;
        }
        if (value.length() == 0) {
            return false;
        }
        if (!Character.isUpperCase(value.charAt(0))) {
            return false;
        }
        return JavaIdentifier.isValidJavaIdentifier(value);
    }

    public boolean isPackageNameValid() {
        if (this.getPackage() == null || this.getPackage().trim().equals("")) {
            return false;
        }
        return JavaIdentifier.isValidOrEmptyPackageName(this.getPackage());
    }

    public boolean isAliasValid() {
        return this.getAlias() != null && !this.getAlias().trim().equals("");
    }

    public boolean isValid() {
        return this.isPackageNameValid() && this.isClassNameValid() && this.isAliasValid();
    }
}

