/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.gui.swt;

import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.Labeled;
import com.sap.portal.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.portal.developmentTools.general.gui.swt.LabeledBrowsableTextField;
import com.sap.portal.developmentTools.general.gui.swt.Validateable;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webwsdl.WebWsdlWizard;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class WebWsdlComposite
extends Composite
implements Labeled,
Validateable {
    public static String mm_interfaceName = null;
    private LabeledBrowsableTextField mm_packageNameField;
    private Label mm_label;
    private IProject mm_project;
    private IGUI mm_guiSystem = OpentoolsFactory.getGuiSystem();

    public WebWsdlComposite(Composite parent, int style, Object project) {
        super(parent, style);
        this.mm_project = (IProject)project;
        try {
            this.init();
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            this.mm_guiSystem.showErrorMessage("Error", "Error initializing the wsdl browse composite.", e);
        }
    }

    public void setProject(IProject project) {
        this.mm_project = project;
    }

    private void init() throws Exception {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        int widthHint = 520;
        GridData data = new GridData(256);
        data.widthHint = Math.max(widthHint, this.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.setLayoutData(data);
        this.redraw();
        IDESettings is = IDESettings.getInstance();
        this.mm_packageNameField = new LabeledBrowsableTextField(this, 0, "&Wsdl file name:");
        this.mm_packageNameField.setToolTipText("Browse for Wsdl files");
        this.mm_packageNameField.setValue(is.getURLWSDL(this.mm_project));
        this.mm_packageNameField.setFileSelectionMode(0);
        this.mm_packageNameField.setFilterNames(new String[]{"*.wsdl - web services file"});
        this.mm_packageNameField.setFilterExtensions(new String[]{"*.wsdl"});
        this.mm_packageNameField.setDialogFlags(4100);
        if (WebWsdlWizard.mm_clientServer == 1) {
            this.mm_label = new Label((Composite)this, 0);
            this.mm_label.setText("The choosen WSDL will be copied as it is.\nYou may need to do some modifications to use it.");
        }
        super.setLayoutData((Object)data);
        this.alignLabels();
    }

    private void alignLabels() {
        LabeledThingsGroup labelGroup = new LabeledThingsGroup();
        labelGroup.add(this.mm_packageNameField);
        labelGroup.alignTextFields();
    }

    public String getWsdlUrl() {
        return this.mm_packageNameField.getValue();
    }

    public String validate() {
        return null;
    }

    public void addModifyListener(ModifyListener listener) {
        this.mm_packageNameField.getTextField().addModifyListener(listener);
    }

    public boolean isClassNameValid() {
        return true;
    }

    public boolean isPackageNameValid() {
        return false;
    }

    public boolean isValid() {
        return this.isPackageNameValid() && this.isClassNameValid();
    }

    public void setLabelWidth(int width) {
        this.mm_packageNameField.setLabelWidth(width);
    }

    public int getMinimumLabelWidth() {
        return 0;
    }

    public void setForbiddenClassNames(Set classNames) {
    }
}

