/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.gui.swt;

import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.Labeled;
import com.sap.portal.developmentTools.general.gui.swt.Validateable;
import com.sap.portal.developmentTools.general.webservices.MethodRep;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import com.sapportals.portal.prt.service.soap.wsdl.JavaToWsdl;
import com.sapportals.portal.prt.service.soap.wsdl.MethodDesc;
import com.sapportals.portal.prt.service.soap.wsdl.ParamDesc;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WebServicesStepOneComposite
extends Composite
implements Labeled,
Validateable {
    private Composite myComposite;
    private JavaToWsdl mm_generator;
    private Vector mm_methods = null;
    private Vector mm_namemethods = new Vector();
    private Vector checkedButtons = new Vector();
    private IGUI guiSystem = OpentoolsFactory.getGuiSystem();

    public WebServicesStepOneComposite(Composite parent, int style, JavaToWsdl generator) {
        super(parent, style);
        this.myComposite = parent;
        this.mm_generator = generator;
        try {
            this.init();
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            this.guiSystem.showErrorMessage("Error", "An error occurred initializing the step one composite", e, this.getShell());
        }
    }

    private void init() throws Exception {
        ScrolledComposite scrolledPane = new ScrolledComposite(this.myComposite, 2816);
        Composite methods = new Composite((Composite)scrolledPane, 0);
        scrolledPane.setContent((Control)methods);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        scrolledPane.setLayout((Layout)layout);
        scrolledPane.setAlwaysShowScrollBars(true);
        if (this.mm_generator != null) {
            this.constructListMethod();
            Enumeration enumeration = this.mm_namemethods.elements();
            while (enumeration.hasMoreElements()) {
                MethodRep element = (MethodRep)enumeration.nextElement();
                Button methodButton = new Button(methods, 32);
                this.checkedButtons.add(methodButton);
                methodButton.setSelection(false);
                methodButton.forceFocus();
                if (element.getComplexType()) {
                    methodButton.setText(element.getSignature() + "**");
                } else {
                    methodButton.setText(element.getSignature());
                }
                methodButton.setToolTipText(element.getSignature());
            }
        }
        methods.setSize(methods.computeSize(400, 100));
        Text text = new Text(this.myComposite, 8);
        text.setText("** are for complex methods");
        Button select = new Button(this.myComposite, 8);
        select.setText("Select All");
        Button unselect = new Button(this.myComposite, 8);
        unselect.setText("Unselect All");
    }

    public String validate() {
        return null;
    }

    public void addModifyListener(ModifyListener listener) {
    }

    public boolean isValid() {
        return true;
    }

    public void setLabelWidth(int width) {
    }

    public int getMinimumLabelWidth() {
        return 25;
    }

    private void constructListMethod() {
        this.mm_methods = this.mm_generator.getMethods();
        boolean complexMethod = false;
        int i = 0;
        while (i < this.mm_methods.size()) {
            complexMethod = false;
            MethodDesc m = (MethodDesc)this.mm_methods.get(i);
            String namemethod = m.getName();
            Vector params = m.getParameters();
            namemethod = namemethod + "( ";
            int j = 0;
            while (j < params.size()) {
                ParamDesc p = (ParamDesc)params.get(j);
                namemethod = namemethod + this.cleanNameClass(p.getType()) + " , ";
                if (!p.getType().isArray() && !ToolKit.existsSerializerForType((Class)p.getType())) {
                    complexMethod = true;
                }
                ++j;
            }
            if (params.size() > 0) {
                namemethod = namemethod.substring(0, namemethod.length() - 3);
            }
            namemethod = namemethod + " ) :" + this.cleanNameClass(m.getReturns().getType());
            if (!m.getReturns().getType().isArray() && !ToolKit.existsSerializerForType((Class)m.getReturns().getType())) {
                complexMethod = true;
            }
            MethodRep mrep = new MethodRep(namemethod);
            mrep.setComplexType(complexMethod);
            this.mm_namemethods.addElement(mrep);
            ++i;
        }
    }

    private String cleanNameClass(Class clazz) {
        String type = clazz.getName();
        if (clazz.isArray()) {
            String newtype = "";
            switch (type.charAt(1)) {
                case 'B': {
                    newtype = "byte";
                    break;
                }
                case 'C': {
                    newtype = "char";
                    break;
                }
                case 'D': {
                    newtype = "double";
                    break;
                }
                case 'F': {
                    newtype = "float";
                    break;
                }
                case 'I': {
                    newtype = "int";
                    break;
                }
                case 'J': {
                    newtype = "long";
                    break;
                }
                case 'L': {
                    newtype = type.substring(2, type.length() - 1);
                    break;
                }
                case 'S': {
                    newtype = "short";
                    break;
                }
                case 'Z': {
                    newtype = "boolean";
                    break;
                }
                case 'V': {
                    newtype = "void";
                    break;
                }
                default: {
                    newtype = "String";
                }
            }
            return newtype + "[]";
        }
        StringTokenizer ps = new StringTokenizer(type, ".");
        if (ps.countTokens() > 1) {
            String newtype = "";
            while (ps.hasMoreElements()) {
                newtype = ps.nextToken();
            }
            return newtype;
        }
        return type;
    }
}

