/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.gui.swt;

import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.Labeled;
import com.sap.portal.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.portal.developmentTools.general.gui.swt.LabeledBrowsableTextField;
import com.sap.portal.developmentTools.general.gui.swt.LabeledTextField;
import com.sap.portal.developmentTools.general.gui.swt.Validateable;
import com.sap.portal.developmentTools.general.wizards.webservices.IWebservicesWizardStringLiterals;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webservices.WebServicesPropertiesWizardPage;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import com.sapportals.portal.prt.service.soap.wsdl.JavaToWsdl;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class WebServicesPropertiesComposite
extends Composite
implements Labeled,
Validateable,
IWebservicesWizardStringLiterals {
    private Button mm_getterSetter;
    private LabeledTextField mm_targetNameSpace;
    private LabeledTextField mm_serviceName;
    private LabeledTextField mm_aliasName;
    private LabeledBrowsableTextField mm_output;
    private LabeledTextField mm_locationImport;
    private LabeledTextField mm_locationURL;
    private JavaToWsdl mm_generator = null;
    private String mm_nameService;
    private Object mm_project;
    private WebServicesPropertiesWizardPage mm_page;
    private IGUI mm_guiSystem = OpentoolsFactory.getGuiSystem();

    public WebServicesPropertiesComposite(WebServicesPropertiesWizardPage page, Composite parent, int style, Object project, JavaToWsdl generator, String nameService) {
        super(parent, style);
        this.mm_project = project;
        this.mm_generator = generator;
        this.mm_nameService = nameService;
        this.mm_page = page;
        try {
            this.init();
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            this.mm_guiSystem.showErrorMessage("Error", "An error occurred initializing the properties composite", e, this.getShell());
        }
    }

    private void init() throws Exception {
        Composite container = super.getParent();
        container.setLayout((Layout)new GridLayout());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        String output = this.mm_generator.getOutput();
        output = "." + File.separator + IWebservicesWizardStringLiterals.DIST_PORTALINF + output.substring(output.indexOf("." + File.separator) + 2);
        this.mm_targetNameSpace = new LabeledTextField(this, 0, "Target Name Space");
        this.mm_targetNameSpace.setValue(this.mm_generator.getNamespace());
        this.mm_targetNameSpace.setEnabled(true);
        this.mm_serviceName = new LabeledTextField(this, 0, "Service Name");
        this.mm_serviceName.setValue(this.mm_generator.getNameClazz());
        this.mm_serviceName.setEnabled(false);
        this.mm_aliasName = new LabeledTextField(this, 0, "Alias Name");
        this.mm_aliasName.setValue("com.sap.portal.prt.soap." + this.mm_generator.getPortTypeName());
        this.mm_aliasName.addModifyListener(new MyModifyListener());
        this.mm_output = new LabeledBrowsableTextField(this, 0, "Output");
        this.mm_output.setFilterExtensions(new String[]{".wsdl"});
        this.mm_output.setValue(output);
        this.mm_output.addModifyListener(new MyModifyAdapter());
        this.mm_locationImport = new LabeledTextField(this, 0, "Location Import");
        this.mm_locationImport.setValue("");
        this.mm_locationURL = new LabeledTextField(this, 0, "Location URL");
        this.mm_locationURL.setValue(this.mm_generator.getLocationPort() + this.mm_aliasName.getValue());
        this.mm_locationURL.setEnabled(false);
        this.mm_getterSetter = new Button((Composite)this, 32);
        this.mm_getterSetter.setText("Enable the getter/setter limitation");
        this.mm_getterSetter.setSelection(true);
        this.alignLabels();
    }

    private void alignLabels() {
        LabeledThingsGroup labelGroup = new LabeledThingsGroup();
        labelGroup.add(this.mm_targetNameSpace);
        labelGroup.add(this.mm_serviceName);
        labelGroup.add(this.mm_aliasName);
        labelGroup.add(this.mm_output);
        labelGroup.add(this.mm_locationImport);
        labelGroup.add(this.mm_locationURL);
        labelGroup.alignTextFields();
    }

    public String getTargetNameSpace() {
        return this.mm_targetNameSpace.getValue();
    }

    public String getServiceName() {
        return this.mm_serviceName.getValue();
    }

    public String getAliasName() {
        return this.mm_aliasName.getValue();
    }

    public String getOutput() {
        return this.mm_output.getValue();
    }

    public String getLocationImport() {
        return this.mm_locationImport.getValue();
    }

    public String getLocationURL() {
        return "http://localhost:8100" + this.mm_locationURL.getValue();
    }

    public boolean getGetterSetter() {
        return this.mm_getterSetter.getSelection();
    }

    public boolean getGenerateProxy() {
        return false;
    }

    public boolean getSecurity() {
        return true;
    }

    public String validate() {
        return null;
    }

    public void addModifyListener(ModifyListener listener) {
    }

    public boolean isValid() {
        return true;
    }

    public void setLabelWidth(int width) {
    }

    public int getMinimumLabelWidth() {
        return 25;
    }

    public void setProject(IProject project) {
        this.mm_project = project;
    }

    class MyModifyAdapter
    implements ModifyListener {
        MyModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            WebServicesPropertiesComposite.this.mm_page.setPageComplete(false);
        }
    }

    class MyModifyListener
    implements ModifyListener {
        MyModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            WebServicesPropertiesComposite.this.mm_locationURL.setValue(WebServicesPropertiesComposite.this.mm_generator.getLocationPort() + WebServicesPropertiesComposite.this.mm_aliasName.getValue());
            WebServicesPropertiesComposite.this.mm_page.setPageComplete(false);
        }
    }
}

