/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.gui.swt;

import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.Labeled;
import com.sap.portal.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.portal.developmentTools.general.gui.swt.LabeledInterfaceBrowsableTextField;
import com.sap.portal.developmentTools.general.gui.swt.Validateable;
import com.sap.portal.developmentTools.general.wizards.webservices.IWebservicesWizardStringLiterals;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class WebServicesInterfaceComposite
extends Composite
implements Labeled,
Validateable,
IWebservicesWizardStringLiterals {
    public static String mm_interfaceName = null;
    private LabeledInterfaceBrowsableTextField packageNameField;
    private IProject project;
    private IGUI guiSystem = OpentoolsFactory.getGuiSystem();

    public WebServicesInterfaceComposite(Composite parent, int style, Object project) {
        super(parent, style);
        this.project = (IProject)project;
        try {
            this.init();
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            this.guiSystem.showErrorMessage("Error", "Error initializing the interface composite.", e);
        }
    }

    private void init() throws Exception {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.packageNameField = new LabeledInterfaceBrowsableTextField(this, 0, "Interface Path:", this.project);
        super.setLayoutData((Object)new GridData(768));
        this.alignLabels();
    }

    private void alignLabels() {
        LabeledThingsGroup labelGroup = new LabeledThingsGroup();
        labelGroup.add(this.packageNameField);
        labelGroup.alignTextFields();
    }

    public String getClassPackage() {
        String total = this.packageNameField.getValue();
        if (!total.equalsIgnoreCase("") && total != null) {
            total = total.substring(1);
            total = total.substring(total.indexOf(File.separator) + 1, total.lastIndexOf("."));
            total = total.substring(total.indexOf(File.separator) + 1).replace(File.separatorChar, '.');
        }
        mm_interfaceName = total.substring(total.lastIndexOf(".") + 1);
        return total;
    }

    public String getClassName() {
        String total = this.packageNameField.getValue();
        if (!total.equalsIgnoreCase("") && total != null) {
            total.substring(total.lastIndexOf(File.separator) + 1, total.lastIndexOf("."));
        }
        return total;
    }

    public String getEnteredValue() {
        return this.packageNameField.getValue();
    }

    public void setProject(IProject project) {
        this.project = project;
        this.packageNameField.setProject(project);
        this.packageNameField.setValue("");
    }

    public String validate() {
        return null;
    }

    public void addModifyListener(ModifyListener listener) {
        this.packageNameField.getTextField().addModifyListener(listener);
    }

    public boolean isClassNameValid() {
        return true;
    }

    public boolean isPackageNameValid() {
        return false;
    }

    public boolean isValid() {
        return this.isPackageNameValid() && this.isClassNameValid();
    }

    public void setLabelWidth(int width) {
        this.packageNameField.setLabelWidth(width);
    }

    public int getMinimumLabelWidth() {
        return 0;
    }

    public void setForbiddenClassNames(Set classNames) {
    }
}

