/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.gui.swt;

import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.Labeled;
import com.sap.portal.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.portal.developmentTools.general.gui.swt.LabeledBrowsableTextField;
import com.sap.portal.developmentTools.general.gui.swt.LabeledInterfaceClassBrowsableTextField;
import com.sap.portal.developmentTools.general.gui.swt.LabeledTextField;
import com.sap.portal.developmentTools.general.gui.swt.Validateable;
import com.sap.portal.developmentTools.general.wizards.webservices.IWebservicesWizardStringLiterals;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class WebSerializerComposite
extends Composite
implements Labeled,
Validateable,
IWebservicesWizardStringLiterals {
    public static String mm_interfaceName = null;
    private LabeledInterfaceClassBrowsableTextField mm_packageNameField;
    private LabeledTextField mm_alias;
    private IProject mm_project;
    private IGUI mm_guiSystem = OpentoolsFactory.getGuiSystem();
    private LabeledBrowsableTextField mm_wsdlField;
    private Button mm_getterSetter;
    private Label mm_labelWsdl;

    public WebSerializerComposite(Composite parent, int style, Object project) {
        super(parent, style);
        this.mm_project = (IProject)project;
        try {
            this.init();
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            this.mm_guiSystem.showErrorMessage("Error", "Error initializing the serializer composite.", e);
        }
    }

    private void init() throws Exception {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.mm_packageNameField = new LabeledInterfaceClassBrowsableTextField(this, 0, "Path:", this.mm_project);
        this.mm_alias = new LabeledTextField(this, 0, "Service Alias");
        this.mm_alias.setLayoutData(new GridData(768));
        Group group = new Group((Composite)this, 32);
        group.setText("WSDL");
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        this.mm_labelWsdl = new Label((Composite)group, 0);
        this.mm_labelWsdl.setText("Enter the Wsdl file (No URL allowed) you want to update with this serializer - Optional");
        String path = this.mm_project.getLocation().toOSString() + File.separator + "dist" + File.separator + "PORTAL-INF" + File.separator;
        this.mm_wsdlField = new LabeledBrowsableTextField((Composite)group, 0, "&Wsdl file name:");
        this.mm_wsdlField.setToolTipText("Browse for Wsdl files");
        this.mm_wsdlField.setFileSelectionMode(0);
        this.mm_wsdlField.setFilterNames(new String[]{"*.wsdl - web services file"});
        this.mm_wsdlField.setFilterExtensions(new String[]{"*.wsdl"});
        this.mm_wsdlField.setInitalDirectory(path.replace('\\', '/'));
        this.mm_wsdlField.setDialogFlags(4100);
        this.mm_getterSetter = new Button((Composite)this, 32);
        this.mm_getterSetter.setText("Enable the getter/setter limitation");
        this.mm_getterSetter.setSelection(true);
        super.setLayoutData((Object)new GridData(768));
        this.alignLabels();
    }

    public void setProject(IProject project) {
        this.mm_project = project;
        this.mm_packageNameField.setProject(project);
    }

    private void alignLabels() {
        LabeledThingsGroup labelGroup = new LabeledThingsGroup();
        labelGroup.add(this.mm_packageNameField);
        labelGroup.add(this.mm_alias);
        labelGroup.add(this.mm_wsdlField);
        labelGroup.alignTextFields();
    }

    public String getClassPackage() {
        String total = this.mm_packageNameField.getValue();
        if (!total.equalsIgnoreCase("") && total != null) {
            total = total.substring(1);
            total = total.substring(total.indexOf(File.separator) + 1, total.lastIndexOf("."));
            total = total.substring(total.indexOf(File.separator) + 1).replace(File.separatorChar, '.');
        }
        mm_interfaceName = total.substring(total.lastIndexOf(".") + 1);
        return total;
    }

    public String getClassName() {
        String total = this.mm_packageNameField.getValue();
        if (!total.equalsIgnoreCase("") && total != null) {
            total.substring(total.lastIndexOf(File.separator) + 1, total.lastIndexOf("."));
        }
        return total;
    }

    public String getAliasName() {
        return this.mm_alias.getValue();
    }

    public String getEnteredValue() {
        return this.mm_packageNameField.getValue();
    }

    public boolean getGetterSetterLimitation() {
        return this.mm_getterSetter.getSelection();
    }

    public String getWsdlPath() {
        return this.mm_wsdlField.getValue();
    }

    public String validate() {
        return null;
    }

    public void addModifyListener(ModifyListener listener) {
        this.mm_packageNameField.getTextField().addModifyListener(listener);
        this.mm_alias.getTextField().addModifyListener(listener);
    }

    public boolean isClassNameValid() {
        return true;
    }

    public boolean isPackageNameValid() {
        return false;
    }

    public boolean isValid() {
        return this.isPackageNameValid() && this.isClassNameValid();
    }

    public void setLabelWidth(int width) {
        this.mm_packageNameField.setLabelWidth(width);
    }

    public int getMinimumLabelWidth() {
        return 0;
    }

    public void setForbiddenClassNames(Set classNames) {
    }
}

