/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.gui.swt;

import com.sap.portal.developmentTools.general.wizards.configurationWizard.IConfigurationWizardStringLiterals;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class TCPPortFieldEditor
extends IntegerFieldEditor
implements IConfigurationWizardStringLiterals {
    public TCPPortFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected boolean checkState() {
        Text text = this.getTextControl();
        if (text == null) {
            return false;
        }
        String numberString = text.getText();
        try {
            int number = Integer.valueOf(numberString);
            if (number >= 0 && number <= 16129) {
                this.clearErrorMessage();
                return true;
            }
            this.showErrorMessage();
            return false;
        }
        catch (NumberFormatException e1) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e1);
            this.showErrorMessage();
            return false;
        }
    }

    public void showErrorMessage() {
        this.showErrorMessage("TCP port addresses must be numbers in the range of 0 to 65535");
    }
}

