/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.gui.swt;

import com.sap.portal.developmentTools.general.api.IDE;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.Labeled;
import com.sap.portal.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.portal.developmentTools.general.gui.swt.LabeledComboBox;
import com.sap.portal.developmentTools.general.gui.swt.LabeledPackageBrowsableTextField;
import com.sap.portal.developmentTools.general.gui.swt.LabeledTextField;
import com.sap.portal.developmentTools.general.gui.swt.Validateable;
import com.sap.portal.developmentTools.general.wizards.sapwizard.ISAPWWizardStringLiterals;
import com.sap.portal.util.JavaIdentifier;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SpecifyClassAndPackageComposite
extends Composite
implements ISAPWWizardStringLiterals,
Labeled,
Validateable {
    private LabeledTextField mm_classNameField;
    private LabeledPackageBrowsableTextField mm_packageNameField;
    private LabeledTextField mm_portalComponentNameField;
    private LabeledComboBox mm_locationField;
    private Object mm_project;
    private Set mm_forbiddenClassNames = new HashSet();
    private int mm_componentService;
    private boolean mm_isEmptyPackageNameAllowed = true;

    public SpecifyClassAndPackageComposite(int componentService, Composite parent, int style, Object project) {
        super(parent, style);
        this.mm_project = project;
        this.mm_componentService = componentService;
        try {
            this.init();
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
        }
    }

    private void init() throws Exception {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        if (this.mm_componentService == 0 || this.mm_componentService == 2) {
            this.mm_portalComponentNameField = new LabeledTextField(this, 0, "Name:");
            this.mm_portalComponentNameField.setValue("");
            this.mm_portalComponentNameField.addModifyListener(new MyModifyListener());
            String coreObject = "Core";
            String apiObject = "API";
            Object[] apiCore = new Object[]{coreObject, apiObject};
            this.mm_locationField = new LabeledComboBox(this, 0, "Location:", apiCore, coreObject, false);
            this.mm_classNameField = new LabeledTextField(this, 0, "Class name:");
            this.mm_classNameField.setToolTipText("The name of the Application Component class you want to create");
            IDE ideInstance = OpentoolsFactory.getIDEInstance();
            IFolder[] sourceFolders = new IFolder[ideInstance.getSourcePathCount(this.mm_project)];
            int i = 0;
            while (i < sourceFolders.length) {
                File sourceFolderNow = ideInstance.getSrcPath(this.mm_project, i);
                String relativePath = sourceFolderNow.getAbsolutePath().substring(ideInstance.getCurrentProjectFolder(this.mm_project).length());
                sourceFolders[i] = ((IProject)this.mm_project).getFolder((IPath)new Path(relativePath));
                ++i;
            }
            this.mm_packageNameField = new LabeledPackageBrowsableTextField(this, 0, "Package name:   ", sourceFolders, null);
            this.mm_packageNameField.setToolTipText("The name of the package the class will reside in");
        } else {
            this.mm_portalComponentNameField = new LabeledTextField(this, 0, "Name:");
            this.mm_portalComponentNameField.setValue("");
            this.mm_portalComponentNameField.addModifyListener(new MyModifyListener());
            this.mm_classNameField = new LabeledTextField(this, 0, "Class name:");
            this.mm_classNameField.setToolTipText("The name of the Application Component class you want to create");
            IDE ideInstance = OpentoolsFactory.getIDEInstance();
            IFolder[] sourceFolders = new IFolder[ideInstance.getSourcePathCount(this.mm_project)];
            int i = 0;
            while (i < sourceFolders.length) {
                File sourceFolderNow = ideInstance.getSrcPath(this.mm_project, i);
                String relativePath = sourceFolderNow.getAbsolutePath().substring(ideInstance.getCurrentProjectFolder(this.mm_project).length());
                sourceFolders[i] = ((IProject)this.mm_project).getFolder((IPath)new Path(relativePath));
                ++i;
            }
            this.mm_packageNameField = new LabeledPackageBrowsableTextField(this, 0, "Package name:   ", sourceFolders, null);
            this.mm_packageNameField.setToolTipText("The name of the package the class will reside in");
        }
        super.setLayoutData((Object)new GridData(768));
        this.alignLabels();
    }

    private void alignLabels() {
        LabeledThingsGroup labelGroup = new LabeledThingsGroup();
        labelGroup.add(this.mm_portalComponentNameField);
        if (this.mm_componentService == 0 || this.mm_componentService == 2) {
            labelGroup.add(this.mm_locationField);
        }
        labelGroup.add(this.mm_classNameField);
        labelGroup.add(this.mm_packageNameField);
        labelGroup.alignTextFields();
    }

    public void setEmptyPackageNameAllowed(boolean emptyPackageNameAllowed) {
        this.mm_isEmptyPackageNameAllowed = emptyPackageNameAllowed;
    }

    public void setClassLabel(String label) {
        this.mm_classNameField.setLabelText(label);
        this.alignLabels();
    }

    public void setClassToolTip(String toolTip) {
        this.mm_classNameField.setToolTipText(toolTip);
    }

    public void setPackageLabel(String label) {
        this.mm_packageNameField.setLabelText(label);
        this.alignLabels();
    }

    public void setPackageToolTip(String toolTip) {
        this.mm_packageNameField.setToolTipText(toolTip);
    }

    public String getPortalComponentType() {
        switch (this.mm_componentService) {
            case 0: {
                return "Component";
            }
            case 1: {
                return "Service";
            }
            case 2: {
                return "TestComponent";
            }
        }
        return null;
    }

    public String getPortalComponentName() {
        return this.mm_portalComponentNameField.getValue();
    }

    public String getLocationField() {
        if (this.mm_componentService == 0 || this.mm_componentService == 2) {
            return this.mm_locationField.getValue();
        }
        return null;
    }

    public String getClassName() {
        return this.mm_classNameField.getValue();
    }

    public String getPackageName() {
        return this.mm_packageNameField.getValue();
    }

    public void setClassName(String className) {
        this.mm_classNameField.setValue(className);
    }

    public String getFullyQualifiedClassName() {
        String packageName = this.getPackageName();
        if (packageName == null) {
            packageName = "";
        }
        if (!(packageName = packageName.trim()).equals("")) {
            packageName = packageName + ".";
        }
        return packageName + this.getClassName();
    }

    public String getFullyQualifiedClassNameApi() {
        String packageName = this.getPackageName();
        if (packageName == null) {
            packageName = "";
        }
        if (!(packageName = packageName.trim()).equals("")) {
            packageName = packageName + ".";
        }
        return packageName + "I" + this.getClassName();
    }

    public String validate() {
        if (!this.isClassNameValid()) {
            return this.mm_classNameField.getLabelText() + " must contain a valid Java class name.";
        }
        if (!this.isPackageNameValid()) {
            if (this.mm_packageNameField.getValue() == null || this.mm_packageNameField.getValue().trim().equals("")) {
                return this.mm_packageNameField.getLabelText() + " cannot be empty.";
            }
            return this.mm_packageNameField.getLabelText() + " must contain a valid package name.";
        }
        if (this.mm_portalComponentNameField.getValue().equalsIgnoreCase("") || this.mm_portalComponentNameField.getValue() == null) {
            return this.mm_portalComponentNameField.getLabelText() + " cannot be empty.";
        }
        String fullyQualifiedClassName = this.getFullyQualifiedClassName();
        if (this.mm_forbiddenClassNames.contains(fullyQualifiedClassName)) {
            return fullyQualifiedClassName + " already exists in the project";
        }
        return null;
    }

    public void addModifyListener(ModifyListener listener) {
        this.mm_classNameField.getTextField().addModifyListener(listener);
        this.mm_packageNameField.getTextField().addModifyListener(listener);
    }

    public boolean isClassNameValid() {
        if (!JavaIdentifier.isValidJavaIdentifier(this.getClassName())) {
            return false;
        }
        return !this.getClassName().equalsIgnoreCase("Service") || this.mm_componentService != 1;
    }

    public boolean isPackageNameValid() {
        if (!this.mm_isEmptyPackageNameAllowed && (this.mm_packageNameField.getValue() == null || this.mm_packageNameField.getValue().trim().equals(""))) {
            return false;
        }
        return JavaIdentifier.isValidOrEmptyPackageName(this.mm_packageNameField.getValue());
    }

    public boolean isValid() {
        return this.isPackageNameValid() && this.isClassNameValid();
    }

    public void setLabelWidth(int width) {
        this.mm_classNameField.setLabelWidth(width);
        this.mm_packageNameField.setLabelWidth(width);
    }

    public int getMinimumLabelWidth() {
        return Math.max(this.mm_classNameField.getMinimumLabelWidth(), this.mm_packageNameField.getMinimumLabelWidth());
    }

    public void setForbiddenClassNames(Set classNames) {
        this.mm_forbiddenClassNames = classNames == null ? new HashSet() : classNames;
    }

    class MyModifyListener
    implements ModifyListener {
        MyModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            SpecifyClassAndPackageComposite.this.mm_classNameField.setValue(SpecifyClassAndPackageComposite.this.mm_portalComponentNameField.getValue());
        }
    }
}

