/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.gui.swt;

import com.sap.portal.developmentTools.general.AbstractProfile;
import com.sap.portal.developmentTools.general.AbstractProfiles;
import com.sap.portal.developmentTools.general.gui.Labeled;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.parServiceRefManager.AddProfileOpeningMiniDialog;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.parServiceRefManager.customProfileAttributeDialog.CustomProfileAttributesDialog;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ProfileSelectorComposite
extends Composite
implements Labeled {
    private Combo combo;
    private Label label;
    private Object project;
    private AbstractProfiles profiles;
    private boolean allowNoProfileSelection;
    private Button newProfileButton;
    public static final String NO_PROFILE_NAME = "<none>";

    public ProfileSelectorComposite(Composite parent, int style, boolean showNewProfileButton, boolean allowNoProfileSelection, final AbstractProfiles profiles) throws Exception {
        super(parent, style);
        this.allowNoProfileSelection = allowNoProfileSelection;
        this.profiles = profiles;
        GridLayout layout = new GridLayout();
        layout.numColumns = showNewProfileButton ? 3 : 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        this.setLayout((Layout)layout);
        this.label = new Label((Composite)this, 0);
        this.label.setLayoutData((Object)new GridData());
        this.label.setText("Please select a &profile: ");
        this.combo = new Combo((Composite)this, 12);
        this.setComboFillHorizontal();
        this.repopulateCombo();
        if (showNewProfileButton) {
            this.newProfileButton = new Button((Composite)this, 0);
            this.newProfileButton.setText("&New...");
            this.newProfileButton.setToolTipText("Creates a new profile.");
            this.newProfileButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    try {
                        AddProfileOpeningMiniDialog profDialog = new AddProfileOpeningMiniDialog(ProfileSelectorComposite.this.getShell(), profiles);
                        profDialog.setSelectedInvokeProfileEditorAfterCreation(false);
                        if (profDialog.open() == 0) {
                            AbstractProfile newProfile = profDialog.createTheNewProfile();
                            if (profDialog.invokeProfileEditorEnabled()) {
                                CustomProfileAttributesDialog dialog = new CustomProfileAttributesDialog(ProfileSelectorComposite.this.getShell(), newProfile, ProfileSelectorComposite.this.project);
                                dialog.open();
                            }
                            ProfileSelectorComposite.this.repopulateCombo();
                            ProfileSelectorComposite.this.setSelection(newProfile.getName());
                        }
                    }
                    catch (Exception e1) {
                        SapPortalPluginsLogger.logError((Object)this, (Throwable)e1);
                        MessageDialog.openError((Shell)ProfileSelectorComposite.this.getShell(), (String)"Error", (String)("An error occured while processing the profiles.\n\nError message: " + e1.getMessage()));
                    }
                }
            });
        }
        super.setLayoutData((Object)new GridData(768));
    }

    public void setButtonText(String text) {
        this.newProfileButton.setText(text);
    }

    public void repopulateCombo() {
        this.combo.removeAll();
        if (this.allowNoProfileSelection) {
            this.combo.add(NO_PROFILE_NAME);
        }
        Iterator iterator = this.profiles.getProfilesIterator();
        while (iterator.hasNext()) {
            AbstractProfile profile = (AbstractProfile)iterator.next();
            this.combo.add(profile.getName());
        }
        this.combo.setText(this.combo.getItem(0));
    }

    public AbstractProfiles getProfiles() {
        return this.profiles;
    }

    public void addItem(String item) {
        this.combo.add(item);
    }

    public void setSelection(int index) {
        this.combo.select(index);
    }

    public void setSelection(String item) {
        this.combo.setText(item);
    }

    public void addItems(List items) {
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            this.combo.add(o.toString());
        }
    }

    public void setLabelText(String text) {
        this.label.setText(text);
    }

    public void setComboFillHorizontal() {
        this.combo.setLayoutData((Object)new GridData(768));
    }

    public void setLabelWidth(int width) {
        ((GridData)this.label.getLayoutData()).widthHint = width;
    }

    public int getMinimumLabelWidth() {
        return this.label.computeSize((int)-1, (int)-1, (boolean)true).x;
    }

    public String getSelectedProfileName() {
        String profileName = this.combo.getText();
        if (profileName.equals(NO_PROFILE_NAME)) {
            return null;
        }
        return profileName;
    }

    public AbstractProfile getSelectedProfile() {
        String profileName = this.getSelectedProfileName();
        if (profileName == null) {
            return null;
        }
        return this.profiles.getProfileByName(profileName);
    }

    public void setProfiles(AbstractProfiles profiles) {
        this.profiles = profiles;
        try {
            this.repopulateCombo();
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
        }
    }
}

