/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.gui.swt;

import com.sap.portal.util.JavaIdentifier;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PackageInputDialog
extends Dialog {
    private static final String INVALID_PACKAGE_NAME_MESSAGE = "Name must be a valid Java package name fragment";
    private static IInputValidator PACKAGE_NAME_VALIDATOR = new IInputValidator(){

        public String isValid(String newText) {
            if (JavaIdentifier.getGenerousPackageName(newText) == null) {
                return PackageInputDialog.INVALID_PACKAGE_NAME_MESSAGE;
            }
            return null;
        }
    };
    private String title = "Add subpackage";
    private String message;
    private String packageNamePrefix;
    private String value = "";
    private IInputValidator validator;
    private Button okButton;
    private Text text;
    private Label errorMessageLabel;

    public PackageInputDialog(Shell parentShell, String packagePrefix, String initialValue) {
        super(parentShell);
        if (packagePrefix == null) {
            packagePrefix = "";
        }
        if ((packagePrefix = packagePrefix.trim()).length() != 0 && !packagePrefix.endsWith(".")) {
            packagePrefix = packagePrefix + ".";
        }
        this.packageNamePrefix = packagePrefix;
        this.message = "Please enter the subpackage name";
        this.value = initialValue == null ? "" : initialValue;
        this.validator = PACKAGE_NAME_VALIDATOR;
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.text.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
            this.text.selectAll();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            data.horizontalSpan = 2;
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        Label packagePrefixLabel = new Label(composite, 0);
        packagePrefixLabel.setText(this.packageNamePrefix);
        packagePrefixLabel.setLayoutData((Object)new GridData(1));
        this.text = new Text(composite, 4);
        GridData layoutData = new GridData(768);
        layoutData.horizontalIndent = -3;
        this.text.setLayoutData((Object)layoutData);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PackageInputDialog.this.validateInput();
            }
        });
        this.errorMessageLabel = new Label(composite, 0);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.errorMessageLabel.setLayoutData((Object)layoutData);
        this.errorMessageLabel.setFont(parent.getFont());
        return composite;
    }

    protected Label getErrorMessageLabel() {
        return this.errorMessageLabel;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected Text getText() {
        return this.text;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.validator != null) {
            errorMessage = this.validator.isValid(this.text.getText());
        }
        this.errorMessageLabel.setText(errorMessage == null ? "" : errorMessage);
        this.okButton.setEnabled(errorMessage == null);
        this.errorMessageLabel.getParent().update();
    }
}

