/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.gui.swt;

import java.util.StringTokenizer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class MultiValuePropertyComposite
extends Composite
implements SelectionListener {
    private Table mm_valuesTable;
    private TableEditor mm_valuesTableEditor;
    private Button mm_addValueButton;
    private Button mm_editValueButton;
    private Button mm_removeValueButton;
    private String mm_initValues;
    private String[] mm_columnName;
    private Composite mm_content;
    private Text mm_text;
    private ModifyListener mm_modifyListener;

    public MultiValuePropertyComposite(Composite parent, int style, String initValues) {
        super(parent, style);
        this.mm_initValues = initValues;
        this.mm_columnName = new String[]{"value"};
        this.init();
    }

    private void init() {
        this.mm_content = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = true;
        this.mm_content.setLayout((Layout)gridLayout);
        this.mm_content.setLayoutData((Object)new GridData(1808));
        this.mm_valuesTable = new Table(this.mm_content, 68098);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 70;
        this.mm_valuesTable.setLayoutData((Object)gridData);
        this.mm_valuesTable.setLinesVisible(true);
        TableColumn column = new TableColumn(this.mm_valuesTable, 0);
        column.setWidth(306);
        this.mm_valuesTableEditor = new TableEditor(this.mm_valuesTable);
        this.mm_addValueButton = new Button(this.mm_content, 0);
        this.mm_addValueButton.setText("Add");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.mm_addValueButton.setLayoutData((Object)gridData);
        this.mm_addValueButton.addSelectionListener((SelectionListener)this);
        this.mm_editValueButton = new Button(this.mm_content, 0);
        this.mm_editValueButton.setText("Edit");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.mm_editValueButton.setLayoutData((Object)gridData);
        this.mm_editValueButton.addSelectionListener((SelectionListener)this);
        this.mm_removeValueButton = new Button(this.mm_content, 0);
        this.mm_removeValueButton.setText("Remove");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.mm_removeValueButton.setLayoutData((Object)gridData);
        this.mm_removeValueButton.addSelectionListener((SelectionListener)this);
        if (this.mm_initValues != null && !this.mm_initValues.trim().equalsIgnoreCase("")) {
            StringTokenizer stk = new StringTokenizer(this.mm_initValues, ",");
            while (stk.hasMoreTokens()) {
                String element = stk.nextToken();
                TableItem item = new TableItem(this.mm_valuesTable, 0);
                item.setText(element);
            }
        }
        this.mm_valuesTable.addListener(8, (Listener)new ListDoubleClickListener());
        this.pack();
    }

    private void handleAddValue() {
        String newValue = "newValue";
        if (this.mm_valuesTable.getSelection() != null && this.mm_valuesTable.getSelection().length == 1) {
            newValue = this.mm_valuesTable.getSelection()[0].getText();
        }
        TableItem item = new TableItem(this.mm_valuesTable, 0);
        item.setText(newValue);
        this.mm_valuesTable.setSelection(this.mm_valuesTable.indexOf(item));
        this.handleEditValue();
    }

    private void handleRemoveValue() {
        int[] items = this.mm_valuesTable.getSelectionIndices();
        if (items != null && items.length > 0) {
            this.mm_valuesTable.remove(items);
        }
    }

    private void handleEditValue() {
        int index;
        Control oldEditor = this.mm_valuesTableEditor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        if ((index = this.mm_valuesTable.getSelectionIndex()) == -1) {
            return;
        }
        TableItem item = this.mm_valuesTable.getItem(index);
        this.mm_text = new Text((Composite)this.mm_valuesTable, 0);
        this.mm_text.setText(item.getText());
        if (this.mm_valuesTableEditor == null) {
            this.mm_valuesTableEditor = new TableEditor(this.mm_valuesTable);
        }
        this.mm_valuesTableEditor.horizontalAlignment = 16384;
        this.mm_valuesTableEditor.grabHorizontal = true;
        this.mm_valuesTableEditor.minimumWidth = 50;
        this.mm_valuesTableEditor.setColumn(0);
        this.mm_valuesTableEditor.setEditor((Control)this.mm_text, item, 0);
        this.mm_text.setFocus();
        this.mm_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.widget;
                if (!text.getText().trim().equals("")) {
                    TableItem selectedItem = MultiValuePropertyComposite.this.mm_valuesTable.getSelection()[0];
                    selectedItem.setText(text.getText());
                }
            }
        });
        this.mm_text.addModifyListener(this.mm_modifyListener);
        this.mm_text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                Text text = (Text)event.widget;
                MultiValuePropertyComposite.this.mm_valuesTable.update();
                text.dispose();
            }
        });
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource().equals(this.mm_addValueButton)) {
            this.handleAddValue();
        } else if (event.getSource().equals(this.mm_editValueButton)) {
            this.handleEditValue();
        } else if (event.getSource().equals(this.mm_removeValueButton)) {
            this.handleRemoveValue();
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void addSelectionListener(SelectionListener listener) {
        this.mm_addValueButton.addSelectionListener(listener);
        this.mm_editValueButton.addSelectionListener(listener);
        this.mm_removeValueButton.addSelectionListener(listener);
        this.mm_valuesTable.addSelectionListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.mm_modifyListener = listener;
    }

    public String getValue() {
        String res = "";
        TableItem[] elements = this.mm_valuesTable.getItems();
        int i = 0;
        while (i < elements.length) {
            res = res + elements[i].getText() + ",";
            ++i;
        }
        if (!res.equals("")) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public void setValue(String newValue) {
        StringTokenizer stk = new StringTokenizer(newValue, ",");
        while (stk.hasMoreTokens()) {
            TableItem item = new TableItem(this.mm_valuesTable, 0);
            item.setText(stk.nextToken());
        }
    }

    class ListDoubleClickListener
    implements Listener {
        ListDoubleClickListener() {
        }

        public void handleEvent(Event event) {
            MultiValuePropertyComposite.this.handleEditValue();
        }
    }
}

