/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.gui.swt;

import com.sap.portal.developmentTools.general.webservices.MethodRep;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import com.sapportals.portal.prt.service.soap.wsdl.JavaToWsdl;
import com.sapportals.portal.prt.service.soap.wsdl.MethodDesc;
import com.sapportals.portal.prt.service.soap.wsdl.ParamDesc;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ListEclipseStylePanel {
    private JavaToWsdl mm_generator = null;
    private Vector mm_methods = null;
    private Vector mm_namemethods = new Vector();
    private final Composite myComposite;
    private final ScrolledComposite ScrolledPane;
    private Vector checkedButtons = new Vector();
    private Composite contentPane;

    public ListEclipseStylePanel(Composite parent, String header, String description, JavaToWsdl generator) {
        if (generator != null) {
            this.mm_generator = generator;
        }
        this.ScrolledPane = new ScrolledComposite(parent, 2816);
        this.myComposite = new Composite((Composite)this.ScrolledPane, 0);
        this.ScrolledPane.setContent((Control)this.myComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.myComposite.setLayout((Layout)layout);
        this.ScrolledPane.setAlwaysShowScrollBars(true);
        if (this.mm_generator != null) {
            this.constructListMethod();
            Enumeration enumeration = this.mm_namemethods.elements();
            while (enumeration.hasMoreElements()) {
                MethodRep element = (MethodRep)enumeration.nextElement();
                Button methodButton = new Button(this.myComposite, 32);
                this.checkedButtons.add(methodButton);
                methodButton.setSelection(false);
                if (element.getComplexType()) {
                    methodButton.setText(element.getSignature() + "**");
                    methodButton.setVisible(true);
                } else {
                    methodButton.setText(element.getSignature());
                    methodButton.setVisible(true);
                }
                methodButton.setToolTipText(element.getSignature());
            }
        }
    }

    public void setSelectAll() {
        Iterator iter = ((AbstractList)this.checkedButtons).iterator();
        while (iter.hasNext()) {
            ((Button)iter.next()).setSelection(true);
        }
    }

    public void setUnselectAll() {
        Iterator iter = ((AbstractList)this.checkedButtons).iterator();
        while (iter.hasNext()) {
            ((Button)iter.next()).setSelection(false);
        }
    }

    public void setTraversalOrderLikeControlOrder() {
        this.contentPane.setTabList(this.contentPane.getChildren());
    }

    public Composite getContentPane() {
        return this.myComposite;
    }

    public ScrolledComposite getTopContainer() {
        return this.ScrolledPane;
    }

    public Vector getCheckedButtons() {
        return this.checkedButtons;
    }

    private void constructListMethod() {
        this.mm_methods = this.mm_generator.getMethods();
        boolean complexMethod = false;
        int i = 0;
        while (i < this.mm_methods.size()) {
            complexMethod = false;
            MethodDesc m = (MethodDesc)this.mm_methods.get(i);
            String namemethod = m.getName();
            Vector params = m.getParameters();
            namemethod = namemethod + "( ";
            int j = 0;
            while (j < params.size()) {
                ParamDesc p = (ParamDesc)params.get(j);
                namemethod = namemethod + this.cleanNameClass(p.getType()) + " , ";
                if (!p.getType().isArray() && !ToolKit.existsSerializerForType((Class)p.getType())) {
                    complexMethod = true;
                }
                ++j;
            }
            if (params.size() > 0) {
                namemethod = namemethod.substring(0, namemethod.length() - 3);
            }
            namemethod = namemethod + " ) :" + this.cleanNameClass(m.getReturns().getType());
            if (!m.getReturns().getType().isArray() && !ToolKit.existsSerializerForType((Class)m.getReturns().getType())) {
                complexMethod = true;
            }
            MethodRep mrep = new MethodRep(namemethod);
            mrep.setComplexType(complexMethod);
            this.mm_namemethods.addElement(mrep);
            ++i;
        }
    }

    private String cleanNameClass(Class clazz) {
        String type = clazz.getName();
        if (clazz.isArray()) {
            String newtype = "";
            switch (type.charAt(1)) {
                case 'B': {
                    newtype = "byte";
                    break;
                }
                case 'C': {
                    newtype = "char";
                    break;
                }
                case 'D': {
                    newtype = "double";
                    break;
                }
                case 'F': {
                    newtype = "float";
                    break;
                }
                case 'I': {
                    newtype = "int";
                    break;
                }
                case 'J': {
                    newtype = "long";
                    break;
                }
                case 'L': {
                    newtype = type.substring(2, type.length() - 1);
                    break;
                }
                case 'S': {
                    newtype = "short";
                    break;
                }
                case 'Z': {
                    newtype = "boolean";
                    break;
                }
                case 'V': {
                    newtype = "void";
                    break;
                }
                default: {
                    newtype = "String";
                }
            }
            return newtype + "[]";
        }
        StringTokenizer ps = new StringTokenizer(type, ".");
        if (ps.countTokens() > 1) {
            String newtype = "";
            while (ps.hasMoreElements()) {
                newtype = ps.nextToken();
            }
            return newtype;
        }
        return type;
    }
}

