/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.gui.swt;

import com.sap.portal.developmentTools.general.gui.Labeled;
import com.sap.portal.developmentTools.general.gui.swt.LabeledBrowsableTextField;
import com.sap.portal.developmentTools.ideSpecific.eclipse.impl.Eclipse2IDE;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class LabeledInterfaceClassBrowsableTextField
extends LabeledBrowsableTextField
implements Labeled {
    private IProject mm_project;

    public LabeledInterfaceClassBrowsableTextField(Composite composite, int compositeConstants, String labelText, Object project) {
        super(composite, compositeConstants, labelText);
        this.mm_project = (IProject)project;
    }

    public void setProject(IProject project) {
        this.mm_project = project;
    }

    protected void handleBrowse() {
        Object[] packageName;
        IPackageFragmentRoot[] packages = null;
        Vector<IPackageFragmentRoot> finalPackages = new Vector<IPackageFragmentRoot>();
        SelectionDialog dlg = null;
        IJavaProject javaProject = Eclipse2IDE.getCurrentJavaProject(this.mm_project);
        try {
            packages = javaProject.getAllPackageFragmentRoots();
            int i = 0;
            while (i < packages.length) {
                IPackageFragmentRoot root = packages[i];
                if (!root.getPath().getFileExtension().equalsIgnoreCase("jar")) {
                    finalPackages.add(root);
                }
                ++i;
            }
        }
        catch (JavaModelException je) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)je);
        }
        Enumeration objects = finalPackages.elements();
        int size = finalPackages.size();
        IPackageFragmentRoot[] pack = new IPackageFragmentRoot[size];
        int j = 0;
        while (objects.hasMoreElements()) {
            IPackageFragmentRoot root;
            pack[j] = root = (IPackageFragmentRoot)objects.nextElement();
            ++j;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])pack, (boolean)true);
        try {
            dlg = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)new ProgressMonitorDialog(this.getShell()), (IJavaSearchScope)scope, (int)6, (boolean)false, (String)"*");
        }
        catch (JavaModelException jme) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)jme);
        }
        dlg.setTitle("Interface & Class");
        dlg.setMessage("Select an Interface or a Class...");
        if (dlg.open() == 0 && (packageName = dlg.getResult()) != null) {
            StringBuffer sb = new StringBuffer();
            if (packageName.length > 0) {
                SourceType type = (SourceType)packageName[0];
                sb.append(type.getPath().toOSString());
            }
            this.setValue(sb.toString());
        }
    }
}

