/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.gui.swt;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileBrowserComposite
extends Composite {
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    private String mm_labelText;
    private Text mm_textField;
    private Button mm_browseButton;
    private FileDialog mm_fileDialog;
    private int mm_fileSelectionMode;
    private int mm_dialogFlags = 8196;
    private String[] mm_filterNames;
    private String[] mm_filterExtensions;
    private String mm_filterPath;
    private IProject mm_project;
    private String mm_initalDirectory;

    public FileBrowserComposite(Composite composite, int style, String labelText, Object project, String filterPath) {
        super(composite, style);
        this.mm_labelText = labelText;
        this.mm_project = (IProject)project;
        this.mm_filterPath = filterPath;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 5;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        super.setLayout((Layout)layout);
        GridData gd = new GridData(32);
        gd = new GridData(768);
        this.mm_textField = new Text((Composite)this, 2052);
        this.mm_textField.setLayoutData((Object)gd);
        gd = new GridData();
        gd.widthHint = 20;
        this.mm_browseButton = new Button((Composite)this, 8);
        this.mm_browseButton.setText("...");
        this.mm_browseButton.setLayoutData((Object)gd);
        this.mm_browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileBrowserComposite.this.handleBrowse();
            }
        });
        super.setLayoutData((Object)new GridData(768));
    }

    protected void handleBrowse() {
        this.mm_fileDialog = new FileDialog(this.getShell(), 4096);
        this.mm_fileDialog.setFilterPath(this.mm_filterPath);
        String fileFullPath = this.mm_fileDialog.open();
        if (fileFullPath != null) {
            String projectFullPath = this.mm_project.getLocation().toOSString();
            int startIndex = fileFullPath.indexOf(this.mm_filterPath) + this.mm_filterPath.length() + 1;
            String filePath = fileFullPath.substring(startIndex, fileFullPath.length());
            Path path = new Path(filePath);
            filePath = path.toString();
            this.mm_textField.setText(filePath);
        }
    }

    public void setFilterNames(String[] filterNames) {
        this.mm_filterNames = filterNames;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.mm_filterExtensions = filterExtensions;
    }

    public void setFilterPath(String filterPath) {
        this.mm_filterPath = filterPath;
    }

    public void setDialogFlags(int dialogFlags) {
        this.mm_dialogFlags = dialogFlags;
    }

    public void setInitalDirectory(String initalDirectory) {
        this.mm_initalDirectory = initalDirectory;
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this.mm_fileSelectionMode = fileSelectionMode;
    }

    public String getValue() {
        return this.mm_textField.getText();
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        this.mm_textField.setText(value);
    }

    public Text getTextField() {
        return this.mm_textField;
    }

    public void addModifyListener(ModifyListener listener) {
        this.mm_textField.addModifyListener(listener);
    }

    public void setEditable(boolean b) {
        this.mm_textField.setEditable(b);
        this.mm_textField.setEnabled(b);
        this.mm_browseButton.setEnabled(b);
    }
}

