/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.gui.swt;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ClassBrowserComposite
extends Composite {
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    private String mm_labelText;
    private Text mm_textField;
    private Button mm_browseButton;
    private int mm_fileSelectionMode;
    private int mm_dialogFlags = 8196;
    private String[] mm_filterNames;
    private String[] mm_filterExtensions;
    private static String mm_filterPath;
    private IProject mm_project;
    private String mm_initalDirectory;

    public ClassBrowserComposite(Composite composite, int style, String labelText, Object project) {
        super(composite, style);
        this.mm_labelText = labelText;
        this.mm_project = (IProject)project;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 5;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        super.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        this.mm_textField = new Text((Composite)this, 2052);
        this.mm_textField.setLayoutData((Object)gd);
        gd = new GridData();
        gd.widthHint = 20;
        this.mm_browseButton = new Button((Composite)this, 8);
        this.mm_browseButton.setText("...");
        this.mm_browseButton.setLayoutData((Object)gd);
        this.mm_browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClassBrowserComposite.this.handleBrowse(ClassBrowserComposite.this.mm_project);
            }
        });
        super.setLayoutData((Object)new GridData(768));
    }

    protected void handleBrowse(IProject project) {
        Object[] packageName;
        IPackageFragmentRoot[] packages = null;
        Vector<IPackageFragmentRoot> finalPackages = new Vector<IPackageFragmentRoot>();
        SelectionDialog dlg = null;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            packages = javaProject.getAllPackageFragmentRoots();
            int i = 0;
            while (i < packages.length) {
                IPackageFragmentRoot root = packages[i];
                if (!root.getPath().getFileExtension().equalsIgnoreCase("jar")) {
                    finalPackages.add(root);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Enumeration objects = finalPackages.elements();
        int size = finalPackages.size();
        IPackageFragmentRoot[] pack = new IPackageFragmentRoot[size];
        int j = 0;
        while (objects.hasMoreElements()) {
            IPackageFragmentRoot root;
            pack[j] = root = (IPackageFragmentRoot)objects.nextElement();
            ++j;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])pack, (boolean)true);
        try {
            dlg = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)new ProgressMonitorDialog(this.getShell()), (IJavaSearchScope)scope, (int)6, (boolean)false, (String)"*");
        }
        catch (JavaModelException jme) {
            jme.printStackTrace();
        }
        dlg.setTitle("Classes");
        dlg.setMessage("Select a Class...");
        if (dlg.open() == 0 && (packageName = dlg.getResult()) != null) {
            StringBuffer sb = new StringBuffer();
            if (packageName.length > 0) {
                SourceType type = (SourceType)packageName[0];
                sb.append(type.getFullyQualifiedName());
            }
            this.setValue(sb.toString());
        }
    }

    public void setFilterNames(String[] filterNames) {
        this.mm_filterNames = filterNames;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.mm_filterExtensions = filterExtensions;
    }

    public void setFilterPath(String filterPath) {
        mm_filterPath = filterPath;
    }

    public void setDialogFlags(int dialogFlags) {
        this.mm_dialogFlags = dialogFlags;
    }

    public void setInitalDirectory(String initalDirectory) {
        this.mm_initalDirectory = initalDirectory;
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this.mm_fileSelectionMode = fileSelectionMode;
    }

    public String getValue() {
        return this.mm_textField.getText();
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        this.mm_textField.setText(value);
    }

    public Text getTextField() {
        return this.mm_textField;
    }

    public void addModifyListener(ModifyListener listener) {
        this.mm_textField.addModifyListener(listener);
    }

    public void setEditable(boolean b) {
        this.mm_textField.setEditable(b);
        this.mm_textField.setEnabled(b);
        this.mm_browseButton.setEnabled(b);
    }
}

