/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general;

import com.sap.portal.developmentTools.general.AbstractProfile;
import com.sap.portal.developmentTools.general.AbstractProfiles;
import com.sap.portal.developmentTools.general.ProfileEP6;
import com.sap.portal.developmentTools.general.Service;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.settings.PDKInstallation;
import com.sapportals.portal.prt.deployment.descriptor.Descriptor;
import com.sapportals.portal.prt.deployment.descriptor.IComponent;
import com.sapportals.portal.prt.deployment.descriptor.IComponentList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProfilesEP6
extends AbstractProfiles {
    private List profiles = new ArrayList();
    private Set referencedServices = new HashSet();
    private Set referencedComponents = new HashSet();
    private Map allServicesByName = new HashMap();
    private List completeServicesList;
    private List completeComponentList;
    private HashMap completeComponentSet = new HashMap();
    private HashMap completeServiceSet = new HashMap();
    private String applicationName = "";
    private Descriptor portalappDescriptor = null;
    private boolean sharingAccess = false;
    ProfileEP6 defaultProfile;
    File portalappXMLFile;

    public ProfilesEP6(Object project, File portalapp, String anApplicationName) throws Exception {
        super(project);
        this.applicationName = anApplicationName;
        this.portalappXMLFile = portalapp;
        this.portalappDescriptor = new Descriptor(this.applicationName);
        IComponentList componentsList = this.portalappDescriptor.getApplication().getComponents();
        int i = 0;
        while (i < componentsList.getLength()) {
            IComponent component = componentsList.item(i);
            ProfileEP6 profNow = new ProfileEP6(this, component);
            this.profiles.add(component);
            if (profNow.getName().equals("default")) {
                this.defaultProfile = profNow;
            }
            ++i;
        }
    }

    private void initServicesAndSharingReferences() throws Exception {
        this.allServicesByName = new HashMap();
        this.completeComponentSet = new HashMap();
        this.completeServiceSet = new HashMap();
        List services = PDKInstallation.getInstance().getInstalledServices();
        Iterator iterator = services.iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            if (service.isAComponent()) {
                this.completeComponentSet.put(service.getName(), service);
            } else {
                this.completeServiceSet.put(service.getName(), service);
            }
            this.allServicesByName.put(service.getName(), service);
        }
        this.addDeclaredServicesToHashMap(this.referencedServices, this.completeServiceSet, false);
        this.addDeclaredServicesToHashMap(this.referencedComponents, this.completeComponentSet, true);
        this.completeServicesList = Collections.unmodifiableList(new ArrayList(this.completeServiceSet.values()));
        this.completeComponentList = Collections.unmodifiableList(new ArrayList(this.completeComponentSet.values()));
    }

    private void addDeclaredServicesToHashMap(Set thisProfilesReferencedServiceNames, HashMap completeServiceSet, boolean isAComponent) {
        Iterator iterator = thisProfilesReferencedServiceNames.iterator();
        while (iterator.hasNext()) {
            String serviceName = (String)iterator.next();
            Service serviceNow = (Service)completeServiceSet.get(serviceName);
            if (serviceNow == null) {
                serviceNow = new Service(serviceName, "Unknown", isAComponent);
                completeServiceSet.put(serviceName, serviceNow);
            }
            this.allServicesByName.put(serviceName, serviceNow);
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public Iterator getProfilesIterator() {
        return this.profiles.iterator();
    }

    public List getProfiles() {
        return Collections.unmodifiableList(this.profiles);
    }

    public Set getReferencedServices() throws Exception {
        if (this.referencedServices == null) {
            this.initServicesAndSharingReferences();
        }
        return this.referencedServices;
    }

    public Set getReferencedComponents() throws Exception {
        if (this.referencedComponents == null) {
            this.initServicesAndSharingReferences();
        }
        return this.referencedComponents;
    }

    public List getCompleteServicesList() throws Exception {
        if (this.completeServicesList == null) {
            this.initServicesAndSharingReferences();
        }
        return this.completeServicesList;
    }

    public List getCompleteComponentList() throws Exception {
        if (this.completeComponentList == null) {
            this.initServicesAndSharingReferences();
        }
        return this.completeComponentList;
    }

    public AbstractProfile addProfile(String name) throws Exception {
        name = name.trim();
        Iterator iterator = this.profiles.iterator();
        while (iterator.hasNext()) {
            ProfileEP6 profile = (ProfileEP6)iterator.next();
            if (!profile.getName().trim().equals(name)) continue;
            throw new Exception("The profile name " + name + " already exists!");
        }
        this.portalappDescriptor.getApplication().getConfiguration().setPropertyValue("component name", name);
        ProfileEP6 newProfile = new ProfileEP6(this, this.portalappDescriptor.getApplication().getComponent(name));
        return newProfile;
    }

    public void addProfile(AbstractProfile aProfile) throws Exception {
        String name = aProfile.getName();
        Iterator iterator = this.profiles.iterator();
        while (iterator.hasNext()) {
            ProfileEP6 profile = (ProfileEP6)iterator.next();
            if (!profile.getName().trim().equals(name)) continue;
            throw new Exception("The profile name " + name + " already exists!");
        }
        this.portalappDescriptor.getApplication().getConfiguration().setPropertyValue("component name", name);
    }

    public boolean removeProfile(String name) {
        throw new NoSuchMethodError();
    }

    public void doSave() throws Exception {
        if (this.defaultProfile == null) {
            this.defaultProfile = (ProfileEP6)this.addProfile("default");
        }
        Iterator iterator = this.profiles.iterator();
        while (iterator.hasNext()) {
            ProfileEP6 profile = (ProfileEP6)iterator.next();
            profile.doSave();
        }
        OpentoolsFactory.getIDEInstance().adjustProjectClassPathTo(this.project, this.getNeededJarFiles(), "referenced");
    }

    public AbstractProfile getProfileByName(String nameWithoutDotProperties) {
        Iterator iterator = this.profiles.iterator();
        while (iterator.hasNext()) {
            ProfileEP6 profile = (ProfileEP6)iterator.next();
            if (!profile.getName().equals(nameWithoutDotProperties)) continue;
            return profile;
        }
        return null;
    }

    public boolean isSharingAccess() {
        return this.sharingAccess;
    }

    public void setSharingAccess(boolean sharingAccess) {
        this.sharingAccess = sharingAccess;
    }

    public List getNeededJarFiles() throws Exception {
        ArrayList retVal = new ArrayList();
        if (this.completeComponentList != null) {
            Iterator iterator = this.referencedComponents.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                Service now = (Service)this.completeComponentSet.get(name);
                if (now == null) continue;
                retVal.addAll(now.getJarFiles());
            }
            Iterator iterator2 = this.referencedServices.iterator();
            while (iterator2.hasNext()) {
                String name = (String)iterator2.next();
                Service now = (Service)this.completeServiceSet.get(name);
                if (now == null) continue;
                retVal.addAll(now.getJarFiles());
            }
        }
        return retVal;
    }

    public int getProfilesCount() {
        return this.profiles.size();
    }
}

