/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general;

import com.sap.portal.developmentTools.general.AbstractProfile;
import com.sap.portal.developmentTools.general.AbstractProfiles;
import com.sap.portal.developmentTools.general.Profile;
import com.sap.portal.developmentTools.general.api.IDE;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Profiles
extends AbstractProfiles {
    private List profiles = new ArrayList();
    private Set referencedServices = new HashSet();
    private Set referencedComponents = new HashSet();
    private boolean sharingAccess = false;
    private Profile defaultProfile;
    private List removedProfileNames = new ArrayList();

    public Profiles(Object project, File[] profileFiles) throws Exception {
        super(project);
        int i = 0;
        while (i < profileFiles.length) {
            File now = profileFiles[i];
            Profile profNow = new Profile(this, now);
            this.profiles.add(profNow);
            if (profNow.getName().equals("default")) {
                this.defaultProfile = profNow;
            }
            ++i;
        }
        if (this.defaultProfile == null) {
            this.defaultProfile = (Profile)this.addProfile("default");
        }
        this.sortProfilesListByName();
    }

    private void sortProfilesListByName() {
        if (this.profiles != null) {
            Collections.sort(this.profiles, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Profile)o1).getName().toLowerCase().compareTo(((Profile)o2).getName().toLowerCase());
                }
            });
        }
    }

    public Iterator getProfilesIterator() {
        return this.profiles.iterator();
    }

    public List getProfiles() {
        return Collections.unmodifiableList(this.profiles);
    }

    public Set getReferencedServices() throws Exception {
        return this.referencedServices;
    }

    public Set getReferencedComponents() throws Exception {
        return this.referencedComponents;
    }

    public AbstractProfile addProfile(String name) throws Exception {
        name = name.trim();
        Profile newProfile = new Profile((AbstractProfiles)this, name);
        this.addProfile(newProfile);
        return newProfile;
    }

    public void addProfile(AbstractProfile newProfile) throws Exception {
        String name = newProfile.getName();
        Iterator iterator = this.profiles.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            if (!profile.getName().trim().equals(name)) continue;
            throw new Exception("The profile name " + name + " already exists!");
        }
        this.profiles.add(newProfile);
        newProfile.setParent(this);
        this.sortProfilesListByName();
        this.firePropertyChange("profilesCount", this.getProfilesCount() - 1, this.getProfilesCount());
    }

    public boolean removeProfile(String name) {
        int n = 0;
        while (n < this.profiles.size()) {
            Profile profile = (Profile)this.profiles.get(n);
            if (profile.getName().equals(name.trim())) {
                if (profile.getFileObject() != null && profile.getFileObject().exists()) {
                    this.removedProfileNames.add(profile.getName());
                }
                this.profiles.remove(n);
                profile.setParent(null);
                this.firePropertyChange("profilesCount", this.getProfilesCount() + 1, this.getProfilesCount());
                return true;
            }
            ++n;
        }
        return false;
    }

    public int getProfilesCount() {
        return this.profiles.size();
    }

    public void doSave() throws Exception {
        IDE ide = OpentoolsFactory.getIDEInstance();
        String[] profileNameTemplateSegments = new String[]{"private", "profiles", ""};
        Iterator removerator = this.removedProfileNames.iterator();
        while (removerator.hasNext()) {
            profileNameTemplateSegments[2] = removerator.next() + ".properties";
            try {
                ide.deleteFileFromProject(this.project, profileNameTemplateSegments);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.defaultProfile == null) {
            this.defaultProfile = (Profile)this.addProfile("default");
        }
        Iterator iterator = this.profiles.iterator();
        while (iterator.hasNext()) {
        }
        Iterator iterator2 = this.profiles.iterator();
        while (iterator2.hasNext()) {
        }
        this.updateClasspathIfServiceOrComponentReferencesChanged();
    }

    public AbstractProfile getProfileByName(String nameWithoutDotProperties) {
        if (nameWithoutDotProperties == null) {
            return null;
        }
        nameWithoutDotProperties = nameWithoutDotProperties.trim();
        Iterator iterator = this.profiles.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            if (!profile.getName().equals(nameWithoutDotProperties)) continue;
            return profile;
        }
        return null;
    }

    public boolean isSharingAccess() {
        return this.sharingAccess;
    }

    public void setSharingAccess(boolean sharingAccess) {
        this.sharingAccess = sharingAccess;
    }
}

