/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general;

import com.sap.portal.developmentTools.general.AbstractCustomProfileAttribute;
import com.sap.portal.developmentTools.general.AbstractProfile;
import com.sap.portal.developmentTools.general.AbstractProfiles;
import com.sap.portal.developmentTools.general.CustomProfileAttribute;
import com.sap.portal.developmentTools.general.ProfilesEP6;
import com.sapportals.portal.prt.deployment.descriptor.Descriptor;
import com.sapportals.portal.prt.deployment.descriptor.IComponent;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class ProfileEP6
extends AbstractProfile {
    private File profileFile;
    private String profileName;
    private Set customAttributes = new HashSet();
    private AbstractProfiles parent;
    private String resourceBundleName = "localization";
    private String personalizationClass = "";
    private String personalizationLink = "";
    private String authRequirement = "none";
    private String ePCF = "1";
    private String title = "";
    private String personalizationBehaviour = "inplace";
    private String componentType;
    private String classOrJspName;
    private boolean isolated = false;
    private Descriptor portalapp;
    private String componentName;

    private ProfileEP6() {
    }

    public ProfileEP6(ProfilesEP6 parent, IComponent component) throws Exception {
        String className;
        String componentType;
        String sharingRefProp;
        String servProp;
        this.parent = parent;
        this.componentName = this.profileName = component.getName();
        this.portalapp = new Descriptor(this.profileName);
        this.portalapp.load(this.profileFile);
        String sharingAccess = this.portalapp.getApplication().getComponent(this.componentName).getProfile().getPropertyValue("SharingAccess");
        if (sharingAccess != null && sharingAccess.equals("shared")) {
            parent.setSharingAccess(true);
        }
        if ((servProp = this.portalapp.getApplication().getComponent(this.componentName).getProfile().getPropertyValue("ServicesReference")) != null && !servProp.equals("")) {
            StringTokenizer st = new StringTokenizer(servProp, ",", false);
            Set serviceRefs = parent.getReferencedServices();
            while (st.hasMoreTokens()) {
                serviceRefs.add(st.nextToken().trim());
            }
        }
        if ((sharingRefProp = this.portalapp.getApplication().getComponent(this.componentName).getProfile().getPropertyValue("SharingReference")) != null && !sharingRefProp.equals("")) {
            StringTokenizer st = new StringTokenizer(sharingRefProp, ",", false);
            Set sharingRefs = parent.getReferencedComponents();
            while (st.hasMoreTokens()) {
                sharingRefs.add(st.nextToken().trim());
            }
        }
        if ((componentType = this.portalapp.getApplication().getComponent(this.componentName).getProfile().getPropertyValue("ComponentType")) != null) {
            componentType = componentType.trim();
        }
        if ((className = this.portalapp.getApplication().getComponent(this.componentName).getProfile().getPropertyValue("ClassName")) != null) {
            className = className.trim();
        }
        if (componentType == null || componentType.equals("")) {
            this.componentType = "IPortalComponent";
            this.classOrJspName = this.portalapp.getApplication().getComponent(this.componentName).getProfile().getPropertyValue("ClassName").trim();
        } else if (componentType.equals("jspnative")) {
            this.classOrJspName = this.portalapp.getApplication().getComponent(this.componentName).getProfile().getPropertyValue("JSP").trim();
            this.componentType = "native JSP";
        } else if (componentType.equals("servlet")) {
            this.classOrJspName = this.portalapp.getApplication().getComponent(this.componentName).getProfile().getPropertyValue("ClassName").trim();
            this.componentType = "Servlet";
        }
    }

    public static List getComponentTypePossibilities() {
        return AbstractProfile.componentTypePossibilities;
    }

    public void doSave() throws Exception {
        if (this.profileName.equals("default")) {
            Iterator iterator;
            if (this.parent.isSharingAccess()) {
                this.portalapp.getApplication().getConfiguration().setPropertyValue("SharingAccess", "shared");
            }
            if ((iterator = this.parent.getReferencedServices().iterator()).hasNext()) {
                StringBuffer serviceRefStrings = new StringBuffer();
                serviceRefStrings.append(iterator.next());
                while (iterator.hasNext()) {
                    serviceRefStrings.append(", ");
                    serviceRefStrings.append(iterator.next());
                }
                this.portalapp.getApplication().getConfiguration().setPropertyValue("ServicesReference", serviceRefStrings.toString());
            }
            if ((iterator = this.parent.getReferencedComponents().iterator()).hasNext()) {
                StringBuffer sharingRefStrings = new StringBuffer();
                sharingRefStrings.append(iterator.next());
                while (iterator.hasNext()) {
                    sharingRefStrings.append(", ");
                    sharingRefStrings.append(iterator.next());
                }
                this.portalapp.getApplication().getConfiguration().setPropertyValue("SharingReference", sharingRefStrings.toString());
            }
        }
        if (this.componentType == "IPortalComponent") {
            this.portalapp.getApplication().getComponent(this.profileName).getConfiguration().setPropertyValue("ClassName", this.classOrJspName);
        } else if (this.componentType == "Servlet") {
            this.portalapp.getApplication().getComponent(this.profileName).getConfiguration().setPropertyValue("ClassName", this.classOrJspName);
            this.portalapp.getApplication().getComponent(this.profileName).getConfiguration().setPropertyValue("ComponentType", "servlet");
        } else if (this.componentType == "native JSP") {
            this.portalapp.getApplication().getComponent(this.profileName).getConfiguration().setPropertyValue("JSP", this.classOrJspName);
            this.portalapp.getApplication().getComponent(this.profileName).getConfiguration().setPropertyValue("ComponentType", "jspnative");
        }
    }

    public String getName() {
        return this.profileName;
    }

    public void setName(String name) {
        this.profileName = name;
    }

    public void setClassName(String className) {
        this.classOrJspName = className;
    }

    public String getClassName() {
        return this.classOrJspName;
    }

    protected boolean isSharingAccessDeclared() {
        String sharingAccess = this.portalapp.getApplication().getComponent(this.componentName).getProfile().getPropertyValue("SharingAccess");
        return sharingAccess != null && sharingAccess.trim().equals("shared");
    }

    protected void setSharingAccessDeclared(boolean sharingAccessDeclared) {
        if (sharingAccessDeclared) {
            this.portalapp.getApplication().getComponent(this.componentName).getProfile().setPropertyValue("SharingAccess", "shared");
        }
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        if (!(componentType.equals("native JSP") || componentType.equals("IPortalComponent") || componentType.equals("Servlet"))) {
            return;
        }
        this.componentType = componentType;
    }

    public Set getCustomAttributes() {
        return this.customAttributes;
    }

    public boolean removeCustomAttribute(AbstractCustomProfileAttribute toRemove) {
        boolean hasChanged = this.customAttributes.remove(toRemove);
        if (hasChanged) {
            this.pcs.firePropertyChange("customAttributes", this.customAttributes.size() + 1, this.customAttributes.size());
        }
        return hasChanged;
    }

    public boolean addCustomAttribute(AbstractCustomProfileAttribute toAdd) {
        boolean hasChanged = this.customAttributes.add(toAdd);
        if (hasChanged) {
            this.pcs.firePropertyChange("customAttributes", this.customAttributes.size() - 1, this.customAttributes.size());
        }
        return hasChanged;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public void setTitle(String title) {
        if (title != null) {
            this.title = title;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getEPCF() {
        if (this.ePCF == "0") {
            return "no EPCF";
        }
        if (this.ePCF == "2") {
            return "JavaScript & Java Applet features";
        }
        return "JavaScript features only (default)";
    }

    public void setEPCF(String ePCF) {
        if (ePCF == null) {
            return;
        }
        if ((ePCF = ePCF.trim()).equals("no EPCF")) {
            this.ePCF = "0";
        }
        if (ePCF.equals("JavaScript features only (default)")) {
            this.ePCF = "1";
        }
        if (ePCF.equals("JavaScript & Java Applet features")) {
            this.ePCF = "2";
        }
    }

    public String getPersonalizationBehaviour() {
        return this.personalizationBehaviour;
    }

    public void setPersonalizationBehaviour(String personalizationBehaviour) {
        if (personalizationBehaviour == null) {
            return;
        }
        if ((personalizationBehaviour = personalizationBehaviour.trim()).equals("inplace")) {
            this.personalizationBehaviour = "inplace";
        }
        if (personalizationBehaviour.equals("maximize")) {
            this.personalizationBehaviour = "maximize";
        }
    }

    public String getPersonalizationLink() {
        return this.personalizationLink;
    }

    public void setPersonalizationLink(String personalizationLink) {
        if (personalizationLink != null && !personalizationLink.trim().equals("")) {
            this.personalizationLink = personalizationLink.trim();
        }
    }

    public String getPersonalizationClass() {
        return this.personalizationClass;
    }

    public void setPersonalizationClass(String personalizationClass) {
        if (personalizationClass != null && !personalizationClass.trim().equals("")) {
            this.personalizationClass = personalizationClass.trim();
        }
    }

    public String getAuthRequirement() {
        return this.authRequirement;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String resourceBundleName) {
        if (resourceBundleName != null && !resourceBundleName.trim().equals("")) {
            this.resourceBundleName = resourceBundleName.trim();
        }
    }

    public void setAuthRequirement(String authRequirement) {
        if (authRequirement != null) {
            authRequirement = authRequirement.trim();
            int i = 0;
            while (i < AbstractProfile.AUTH_REQUIREMENT_POSSIBILITES.length) {
                if (authRequirement.equals(AbstractProfile.AUTH_REQUIREMENT_POSSIBILITES[i])) {
                    this.authRequirement = AbstractProfile.AUTH_REQUIREMENT_POSSIBILITES[i];
                }
                ++i;
            }
        }
    }

    public void setParent(AbstractProfiles parent) {
        this.parent = parent;
    }

    public AbstractProfiles getParent() {
        return this.parent;
    }

    public AbstractProfile deepClone() {
        ProfileEP6 clone = new ProfileEP6();
        clone.parent = this.parent;
        clone.customAttributes = new HashSet();
        Iterator iterator = this.customAttributes.iterator();
        while (iterator.hasNext()) {
            CustomProfileAttribute attribute = (CustomProfileAttribute)iterator.next();
            CustomProfileAttribute clonedAtt = (CustomProfileAttribute)attribute.deepClone();
            clonedAtt.setProfile(clone);
            clone.customAttributes.add(clonedAtt);
        }
        clone.resourceBundleName = this.resourceBundleName;
        clone.personalizationClass = this.personalizationClass;
        clone.personalizationLink = this.personalizationLink;
        clone.authRequirement = this.authRequirement;
        clone.isolated = this.isolated;
        clone.ePCF = this.ePCF;
        clone.title = this.title;
        clone.personalizationBehaviour = this.personalizationBehaviour;
        clone.componentType = this.componentType;
        clone.classOrJspName = this.classOrJspName;
        clone.pcs = new PropertyChangeSupport(clone);
        return clone;
    }

    public AbstractCustomProfileAttribute createOrGetCustomAttribute(String name) {
        throw new NoSuchMethodError("Not yet implemented: createOrGetCustomAttribute in ProfileEP6");
    }

    static {
        AbstractProfile.componentTypePossibilities = new ArrayList();
        AbstractProfile.componentTypePossibilities.add("IPortalComponent");
        AbstractProfile.componentTypePossibilities.add("native JSP");
        AbstractProfile.componentTypePossibilities.add("Servlet");
        AbstractProfile.componentTypePossibilities = Collections.unmodifiableList(AbstractProfile.componentTypePossibilities);
    }
}

