/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general;

import com.sap.portal.developmentTools.general.AbstractCustomProfileAttribute;
import com.sap.portal.developmentTools.general.AbstractProfile;
import com.sap.portal.developmentTools.general.AbstractProfiles;
import com.sap.portal.developmentTools.general.CustomProfileAttribute;
import com.sap.portal.developmentTools.general.Profiles;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class Profile
extends AbstractProfile {
    private File profileFile;
    private Properties p;
    private String profileName;
    private Set customAttributes = new HashSet();
    private AbstractProfiles parent;
    private String resourceBundleName = "localization";
    private String personalizationClass = "";
    private String personalizationLink = "";
    private String authRequirement = "none";
    private String ePCF = "1";
    private String title = "";
    private String personalizationBehaviour = "inplace";
    private String componentType;
    private String classOrJspName;
    private boolean isolated = false;

    private Profile() {
    }

    public Profile(AbstractProfiles parent, String name) {
        this.parent = parent;
        this.profileName = name;
        this.componentType = "IPortalComponent";
        this.p = new Properties();
    }

    protected Profile(Profiles parent, File profileFile) throws Exception {
        String jsp;
        String className;
        String componentType;
        String sharingRefProp;
        String servProp;
        this.parent = parent;
        this.profileFile = profileFile;
        this.p = new Properties();
        this.p.load(new FileInputStream(profileFile));
        String fileName = profileFile.getName();
        this.profileName = fileName.substring(0, fileName.length() - 11);
        String sharingAccess = (String)((Hashtable)this.p).remove("SharingAccess");
        if (sharingAccess != null && sharingAccess.equals("shared")) {
            parent.setSharingAccess(true);
        }
        if ((servProp = (String)((Hashtable)this.p).remove("ServicesReference")) != null && !servProp.equals("")) {
            StringTokenizer st = new StringTokenizer(servProp, ",", false);
            Set serviceRefs = parent.getReferencedServices();
            while (st.hasMoreTokens()) {
                serviceRefs.add(st.nextToken().trim());
            }
        }
        if ((sharingRefProp = (String)((Hashtable)this.p).remove("SharingReference")) != null && !sharingRefProp.equals("")) {
            StringTokenizer st = new StringTokenizer(sharingRefProp, ",", false);
            Set sharingRefs = parent.getReferencedComponents();
            while (st.hasMoreTokens()) {
                sharingRefs.add(st.nextToken().trim());
            }
        }
        if ((componentType = (String)((Hashtable)this.p).remove("ComponentType")) != null && componentType.trim().equals("jsp")) {
            componentType = null;
        }
        if (componentType != null) {
            componentType = componentType.trim();
        }
        if ((className = (String)((Hashtable)this.p).remove("ClassName")) != null) {
            className = className.trim();
        }
        if ((jsp = (String)((Hashtable)this.p).remove("JSP")) != null) {
            jsp = jsp.trim();
        }
        if (componentType == null || componentType.trim().equals("")) {
            this.classOrJspName = className;
            this.componentType = "IPortalComponent";
        } else if (componentType.equals("jspnative")) {
            this.classOrJspName = jsp;
            this.componentType = "native JSP";
        } else if (componentType.equals("servlet")) {
            this.classOrJspName = className;
            this.componentType = "Servlet";
        }
        this.setResourceBundleName((String)((Hashtable)this.p).remove("ResourceBundleName"));
        this.setResourceBundleName((String)((Hashtable)this.p).remove("ResourceBundleName.value"));
        this.setPersonalizationClass((String)((Hashtable)this.p).remove("PersonalizationClass"));
        this.setPersonalizationClass((String)((Hashtable)this.p).remove("PersonalizationClass.value"));
        this.setPersonalizationLink((String)((Hashtable)this.p).remove("PersonalizationLink"));
        this.setPersonalizationLink((String)((Hashtable)this.p).remove("PersonalizationLink.value"));
        this.setAuthRequirement((String)((Hashtable)this.p).remove("AuthRequirement"));
        this.setAuthRequirement((String)((Hashtable)this.p).remove("AuthRequirement.value"));
        try {
            this.setEPCFAsInt(Integer.parseInt((String)((Hashtable)this.p).remove("EPCFLevel")));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        try {
            this.setEPCFAsInt(Integer.parseInt((String)((Hashtable)this.p).remove("EPCFLevel.value")));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.setTitle((String)((Hashtable)this.p).remove("Title"));
        this.setTitle((String)((Hashtable)this.p).remove("Title.value"));
        this.setPersonalizationBehaviour((String)((Hashtable)this.p).remove("PersonalizationBehaviour"));
        this.setPersonalizationBehaviour((String)((Hashtable)this.p).remove("PersonalizationBehaviour.value"));
        this.setIsolated((String)((Hashtable)this.p).remove("Isolated"));
        this.setIsolated((String)((Hashtable)this.p).remove("Isolated.value"));
        this.readAndRemoveCustomProfileAttributesFromProperties();
    }

    public AbstractProfiles getParent() {
        return this.parent;
    }

    public void setParent(AbstractProfiles parent) {
        this.parent = parent;
    }

    protected Properties getPropertiesObjectForSaving() throws Exception {
        if (this.profileName.equals("default")) {
            Iterator iterator;
            if (this.parent.isSharingAccess()) {
                this.p.setProperty("SharingAccess", "shared");
            }
            if ((iterator = this.parent.getReferencedServices().iterator()).hasNext()) {
                StringBuffer serviceRefStrings = new StringBuffer();
                serviceRefStrings.append(iterator.next());
                while (iterator.hasNext()) {
                    serviceRefStrings.append(", ");
                    serviceRefStrings.append(iterator.next());
                }
                this.p.setProperty("ServicesReference", serviceRefStrings.toString());
            }
            if ((iterator = this.parent.getReferencedComponents().iterator()).hasNext()) {
                StringBuffer sharingRefStrings = new StringBuffer();
                sharingRefStrings.append(iterator.next());
                while (iterator.hasNext()) {
                    sharingRefStrings.append(", ");
                    sharingRefStrings.append(iterator.next());
                }
                this.p.setProperty("SharingReference", sharingRefStrings.toString());
            }
        }
        if ("IPortalComponent".equals(this.componentType)) {
            this.p.setProperty("ClassName", this.getClassName());
        } else if ("Servlet".equals(this.componentType)) {
            this.p.setProperty("ClassName", this.getClassName());
            this.p.setProperty("ComponentType", "servlet");
        } else if ("native JSP".equals(this.componentType)) {
            this.p.setProperty("JSP", this.getClassName());
            this.p.setProperty("ComponentType", "jspnative");
        }
        if (this.personalizationLink != null && !this.personalizationLink.trim().equals("")) {
            this.p.setProperty("PersonalizationLink", this.personalizationLink);
        }
        if (this.personalizationClass != null && !this.personalizationClass.trim().equals("")) {
            this.p.setProperty("PersonalizationClass", this.personalizationClass);
        }
        if (this.authRequirement != "none") {
            this.p.setProperty("AuthRequirement", this.authRequirement);
        }
        if (this.resourceBundleName != null && !this.resourceBundleName.trim().equals("") && !this.resourceBundleName.trim().equals("localization")) {
            this.p.setProperty("ResourceBundleName", this.getResourceBundleName());
        }
        if (this.ePCF != "1") {
            this.p.setProperty("EPCFLevel", this.ePCF);
        }
        if (this.personalizationBehaviour != "inplace") {
            this.p.setProperty("PersonalizationBehaviour", this.personalizationBehaviour);
        }
        if (this.title != null && !this.title.trim().equals("")) {
            this.p.setProperty("Title.value", this.title);
        }
        if (this.isolated) {
            this.p.setProperty("Isolated.value", "true");
        }
        this.storeCustomProfileAttributesInProperties();
        return this.p;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String resourceBundleName) {
        if (resourceBundleName != null) {
            this.resourceBundleName = resourceBundleName.trim();
        }
    }

    public void setAuthRequirement(String authRequirement) {
        if (authRequirement != null) {
            authRequirement = authRequirement.trim();
            int i = 0;
            while (i < AbstractProfile.AUTH_REQUIREMENT_POSSIBILITES.length) {
                if (authRequirement.equals(AbstractProfile.AUTH_REQUIREMENT_POSSIBILITES[i])) {
                    this.authRequirement = AbstractProfile.AUTH_REQUIREMENT_POSSIBILITES[i];
                }
                ++i;
            }
        }
    }

    public String getAuthRequirement() {
        return this.authRequirement;
    }

    public String getPersonalizationLink() {
        return this.personalizationLink;
    }

    public void setPersonalizationLink(String personalizationLink) {
        if (personalizationLink != null) {
            this.personalizationLink = personalizationLink.trim();
        }
    }

    public String getPersonalizationClass() {
        return this.personalizationClass;
    }

    public void setPersonalizationClass(String personalizationClass) {
        if (personalizationClass != null) {
            this.personalizationClass = personalizationClass.trim();
        }
    }

    protected File getFileObject() {
        return this.profileFile;
    }

    public String getPersonalizationBehaviour() {
        return this.personalizationBehaviour;
    }

    public void setPersonalizationBehaviour(String personalizationBehaviour) {
        if (personalizationBehaviour == null) {
            return;
        }
        if ((personalizationBehaviour = personalizationBehaviour.trim()).equals("inplace")) {
            this.personalizationBehaviour = "inplace";
        }
        if (personalizationBehaviour.equals("maximize")) {
            this.personalizationBehaviour = "maximize";
        }
    }

    public String getEPCF() {
        if ("0".equals(this.ePCF)) {
            return "no EPCF";
        }
        if ("2".equals(this.ePCF)) {
            return "JavaScript & Java Applet features";
        }
        return "JavaScript features only (default)";
    }

    public void setEPCF(String ePCF) {
        if (ePCF == null) {
            return;
        }
        if ((ePCF = ePCF.trim()).equals("no EPCF")) {
            this.ePCF = "0";
        }
        if (ePCF.equals("JavaScript features only (default)")) {
            this.ePCF = "1";
        }
        if (ePCF.equals("JavaScript & Java Applet features")) {
            this.ePCF = "2";
        }
    }

    public void setEPCFAsInt(int ePCFLevel) {
        if (ePCFLevel > -1 && ePCFLevel < 3) {
            this.ePCF = String.valueOf(ePCFLevel);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title != null) {
            this.title = title;
        }
    }

    public String getName() {
        return this.profileName;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        name = AbstractProfile.removeNonProfileNameChars(name);
        if ((name = name.trim()).equals("")) {
            return;
        }
        this.profileName = name;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public void setClassName(String className) {
        this.classOrJspName = className;
    }

    public String getClassName() {
        if (this.classOrJspName == null) {
            return "";
        }
        return this.classOrJspName;
    }

    private void readAndRemoveCustomProfileAttributesFromProperties() {
        while (!((Hashtable)this.p).isEmpty()) {
            String personalizationAtt;
            String descriptionAtt;
            String plainDescriptionAtt;
            String inherAtt;
            String attributeName;
            Enumeration<?> en = this.p.propertyNames();
            String propNameNow = (String)en.nextElement();
            CustomProfileAttribute newCpa = new CustomProfileAttribute(this);
            int indexOfDot = propNameNow.lastIndexOf(46);
            if (indexOfDot > -1) {
                attributeName = propNameNow.substring(0, indexOfDot);
                String simpleValueDefinition = (String)((Hashtable)this.p).remove(attributeName);
                if (simpleValueDefinition != null && !simpleValueDefinition.trim().equals("")) {
                    newCpa.setValue(simpleValueDefinition);
                }
                newCpa.setName(attributeName);
            } else {
                attributeName = propNameNow.trim();
                newCpa.setName(attributeName);
                newCpa.setValue((String)((Hashtable)this.p).remove(propNameNow));
            }
            String valueAtt = (String)((Hashtable)this.p).remove(attributeName + ".value");
            if (valueAtt != null && !valueAtt.trim().equals("")) {
                newCpa.setValue(valueAtt);
            }
            if ((inherAtt = (String)((Hashtable)this.p).remove(attributeName + ".inheritance")) != null && !inherAtt.trim().equals("")) {
                newCpa.setInheritance(inherAtt);
            }
            if ((plainDescriptionAtt = (String)((Hashtable)this.p).remove(attributeName + ".plainDescription")) != null && !plainDescriptionAtt.trim().equals("")) {
                newCpa.setPlainDescription(plainDescriptionAtt);
            }
            if ((descriptionAtt = (String)((Hashtable)this.p).remove(attributeName + ".description")) != null && !descriptionAtt.trim().equals("")) {
                newCpa.setDescription(descriptionAtt);
            }
            if ((personalizationAtt = (String)((Hashtable)this.p).remove(attributeName + ".personalization")) != null && !personalizationAtt.trim().equals("")) {
                newCpa.setPersonalization(personalizationAtt);
            }
            en = this.p.propertyNames();
            Properties customCustomProperties = null;
            String attNameWithADot = attributeName + ".";
            while (en.hasMoreElements()) {
                String now = (String)en.nextElement();
                if (!now.startsWith(attNameWithADot)) continue;
                if (customCustomProperties == null) {
                    customCustomProperties = new Properties();
                }
                ((Hashtable)customCustomProperties).put(now, ((Hashtable)this.p).remove(now));
            }
            newCpa.setCustomCustomAttributes(customCustomProperties);
            this.customAttributes.add(newCpa);
        }
    }

    private void storeCustomProfileAttributesInProperties() {
        Iterator iterator = this.customAttributes.iterator();
        while (iterator.hasNext()) {
            CustomProfileAttribute attribute = (CustomProfileAttribute)iterator.next();
            String attributeName = attribute.getName();
            ((Hashtable)this.p).put(attributeName + ".value", attribute.getValue());
            if (!attribute.getInheritance().equals("non-final")) {
                ((Hashtable)this.p).put(attributeName + ".inheritance", attribute.getInheritance());
            }
            if (!attribute.getPersonalization().equals("none")) {
                ((Hashtable)this.p).put(attributeName + ".personalization", attribute.getPersonalization());
            }
            if (attribute.getDescription() != null && !attribute.getDescription().trim().equals("")) {
                ((Hashtable)this.p).put(attributeName + ".description", attribute.getDescription());
            }
            if (attribute.getPlainDescription() != null && !attribute.getPlainDescription().trim().equals("")) {
                ((Hashtable)this.p).put(attributeName + ".plainDescription", attribute.getPlainDescription());
            }
            if (attribute.getCustomCustomAttributes() == null) continue;
            ((Hashtable)this.p).putAll(attribute.getCustomCustomAttributes());
        }
    }

    protected boolean isSharingAccessDeclared() {
        String sharingAccess = this.p.getProperty("SharingAccess");
        return sharingAccess != null && sharingAccess.trim().equals("shared");
    }

    protected void setSharingAccessDeclared(boolean sharingAccessDeclared) {
        if (sharingAccessDeclared) {
            this.p.setProperty("SharingAccess", "shared");
        } else {
            ((Hashtable)this.p).remove("SharingAccess");
        }
    }

    public String getComponentType() {
        if (this.componentType == null) {
            return "";
        }
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        if (!(componentType.equals("native JSP") || componentType.equals("IPortalComponent") || componentType.equals("Servlet"))) {
            return;
        }
        this.componentType = componentType;
    }

    public Set getCustomAttributes() {
        return this.customAttributes;
    }

    public boolean addCustomAttribute(AbstractCustomProfileAttribute toAdd) {
        boolean hasChanged = this.customAttributes.add(toAdd);
        if (hasChanged) {
            this.pcs.firePropertyChange("customAttributes", this.customAttributes.size() - 1, this.customAttributes.size());
        }
        return hasChanged;
    }

    public AbstractCustomProfileAttribute createOrGetCustomAttribute(String name) {
        AbstractCustomProfileAttribute retVal = null;
        Iterator iterator = this.customAttributes.iterator();
        while (iterator.hasNext()) {
            AbstractCustomProfileAttribute abstractCustomProfileAttribute = (AbstractCustomProfileAttribute)iterator.next();
            if (!abstractCustomProfileAttribute.getName().equals(name)) continue;
            retVal = abstractCustomProfileAttribute;
            break;
        }
        if (retVal == null) {
            retVal = new CustomProfileAttribute(name, this);
            this.customAttributes.add(retVal);
        }
        return retVal;
    }

    public boolean removeCustomAttribute(AbstractCustomProfileAttribute toRemove) {
        boolean hasChanged = this.customAttributes.remove(toRemove);
        if (hasChanged) {
            this.pcs.firePropertyChange("customAttributes", this.customAttributes.size() + 1, this.customAttributes.size());
        }
        return hasChanged;
    }

    public AbstractProfile deepClone() {
        Profile clone = new Profile();
        clone.p = (Properties)((Hashtable)this.p).clone();
        clone.parent = this.parent;
        clone.customAttributes = new HashSet();
        Iterator iterator = this.customAttributes.iterator();
        while (iterator.hasNext()) {
            CustomProfileAttribute attribute = (CustomProfileAttribute)iterator.next();
            CustomProfileAttribute clonedAtt = (CustomProfileAttribute)attribute.deepClone();
            clonedAtt.setProfile(clone);
            clone.customAttributes.add(clonedAtt);
        }
        clone.resourceBundleName = this.resourceBundleName;
        clone.personalizationClass = this.personalizationClass;
        clone.personalizationLink = this.personalizationLink;
        clone.authRequirement = this.authRequirement;
        clone.isolated = this.isolated;
        clone.ePCF = this.ePCF;
        clone.title = this.title;
        clone.personalizationBehaviour = this.personalizationBehaviour;
        clone.componentType = this.componentType;
        clone.classOrJspName = this.classOrJspName;
        clone.pcs = new PropertyChangeSupport(clone);
        return clone;
    }

    static {
        AbstractProfile.componentTypePossibilities = new ArrayList();
        AbstractProfile.componentTypePossibilities.add("IPortalComponent");
        AbstractProfile.componentTypePossibilities.add("native JSP");
        AbstractProfile.componentTypePossibilities.add("Servlet");
        AbstractProfile.componentTypePossibilities = Collections.unmodifiableList(AbstractProfile.componentTypePossibilities);
    }
}

