/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ePSpecific;

import com.sap.portal.developmentTools.general.AbstractProfiles;
import com.sap.portal.developmentTools.general.Profiles;
import com.sap.portal.developmentTools.general.api.EP;
import com.sap.portal.developmentTools.general.api.FileNotExistException;
import com.sap.portal.developmentTools.general.api.IDE;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.api.StringBasedFileFilter;
import com.sap.portal.developmentTools.general.settings.PDKInstallation;
import com.sap.portal.util.Stream;
import com.sap.portal.util.Strings;
import com.sap.portal.util.Templating;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class EP5
implements EP {
    public static final String IPORTAL_COMPONENT_FQ_NAME = "com.sapportals.portal.prt.component.IPortalComponent";
    public static final String SERVLET_INTERFACE_FQ_NAME = "javax.servlet.Servlet";
    public static final FileFilter mm_acceptDirAndDotJavasFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.getAbsolutePath().endsWith(".java") || pathname.isDirectory();
        }
    };
    private static final StringBasedFileFilter mm_reject_privateClassesSrcSrclib = new StringBasedFileFilter(){

        public boolean accept(String[] segments, boolean isDir) throws IOException {
            if (segments.length == 2 && isDir && segments[0].equals("private")) {
                return !segments[1].equals("srclib") && !segments[1].equals("classes") && !segments[1].equals("src");
            }
            return false;
        }
    };
    private static final StringBasedFileFilter mm_recurseToPrivateFilter = new StringBasedFileFilter(){

        public boolean accept(String[] segments, boolean isDir) throws IOException {
            return segments.length == 1 && segments[0].equals("private");
        }
    };
    private static final StringBasedFileFilter mm_rejectSrcSrclibCoreSrclibApiClases = new StringBasedFileFilter(){

        public boolean accept(String[] segments, boolean isDir) throws IOException {
            if (segments.length == 2 && isDir && segments[0].equals("private")) {
                String subFolderName = segments[1];
                return !subFolderName.equals("srclibCore") && !segments[1].equals("srclibApi") && !segments[1].equals("classes") && !segments[1].equals("src");
            }
            return false;
        }
    };
    protected static final StringBasedFileFilter mm_rejectDotJavasAcceptDirs = new StringBasedFileFilter(){

        public boolean accept(String[] segments, boolean isDir) throws IOException {
            if (isDir) {
                return true;
            }
            if (segments.length > 0) {
                return !segments[segments.length - 1].endsWith(".java");
            }
            return true;
        }
    };
    public static final String[] PRIVATE_RESOURCE_PATH = new String[]{"private"};
    public static final String[] PUBLIC_RESOURCE_PATH = new String[]{"public"};
    public static final String[] POSSIBLE_JSP_SCOPES = new String[]{"application", "session", "request", "page"};
    List mm_portalComponentPossibilites;
    List mm_jspPossibilites;
    List mm_servletPossibilites;
    static /* synthetic */ Class class$com$sap$portal$developmentTools$general$iDE$AbstractIDE;

    public void createNewIViewClassInCurrentProject(String fqClassName, int aPIOrNot) throws Exception {
    }

    public File createIViewProjectFileAndFolderStructure(String projectRootRootFolder, String projectName) throws IOException, Exception {
        File projectFolder = new File(projectRootRootFolder, projectName);
        File publicFolder = new File(projectFolder, "public");
        File privateFolder = new File(projectFolder, "private");
        File pubImagesFolder = new File(publicFolder, "images");
        File pubScriptsFolder = new File(publicFolder, "scripts");
        File pubCssFolder = new File(publicFolder, "css");
        File priLibFolder = new File(privateFolder, "lib");
        File priLoggerFolder = new File(privateFolder, "logger");
        File priProfilesFolder = new File(privateFolder, "profiles");
        File priPageletFolder = new File(privateFolder, "pagelet");
        File priSrcFolder = new File(privateFolder, "src");
        File pridef = new File(priProfilesFolder, "default.properties");
        projectFolder.mkdirs();
        publicFolder.mkdir();
        privateFolder.mkdir();
        pubImagesFolder.mkdir();
        pubScriptsFolder.mkdir();
        pubCssFolder.mkdir();
        priLoggerFolder.mkdir();
        priLibFolder.mkdir();
        priProfilesFolder.mkdir();
        priPageletFolder.mkdir();
        priSrcFolder.mkdir();
        if (!pridef.exists()) {
            pridef.createNewFile();
        }
        return projectFolder;
    }

    public File createServiceProjectFileStructure(String projectRootRootFolder, String projectName) throws IOException {
        File projectFolder = new File(projectRootRootFolder, projectName);
        File publicFolder = new File(projectFolder, "public");
        File privateFolder = new File(projectFolder, "private");
        File libFolder = new File(projectFolder, "lib");
        File configFolder = new File(projectFolder, "config");
        File pubImagesFolder = new File(publicFolder, "images");
        File pubScriptsFolder = new File(publicFolder, "scripts");
        File pubCssFolder = new File(publicFolder, "css");
        File pubHelpFolder = new File(publicFolder, "help");
        File priPageletFolder = new File(privateFolder, "pagelet");
        File priJspFolder = new File(privateFolder, "jsp");
        File priTaglibFolder = new File(privateFolder, "taglib");
        File libPrivateFolder = new File(libFolder, "private");
        File serviceXMLFile = new File(configFolder, "service.xml");
        projectFolder.mkdirs();
        publicFolder.mkdir();
        privateFolder.mkdir();
        libFolder.mkdir();
        configFolder.mkdir();
        pubImagesFolder.mkdir();
        pubScriptsFolder.mkdir();
        pubCssFolder.mkdir();
        pubHelpFolder.mkdir();
        priPageletFolder.mkdir();
        priJspFolder.mkdir();
        priTaglibFolder.mkdir();
        libPrivateFolder.mkdir();
        if (!serviceXMLFile.exists()) {
            serviceXMLFile.createNewFile();
        }
        return projectFolder;
    }

    public List getServletPossibilites(Object project) {
        this.reInitServletPossibilities(project);
        return this.mm_servletPossibilites;
    }

    public List getJspPossibilites(Object project) {
        this.reInitJSPPossibilities(project);
        return this.mm_jspPossibilites;
    }

    public List getPortalComponentPossibilites(Object project) {
        this.reInitPortalComponentPossibilities(project);
        return this.mm_portalComponentPossibilites;
    }

    public void resetPortalComponentPossibilities() {
        this.mm_portalComponentPossibilites = null;
    }

    public void resetCaches() {
        this.resetJSPPossibilities();
        this.resetPortalComponentPossibilities();
        this.resetServletPossibilites();
    }

    private void reInitPortalComponentPossibilities(Object project) {
        this.mm_portalComponentPossibilites = OpentoolsFactory.getIDEInstance().getAllNonAbstractClassesDerivedFromInCurrentProject(project, IPORTAL_COMPONENT_FQ_NAME);
    }

    public void resetServletPossibilites() {
        this.mm_servletPossibilites = null;
    }

    private void reInitServletPossibilities(Object project) {
        this.mm_servletPossibilites = OpentoolsFactory.getIDEInstance().getAllNonAbstractClassesDerivedFromInCurrentProject(project, SERVLET_INTERFACE_FQ_NAME);
    }

    public void resetJSPPossibilities() {
        this.mm_jspPossibilites = null;
    }

    private void reInitJSPPossibilities(Object project) {
        StringBasedFileFilter recursionFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                if (segments.length == 0) {
                    return true;
                }
                return isDir && segments[0].equals("private");
            }
        };
        StringBasedFileFilter acceptFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                boolean retVal = !isDir && segments.length > 1 && segments[0].equals("private") && segments[segments.length - 1].substring(segments[segments.length - 1].length() - 4).equalsIgnoreCase(".jsp");
                return retVal;
            }
        };
        try {
            this.mm_jspPossibilites = OpentoolsFactory.getIDEInstance().getAllFilesInProject(project, acceptFilter, recursionFilter);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public Set getResourceBundleNames(Object project) {
        HashSet<String> retVal = new HashSet<String>();
        StringBasedFileFilter recursionFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                if (segments[0].equals("private")) {
                    if (segments.length > 1) {
                        return segments[1].equals("classes");
                    }
                    return true;
                }
                return false;
            }
        };
        StringBasedFileFilter acceptFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                return segments.length > 2 && segments[0].equals("private") && segments[1].equals("classes") && segments[segments.length - 1].endsWith(".properties");
            }
        };
        try {
            List possibleResourceFiles = OpentoolsFactory.getIDEInstance().getAllFilesInProject(project, acceptFilter, recursionFilter);
            Iterator iterator = possibleResourceFiles.iterator();
            while (iterator.hasNext()) {
                String[] segments = (String[])iterator.next();
                StringBuffer sb = new StringBuffer();
                String shortFileName = segments[segments.length - 1];
                int indexOfUnderscore = shortFileName.indexOf("_");
                if (indexOfUnderscore > -1) {
                    segments[segments.length - 1] = shortFileName.substring(0, indexOfUnderscore);
                }
                sb.append(segments[2]);
                int i = 3;
                while (i < segments.length) {
                    sb.append("/");
                    sb.append(segments[i]);
                    ++i;
                }
                retVal.add(sb.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public void doCoreClassPathSettings(Object project) throws Exception {
        ArrayList<File> coreClassPath = new ArrayList<File>();
        PDKInstallation pdkinst = PDKInstallation.getInstance();
        StringBasedFileFilter recFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                if (segments[0].equals("private")) {
                    if (segments.length == 1) {
                        return true;
                    }
                    if (segments.length > 3) {
                        return false;
                    }
                    return segments[1].equals("lib");
                }
                return false;
            }
        };
        StringBasedFileFilter acceptFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                if (segments.length != 3) {
                    return false;
                }
                return !segments[0].equals("private") && segments[1].equals("lib") && segments[2].endsWith(".jar");
            }
        };
        List libJarFiles = OpentoolsFactory.getIDEInstance().getAllFilesInProject(project, acceptFilter, recFilter);
        Iterator it = libJarFiles.iterator();
        while (it.hasNext()) {
            String[] segments = (String[])it.next();
            coreClassPath.add(OpentoolsFactory.getIDEInstance().getFileObjectFor(project, segments));
        }
        OpentoolsFactory.getIDEInstance().adjustProjectClassPathTo(project, coreClassPath, "core");
    }

    public AbstractProfiles getCurrentProfiles(Object project) throws Exception {
        IDE ide = OpentoolsFactory.getIDEInstance();
        StringBasedFileFilter recFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                if (segments[0].equals("private")) {
                    if (segments.length == 1) {
                        return true;
                    }
                    if (segments[1].equals("profiles")) {
                        return segments.length == 2;
                    }
                    return false;
                }
                return false;
            }
        };
        StringBasedFileFilter acceptFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                if (segments.length != 3) {
                    return false;
                }
                return segments[0].equals("private") && segments[1].equals("profiles") && segments[2].endsWith(".properties");
            }
        };
        List allProfileFileNameSegments = ide.getAllFilesInProject(project, acceptFilter, recFilter);
        File[] profileFilesAr = new File[allProfileFileNameSegments.size()];
        int i = 0;
        while (i < allProfileFileNameSegments.size()) {
            profileFilesAr[i] = ide.getFileObjectFor(project, (String[])allProfileFileNameSegments.get(i));
            ++i;
        }
        return new Profiles(project, profileFilesAr);
    }

    public boolean isComponentProject(Object project) {
        try {
            return this.isPossibleComponentRootFolder(new File(OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project)));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isPossibleComponentRootFolder(File folder) {
        return new File(folder, "private/profiles/default.properties").exists();
    }

    public boolean isServiceProject(Object project) {
        try {
            return OpentoolsFactory.getIDEInstance().getFileObjectFor(project, new String[]{"config", "service.xml"}).exists();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public File createNewIViewClassInProject(Object project, String fqClassName) throws Exception {
        if (fqClassName == null || fqClassName.trim().equals("")) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(fqClassName, ".", false);
        ArrayList<String> pathParts = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            pathParts.add(st.nextToken());
        }
        String packageName = "";
        String className = (String)pathParts.get(pathParts.size() - 1);
        int i = 0;
        while (i < pathParts.size() - 1) {
            String pathPart = (String)pathParts.get(i);
            packageName = i > 0 ? packageName + "." + pathPart : pathPart;
            ++i;
        }
        File sourceFile = OpentoolsFactory.getIDEInstance().createJavaSourceFileInCurrentProject(project, fqClassName, 0);
        FileWriter fos = new FileWriter(sourceFile);
        HashMap<String, String> varNamesToValues = new HashMap<String, String>();
        String packdeclaration = "";
        if (packageName != null && !packageName.equals("")) {
            packdeclaration = "\npackage " + packageName + ";\n\n";
        }
        varNamesToValues.put("package-declaration", packdeclaration);
        varNamesToValues.put("class-name", className);
        Templating.writeTemplateToWriter(varNamesToValues, (class$com$sap$portal$developmentTools$general$iDE$AbstractIDE == null ? (class$com$sap$portal$developmentTools$general$iDE$AbstractIDE = EP5.class$("com.sap.portal.developmentTools.general.iDE.AbstractIDE")) : class$com$sap$portal$developmentTools$general$iDE$AbstractIDE).getResourceAsStream("iViewClassTemplate.xml"), fos);
        fos.close();
        return sourceFile;
    }

    public void createServiceClassInCurrentProject(String packageS, String className, int aPIOrNot, boolean isDefaultClass) throws Exception {
        if (packageS != null && !packageS.trim().equals("")) {
            packageS = packageS.trim();
            while (packageS.endsWith(".")) {
                packageS = packageS.substring(0, packageS.length() - 1);
            }
            while (packageS.startsWith(".")) {
                packageS = packageS.substring(1, packageS.length());
            }
        }
        String fullyQualifiedClassName = packageS + "." + className.trim();
        if (isDefaultClass) {
            String serviceXMLFileContent = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n\n<services\n    name=\"" + OpentoolsFactory.getIDEInstance().getCurrentProjectName() + "\"\n    className=\"" + fullyQualifiedClassName + "\"" + "\n    startup = \"false\"\n    releasable = \"true\">\n</services>";
            File servicexmlFile = OpentoolsFactory.getIDEInstance().createFileInProject(null, new String[]{"config", "service.xml"}, true);
            FileWriter writer = new FileWriter(servicexmlFile);
            writer.write(serviceXMLFileContent);
            writer.close();
        }
        String packageDeclaration = "";
        if (packageS != null && !packageS.trim().equals("")) {
            packageDeclaration = "package " + packageS + ";\n";
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("package-declaration", packageDeclaration);
        values.put("class-name", className);
        InputStream template = null;
        template = aPIOrNot == 0 ? this.getClass().getResourceAsStream("ApiServiceTemplate.xml") : this.getClass().getResourceAsStream("CoreServiceTemplate.xml");
        File javaSourceFile = OpentoolsFactory.getIDEInstance().createJavaSourceFileInCurrentProject(null, fullyQualifiedClassName, aPIOrNot);
        FileWriter sourceWrite = new FileWriter(javaSourceFile);
        Templating.writeTemplateToWriter(values, template, sourceWrite);
        sourceWrite.close();
    }

    public void createServiceClassInCurrentProject(Object project, String packageS, String className, String serviceName, int aPIOrNot, boolean isDefaultClass) throws Exception {
        this.createServiceClassInCurrentProject(packageS, className, aPIOrNot, isDefaultClass);
    }

    public void createServiceClassInCurrentProject(Object project, String packageS, String className, int aPIOrNot) throws Exception {
        if (packageS != null && !packageS.trim().equals("")) {
            packageS = packageS.trim();
            while (packageS.endsWith(".")) {
                packageS = packageS.substring(0, packageS.length() - 1);
            }
            while (packageS.startsWith(".")) {
                packageS = packageS.substring(1, packageS.length());
            }
        }
        String fullyQualifiedClassName = packageS + "." + className.trim();
        String packageDeclaration = "";
        if (packageS != null && !packageS.trim().equals("")) {
            packageDeclaration = "package " + packageS + ";\n";
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("package-declaration", packageDeclaration);
        values.put("class-name", className);
        InputStream template = null;
        template = aPIOrNot == 0 ? this.getClass().getResourceAsStream("ApiServiceTemplate.xml") : this.getClass().getResourceAsStream("CoreServiceTemplate.xml");
        File javaSourceFile = OpentoolsFactory.getIDEInstance().createJavaSourceFileInCurrentProject(project, fullyQualifiedClassName, aPIOrNot);
        FileWriter sourceWrite = new FileWriter(javaSourceFile);
        Templating.writeTemplateToWriter(values, template, sourceWrite);
        sourceWrite.close();
    }

    public Object createNewIViewProjectFromPar(String projectRootFolderName, String projectName, File parFile) throws Exception {
        Object project = this.createNewIViewProject(projectRootFolderName, projectName, false);
        IDE ide = OpentoolsFactory.getIDEInstance();
        this.unpackParArchive(project, parFile);
        ide.updateProjectFromFilesSystem(project, new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                return segments.length != 3 || !segments[0].equals("private") || !segments[1].equals("lib") || !segments[2].endsWith(".jar");
            }
        });
        this.doCoreClassPathSettings(project);
        return project;
    }

    public void createNewIViewProjectFromPar(Object project, File parFile) throws Exception {
        IDE ide = OpentoolsFactory.getIDEInstance();
        this.unpackParArchive(project, parFile);
        ide.updateProjectFromFilesSystem(project, new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                return segments.length != 3 || !segments[0].equals("private") || !segments[1].equals("lib") || !segments[2].endsWith(".jar");
            }
        });
        this.doCoreClassPathSettings(project);
    }

    public Object createNewIViewProject(String projectRootRootFolder, String projectName, boolean fromPar) throws Exception {
        File projectFolder = new File(projectRootRootFolder, projectName);
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        Object project = ideInstance.prepareNewProject(projectFolder, new String[]{"private", "src"}, new String[]{"private", "classes"});
        this.createIViewProjectFileAndFolderStructure(projectRootRootFolder, projectName);
        ideInstance.updateProjectFromFilesSystem(project, StringBasedFileFilter.ACCEPT_EVERYTHING_FILE_FILTER);
        this.doCoreClassPathSettings(project);
        return project;
    }

    public Object createNewServiceProject(String projectRootPath, String projectName) throws Exception {
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        File projectFolder = this.createServiceProjectFileStructure(projectRootPath, projectName);
        Object project = ideInstance.prepareNewProject(projectFolder, new String[]{"private", "src", "api"}, new String[]{"private", "classes", "api"});
        ideInstance.addSrcPathInProject(project, new String[]{"private", "src", "core"});
        ideInstance.addOutPathInProject(project, new String[]{"private", "classes", "core"});
        ideInstance.updateProjectFromFilesSystem(project, StringBasedFileFilter.ACCEPT_EVERYTHING_FILE_FILTER);
        File serviceXML = ideInstance.createFileInProject(project, new String[]{"config", "service.xml"}, true);
        if (!serviceXML.exists()) {
            serviceXML.createNewFile();
        }
        BufferedWriter fos = new BufferedWriter(new FileWriter(serviceXML));
        fos.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n\n<services\n    name=\"" + projectName + "\"\n    className=\"\"\n    startup = \"false\"\n    releasable = \"true\">\n</services>");
        ((Writer)fos).close();
        this.doCoreClassPathSettings(project);
        return project;
    }

    public File createNewServiceProjectFromZar(String projectRootPath, String projectName, File zarFile) throws Exception {
        Object project = this.createNewServiceProject(projectRootPath, projectName);
        File projectFolder = new File(OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project));
        this.unpackZarArchive(project, zarFile);
        OpentoolsFactory.getIDEInstance().updateProjectFromFilesSystem(project, StringBasedFileFilter.ACCEPT_EVERYTHING_FILE_FILTER);
        return projectFolder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addEntriesToZipFile(File zipFile, HashMap entries) throws IOException {
        FileOutputStream zipFileFos;
        block7: {
            zipFile.getParentFile().mkdirs();
            if (!zipFile.exists()) {
                zipFile.createNewFile();
            }
            zipFileFos = null;
            ZipOutputStream zos = null;
            try {
                zipFileFos = new FileOutputStream(zipFile);
                zos = new ZipOutputStream(zipFileFos);
                this.addEntriesToZipOutputStream(zos, entries);
                Object var7_5 = null;
                if (zos == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (zos != null) {
                    zos.close();
                }
                if (zipFileFos == null) throw throwable;
                zipFileFos.close();
                throw throwable;
            }
            zos.close();
        }
        if (zipFileFos == null) return;
        zipFileFos.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addEntriesToZipOutputStream(ZipOutputStream zos, HashMap entries) throws IOException {
        Set entryNames = entries.keySet();
        InputStream stream = null;
        Iterator iterator = entryNames.iterator();
        while (true) {
            block13: {
                Object var10_10;
                if (!iterator.hasNext()) {
                    return;
                }
                try {
                    String entryName = (String)iterator.next();
                    ZipEntry zipEntry = new ZipEntry(entryName);
                    zos.putNextEntry(zipEntry);
                    Object entry = entries.get(entryName);
                    if (entry instanceof File) {
                        stream = new FileInputStream((File)entry);
                    } else if (entry instanceof InputStream) {
                        stream = (InputStream)entry;
                    } else if (entry instanceof String) {
                        stream = new FileInputStream((String)entry);
                    }
                    if (stream != null) {
                        Stream.copyStream(stream, zos);
                    }
                    var10_10 = null;
                    if (stream == null) break block13;
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    if (stream != null) {
                        stream.close();
                    }
                    zos.closeEntry();
                    throw throwable;
                }
                stream.close();
            }
            zos.closeEntry();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addDirectoryToZipFileRecursively(String zipEntryNamePrefix, File directory, ZipOutputStream zipFile, FileFilter filter) throws IOException {
        zipEntryNamePrefix = zipEntryNamePrefix == null || zipEntryNamePrefix.trim().equals("") ? "" : zipEntryNamePrefix + "/";
        File[] files = directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return !pathname.getAbsolutePath().endsWith(".dependency") || pathname.isDirectory();
            }
        });
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String name = zipEntryNamePrefix + file.getName();
            if (file.isDirectory()) {
                this.addDirectoryToZipFileRecursively(name, file, zipFile, filter);
            } else {
                block12: {
                    Object var13_12;
                    InputStream stream = null;
                    try {
                        try {
                            if (filter.accept(file)) {
                                ZipEntry newEntry = new ZipEntry(name);
                                newEntry.setSize(file.length());
                                zipFile.putNextEntry(newEntry);
                                stream = new FileInputStream(file);
                                Stream.copyStream(stream, zipFile);
                            }
                        }
                        catch (FileNotFoundException e) {
                            throw e;
                        }
                        catch (IOException e) {
                            throw e;
                        }
                        var13_12 = null;
                        if (stream == null) break block12;
                    }
                    catch (Throwable throwable) {
                        var13_12 = null;
                        if (stream != null) {
                            stream.close();
                        }
                        zipFile.closeEntry();
                        throw throwable;
                    }
                    stream.close();
                }
                zipFile.closeEntry();
            }
            ++i;
        }
        return;
    }

    public void unpackParArchive(Object project, File zipFile) throws Exception {
        IDE ide = OpentoolsFactory.getIDEInstance();
        String targetProjectFolderString = ide.getCurrentProjectFolder(project);
        File srcPath = ide.getSrcPath(project, 0);
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            String entryName;
            ZipEntry entry = en.nextElement();
            if (entry.isDirectory() || (entryName = entry.getName()).equalsIgnoreCase("META-INF/Manifest.mf")) continue;
            if (Strings.startsWithIgnoreCase(entryName, "public/")) {
                Stream.writeStreamToFile(targetProjectFolderString + "/" + entryName, zip.getInputStream(entry));
                continue;
            }
            if (Strings.startsWithIgnoreCase(entryName, "private/srclib/") && Strings.countCharOccurence(entryName, '/') == 2 && entryName.endsWith(".src.jar")) {
                this.extractZipEntryThatIsAZip(zip, entry, srcPath);
                continue;
            }
            if (Strings.startsWithIgnoreCase(entryName, "private/")) {
                Stream.writeStreamToFile(targetProjectFolderString + "/" + entryName, zip.getInputStream(entry));
                continue;
            }
            if (this.isAPrivateResource(entryName)) {
                Stream.writeStreamToFile(targetProjectFolderString + "/private/" + entryName, zip.getInputStream(entry));
                continue;
            }
            Stream.writeStreamToFile(targetProjectFolderString + "/public/" + entryName, zip.getInputStream(entry));
        }
        zip.close();
    }

    private void extractZipEntryThatIsAZip(ZipFile zip, ZipEntry entry, File targetFolder) throws IOException {
        File tmpZipFile = File.createTempFile("TEMPFILE", "SUFFIX");
        Stream.copyAndCloseStream(zip.getInputStream(entry), new FileOutputStream(tmpZipFile));
        this.unpackZipArchive(targetFolder, tmpZipFile);
        tmpZipFile.delete();
    }

    public void unpackZipArchive(File targetFolder, File zFile) throws IOException {
        ZipFile zipFile = new ZipFile(zFile);
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            if (entry.isDirectory()) continue;
            String entryName = entry.getName();
            String fileName = this.isAPrivateResource(entryName) ? "private/" + entryName : entryName;
            fileName = fileName.replace('/', File.separatorChar);
            File f = new File(targetFolder, fileName);
            try {
                f.getParentFile().mkdirs();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!f.exists()) {
                f.createNewFile();
            }
            Stream.copyStream(zipFile.getInputStream(entry), new FileOutputStream(f));
        }
        zipFile.close();
    }

    protected boolean isAPrivateResource(String name) {
        return Strings.startsWithIgnoreCase(name, "xml/") || Strings.startsWithIgnoreCase(name, "xsl/") || Strings.startsWithIgnoreCase(name, "properties/") || Strings.startsWithIgnoreCase(name, "profiles/") || Strings.startsWithIgnoreCase(name, "lib/") || Strings.startsWithIgnoreCase(name, "srclib/") || Strings.startsWithIgnoreCase(name, "classes/") || Strings.startsWithIgnoreCase(name, "taglib") || Strings.startsWithIgnoreCase(name, "config/") || Strings.startsWithIgnoreCase(name, "meta-inf/") || Strings.startsWithIgnoreCase(name, "pagelet/") || Strings.startsWithIgnoreCase(name, "jsp/");
    }

    public boolean uploadParFile(File parFile) throws Exception {
        PDKInstallation pdkInst = PDKInstallation.getInstance();
        return pdkInst.uploadPARArchive(parFile);
    }

    protected boolean isCoreClass(Object project, File aPathname) throws Exception {
        if (aPathname.isDirectory()) {
            return false;
        }
        File srcCoreDirectory = OpentoolsFactory.getIDEInstance().getSrcPath(project, 1);
        File classesDirectory = OpentoolsFactory.getIDEInstance().getOutPath(project, 0);
        String packageClass = aPathname.getAbsolutePath().substring(classesDirectory.getAbsolutePath().length(), aPathname.getAbsolutePath().lastIndexOf(File.separatorChar));
        String parameterName = aPathname.getName();
        StringTokenizer parameterPatern = new StringTokenizer(parameterName, ".");
        String patern = parameterPatern.nextToken();
        StringTokenizer parameterPatern2 = new StringTokenizer(patern, "$");
        String finalPatern = parameterPatern2.nextToken();
        String extension = aPathname.getAbsolutePath().substring(aPathname.getAbsolutePath().lastIndexOf(46));
        finalPatern = extension.endsWith(".class") ? finalPatern + ".java" : finalPatern + extension;
        boolean result = this.isContained(srcCoreDirectory, finalPatern, packageClass);
        return result;
    }

    private boolean isContained(File aSource, String aPatern, String aPackageClass) {
        File test = new File(aSource, aPackageClass + File.separator + aPatern);
        return test.exists();
    }

    protected void addVisibleFiles(final Object project, final String[] parentDir, final String zipPrefix, final HashMap entries, final StringBasedFileFilter acceptFilter) throws IOException {
        if (parentDir == null) {
            return;
        }
        final IDE ideInstance = OpentoolsFactory.getIDEInstance();
        StringBasedFileFilter recursionFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                int i = 0;
                while (i < segments.length && i < parentDir.length) {
                    if (!segments[i].equals(parentDir[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        };
        StringBasedFileFilter fullAcceptAcceptFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) throws IOException {
                if (isDir) {
                    return false;
                }
                if (acceptFilter.accept(segments, isDir)) {
                    File f;
                    if (segments.length < parentDir.length) {
                        return false;
                    }
                    int i = 0;
                    while (i < parentDir.length) {
                        if (!parentDir[i].equals(segments[i])) {
                            return false;
                        }
                        ++i;
                    }
                    StringBuffer fileName = new StringBuffer(zipPrefix);
                    int i2 = parentDir.length;
                    while (i2 < segments.length) {
                        fileName.append("/");
                        fileName.append(segments[i2]);
                        ++i2;
                    }
                    if (fileName.charAt(0) == '/') {
                        fileName.deleteCharAt(0);
                    }
                    if (!(f = ideInstance.getFileObjectFor(project, segments)).exists()) {
                        throw new FileNotExistException(f, segments, project);
                    }
                    entries.put(fileName.toString(), f);
                }
                return false;
            }
        };
        ideInstance.getAllFilesInProject(project, fullAcceptAcceptFilter, recursionFilter);
    }

    public void makeParArchiveFromProject(Object project, String parName, File target, boolean createSrcLibJar, boolean includeNonJavaSources, boolean shortName) throws IOException, Exception, Exception {
        HashMap<String, File> entries = new HashMap<String, File>();
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        File classesDirectory = ideInstance.getOutPath(project, 0);
        if (classesDirectory.exists() && classesDirectory.isDirectory()) {
            File parClassJarFile = File.createTempFile(parName + "TMP", "jar");
            parClassJarFile.deleteOnExit();
            ZipOutputStream classesZos = new ZipOutputStream(new FileOutputStream(parClassJarFile));
            this.addDirectoryToZipFileRecursively("", classesDirectory, classesZos, new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().endsWith(".class") || pathname.isDirectory();
                }
            });
            try {
                classesZos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            entries.put("private/lib/" + parName + ".jar", parClassJarFile);
        }
        if (createSrcLibJar) {
            File srcJarFile = File.createTempFile(parName + "TMP", "src.jar");
            srcJarFile.deleteOnExit();
            ZipOutputStream srcZos = new ZipOutputStream(new FileOutputStream(srcJarFile));
            int i = 0;
            while (i < ideInstance.getSourcePathCount(project)) {
                File srcDirectory = ideInstance.getSrcPath(project, i);
                this.addDirectoryToZipFileRecursively("", srcDirectory, srcZos, mm_acceptDirAndDotJavasFilter);
                ++i;
            }
            srcZos.close();
            entries.put("private/srclib/" + parName + ".src.jar", srcJarFile);
        }
        this.addVisibleFiles(project, new String[]{"private", "src"}, "private/classes", entries, mm_rejectDotJavasAcceptDirs);
        this.addVisibleFiles(project, new String[]{"public"}, "public", entries, StringBasedFileFilter.ACCEPT_EVERYTHING_FILE_FILTER);
        List folderNames = ideInstance.getAllFilesInProject(project, mm_reject_privateClassesSrcSrclib, mm_recurseToPrivateFilter);
        Iterator iterator = folderNames.iterator();
        while (iterator.hasNext()) {
            String[] folderOfPrivate = (String[])iterator.next();
            this.addVisibleFiles(project, folderOfPrivate, "private/" + folderOfPrivate[1], entries, StringBasedFileFilter.ACCEPT_EVERYTHING_FILE_FILTER);
        }
        this.addEntriesToZipFile(target, entries);
    }

    public void makeZarArchiveFromProject(final Object project, String parName, File target, boolean createSrcLibJar) throws Exception {
        ZipOutputStream zos;
        HashMap<String, File> entries = new HashMap<String, File>();
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        File parClassApiJarFile = File.createTempFile(parName + "api", "jar");
        File parClassCoreJarFile = File.createTempFile(parName + "core", "jar");
        File mainOutDir = ideInstance.getOutPath(project, 0);
        try {
            zos = new ZipOutputStream(new FileOutputStream(parClassCoreJarFile));
            this.addDirectoryToZipFileRecursively("", mainOutDir, zos, new FileFilter(){

                public boolean accept(File pathname) {
                    if (!pathname.getAbsolutePath().endsWith(".class")) {
                        return true;
                    }
                    try {
                        return EP5.this.isCoreClass(project, pathname);
                    }
                    catch (Exception e) {
                        return true;
                    }
                }
            });
            zos.close();
            entries.put("lib/private/" + parName + "core.jar", parClassCoreJarFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            zos = new ZipOutputStream(new FileOutputStream(parClassApiJarFile));
            this.addDirectoryToZipFileRecursively("", mainOutDir, zos, new FileFilter(){

                public boolean accept(File pathname) {
                    if (!pathname.getAbsolutePath().endsWith(".class")) {
                        return true;
                    }
                    try {
                        return !EP5.this.isCoreClass(project, pathname);
                    }
                    catch (Exception e) {
                        return true;
                    }
                }
            });
            zos.close();
            entries.put("lib/" + parName + "api.jar", parClassApiJarFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (createSrcLibJar) {
            File srcApiJarFile = File.createTempFile("TEMP" + parName, "api.src.jar");
            File srcCoreJarFile = File.createTempFile("TEMP" + parName, "core.src.jar");
            try {
                ZipOutputStream srcApiZos = new ZipOutputStream(new FileOutputStream(srcApiJarFile));
                File srcApiDirectory = ideInstance.getSrcPath(project, 0);
                this.addDirectoryToZipFileRecursively("", srcApiDirectory, srcApiZos, mm_acceptDirAndDotJavasFilter);
                srcApiZos.close();
                entries.put("private/srclibApi/" + parName + "Api.src.jar", srcApiJarFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                ZipOutputStream srcCoreZos = new ZipOutputStream(new FileOutputStream(srcCoreJarFile));
                File srcDirectory = ideInstance.getSrcPath(project, 1);
                this.addDirectoryToZipFileRecursively("", srcDirectory, srcCoreZos, mm_acceptDirAndDotJavasFilter);
                srcCoreZos.close();
                entries.put("private/srclibCore/" + parName + "Core.src.jar", srcCoreJarFile);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.addVisibleFiles(project, new String[]{"public"}, "public", entries, StringBasedFileFilter.ACCEPT_EVERYTHING_FILE_FILTER);
        this.addVisibleFiles(project, new String[]{"config"}, "config", entries, StringBasedFileFilter.ACCEPT_EVERYTHING_FILE_FILTER);
        List folderNames = ideInstance.getAllFilesInProject(project, mm_rejectSrcSrclibCoreSrclibApiClases, mm_recurseToPrivateFilter);
        Iterator iterator = folderNames.iterator();
        while (iterator.hasNext()) {
            String[] folderOfPrivate = (String[])iterator.next();
            String privateSubFolderName = folderOfPrivate[1];
            this.addVisibleFiles(project, folderOfPrivate, "private/" + privateSubFolderName, entries, StringBasedFileFilter.ACCEPT_EVERYTHING_FILE_FILTER);
        }
        this.addEntriesToZipFile(target, entries);
    }

    public void unpackZarArchive(Object project, File zarFile) throws Exception {
        String projectFolderName = OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project);
        IDE ide = OpentoolsFactory.getIDEInstance();
        String zarName = zarFile.getName();
        if (zarName.endsWith(".bak")) {
            zarName = zarName.substring(0, zarName.length() - 4);
        }
        if (zarName.endsWith(".zar")) {
            zarName = zarName.substring(0, zarName.length() - 4);
        }
        File apiSrcPath = ide.getSrcPath(project, 0);
        int lastDotIndex = zarName.lastIndexOf(46);
        String nameOfJar = lastDotIndex != -1 ? zarName.substring(lastDotIndex + 1) : zarName;
        ZipFile zip = new ZipFile(zarFile);
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            String entryName;
            ZipEntry entry = en.nextElement();
            if (entry.isDirectory() || (entryName = entry.getName()).equalsIgnoreCase("META-INF/Manifest.mf")) continue;
            if (Strings.startsWithIgnoreCase(entryName, "private/lib")) {
                if (entryName.endsWith(nameOfJar + ".jar")) continue;
                Stream.writeStreamToFile(projectFolderName + "/" + entryName.substring(7), zip.getInputStream(entry));
                continue;
            }
            if (Strings.startsWithIgnoreCase(entryName, "lib") && entryName.endsWith(nameOfJar + ".jar")) continue;
            if (Strings.startsWithIgnoreCase(entryName, "private/srclib/") && Strings.countCharOccurence(entryName, '/') == 2 && entryName.endsWith(".src.jar")) {
                this.extractZipEntryThatIsAZip(zip, entry, apiSrcPath);
                continue;
            }
            if (Strings.startsWithIgnoreCase(entryName, "private/config")) {
                Stream.writeStreamToFile(projectFolderName + "/" + entryName.substring(7), zip.getInputStream(entry));
                continue;
            }
            if (Strings.startsWithIgnoreCase(entryName, "private/classes")) {
                if (entryName.endsWith(".class")) continue;
                Stream.writeStreamToFile(apiSrcPath.getAbsolutePath(), zip.getInputStream(entry));
                continue;
            }
            Stream.writeStreamToFile(projectFolderName + "/" + entryName, zip.getInputStream(entry));
        }
        zip.close();
    }

    public String[] getPrivateResourcePath() {
        return PRIVATE_RESOURCE_PATH;
    }

    public String[] getPublicResourcePath() {
        return PUBLIC_RESOURCE_PATH;
    }

    public String[] getPossibleJSPScopes() {
        return POSSIBLE_JSP_SCOPES;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

