/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.messageeditor.sort;

import com.sap.ide.metamodel.general.i18n.TranslatableText;
import com.sap.ide.webdynpro.messageeditor.IMessageStrings;
import com.sap.ide.webdynpro.messageeditor.model.TabData;
import com.sap.ide.webdynpro.messageeditor.sort.TableSorterListener;
import java.text.Collator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class MessageTableSorter
extends ViewerSorter
implements TableSorterListener {
    public static final int TVS_SORT_UP = 1;
    public static final int TVS_SORT_DOWN = 2;
    public static final int TVS_SORT_TYPE = 1;
    public static final int TVS_SORT_TEXT = 2;
    public static final int TVS_SORT_NAME = 3;
    public static final int TVS_SORT_LEN = 4;
    private int m_sortColumn;
    private int m_sortDirection;
    private TableViewer m_toolbarTableView;

    public MessageTableSorter(TableViewer tableView) {
        this.m_toolbarTableView = tableView;
        this.m_sortDirection = 2;
    }

    public MessageTableSorter(Collator collator) {
        super(collator);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result = 0;
        TabData.MessageRowItem text1 = (TabData.MessageRowItem)e1;
        TabData.MessageRowItem text2 = (TabData.MessageRowItem)e2;
        switch (this.m_sortColumn) {
            case 3: {
                result = this.sortByName(text1, text2);
                break;
            }
            case 2: {
                result = this.sortByText(text1, text2);
                break;
            }
            case 1: {
                result = this.sortByType(text1, text2);
                break;
            }
        }
        return result;
    }

    private int sortByLen(TranslatableText text1, TranslatableText text2) {
        int res = 0;
        return res;
    }

    private int sortByType(TabData.MessageRowItem text1, TabData.MessageRowItem text2) {
        int res = 0;
        String type1 = (String)text1.getStrData(IMessageStrings.TYPE_INT);
        String type2 = (String)text2.getStrData(IMessageStrings.TYPE_INT);
        switch (this.m_sortDirection) {
            case 2: {
                res = type1.compareTo(type2);
                break;
            }
            case 1: {
                res = type2.compareTo(type1);
                break;
            }
        }
        return res;
    }

    private int sortByText(TabData.MessageRowItem text1, TabData.MessageRowItem text2) {
        int res = 0;
        String string1 = (String)text1.getData(IMessageStrings.STRING);
        String string2 = (String)text2.getData(IMessageStrings.STRING);
        switch (this.m_sortDirection) {
            case 2: {
                res = string1.compareTo(string2);
                break;
            }
            case 1: {
                res = string2.compareTo(string1);
            }
        }
        return res;
    }

    private int sortByName(TabData.MessageRowItem text1, TabData.MessageRowItem text2) {
        int res = 0;
        switch (this.m_sortDirection) {
            case 2: {
                res = ((String)text1.getData(IMessageStrings.NAME)).compareTo((String)text2.getData(IMessageStrings.NAME));
                break;
            }
            case 1: {
                res = ((String)text2.getData(IMessageStrings.NAME)).compareTo((String)text1.getData(IMessageStrings.NAME));
            }
        }
        return res;
    }

    public boolean isSorterProperty(Object element, String property) {
        return super.isSorterProperty(element, property);
    }

    public void setSortDirection(int dir) {
        this.m_sortDirection = 2 == this.m_sortDirection ? 1 : 2;
    }

    public void setSortColumn(int column) {
        this.m_sortColumn = column;
    }

    public void setSortColumn(String string) {
        if ("Message Key".equals(string)) {
            this.m_sortColumn = 3;
        }
        if ("Message Type".equals(string)) {
            this.m_sortColumn = 1;
        }
        if ("Message Text".equals(string)) {
            this.m_sortColumn = 2;
        }
    }

    public void sort() {
        this.m_toolbarTableView.setSorter(null);
        this.m_toolbarTableView.setSorter((ViewerSorter)this);
    }
}

