/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.messageeditor.model;

import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.i18n.ResourceTypeEnum;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.Message;
import com.sap.ide.metamodel.webdynpro.component.MessagePool;
import com.sap.ide.metamodel.webdynpro.enum.MessageTypeEnum;
import com.sap.ide.webdynpro.messageeditor.IMessageStrings;
import com.sap.ide.webdynpro.messageeditor.MessageeditorPlugin;
import com.sap.ide.webdynpro.messageeditor.model.IModelChangedListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

public class TabData {
    private int MPE_NAME_MAXLENGTH = 32;
    ArrayList m_elements;
    Component m_component;
    MessagePool m_messagePool;
    private ArrayList m_modelChangedListeners = new ArrayList();
    private Message[] m_messages;

    public TabData(Component component) {
        String name = null;
        this.m_component = component;
        if (null != this.m_component) {
            this.m_messagePool = this.m_component.getMessagePool();
            name = this.m_component.getName();
        }
        try {
            if (null == this.m_messagePool && null != this.m_component) {
                this.m_component.createMessagePool(name + "MessagePool");
                this.m_messagePool = this.m_component.getMessagePool();
            }
        }
        catch (CreateException e) {
            MessageeditorPlugin.internalError(this.getClass(), "TabData()", e.getMessage(), e, true);
        }
    }

    public void raiseModelChangedEvent() {
        if (null != this.m_modelChangedListeners) {
            int i = 0;
            while (i < this.m_modelChangedListeners.size()) {
                IModelChangedListener listener = (IModelChangedListener)this.m_modelChangedListeners.get(i);
                listener.onTableModelChanged();
                ++i;
            }
        }
    }

    public Object[] getRowElements() {
        ArrayList<MessageRowItem> elements = null;
        if (null == this.m_messages) {
            this.m_messages = this.m_messagePool.getMessages();
            this.m_elements = new ArrayList(this.m_messagePool.getMessageCount());
            int i = 0;
            while (i < this.m_messagePool.getMessageCount()) {
                Message m = this.m_messages[i];
                MessageRowItem label = new MessageRowItem(this.m_messages[i], false, this);
                this.m_elements.add(label);
                ++i;
            }
        }
        elements = new ArrayList<MessageRowItem>();
        Iterator iter = ((AbstractList)this.m_elements).iterator();
        while (iter.hasNext()) {
            MessageRowItem element = (MessageRowItem)iter.next();
            if (element.isDeleted()) continue;
            elements.add(element);
        }
        return elements.toArray();
    }

    public void addModelChangedListener(IModelChangedListener listener) {
        this.m_modelChangedListeners.add(listener);
    }

    public void commit() {
        try {
            int i = 0;
            while (i < this.m_elements.size()) {
                MessageRowItem element = (MessageRowItem)this.m_elements.get(i);
                element.commit();
                ++i;
            }
            int i2 = 0;
            while (i2 < this.m_elements.size()) {
                MessageRowItem element = (MessageRowItem)this.m_elements.get(i2);
                if (element.isDeleted()) {
                    this.m_elements.remove(i2);
                }
                ++i2;
            }
        }
        catch (RuntimeException e) {
            MessageeditorPlugin.internalError(this.getClass(), "commit()", e.getMessage(), e, true);
        }
    }

    public MessageRowItem getMessageInstance() {
        MessageRowItem item = null;
        item = new MessageRowItem(null, true, this);
        return item;
    }

    public void refreshModel() {
        this.m_messages = null;
    }

    public class MessageRowItem {
        private TabData mParent;
        private Message m_messageInstance;
        private String m_messageName;
        private String m_messageContent;
        private MessageTypeEnum m_messageType;
        private HashMap mTypeMap;
        private String[] mValuesforType;
        private boolean m_isNew;
        private String m_errMessage;
        private boolean m_isDeleted;

        public MessageRowItem(Message message, boolean isNew, TabData parent) {
            this.m_messageInstance = message;
            this.mParent = parent;
            this.m_isNew = isNew;
            this.mTypeMap = new HashMap();
            this.m_messageType = MessageTypeEnum.valueOf((String)"standard");
            this.m_messageName = "";
            this.mTypeMap.put(MessageTypeEnum.ERROR, "ERROR");
            this.mTypeMap.put(MessageTypeEnum.STANDARD, "STANDARD");
            this.mTypeMap.put(MessageTypeEnum.WARNING, "WARNING");
            Enumeration typeValues = MessageTypeEnum.enumerate();
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (typeValues.hasMoreElements()) {
                MessageTypeEnum mte = (MessageTypeEnum)typeValues.nextElement();
                list.add(mte.toString());
                ++i;
            }
            this.mValuesforType = new String[list.size()];
            list.toArray(this.mValuesforType);
            if (this.m_messageInstance != null) {
                this.m_messageName = this.m_messageInstance.getName();
                this.m_messageContent = this.m_messageInstance.getContent();
                this.m_messageType = this.m_messageInstance.getMessageType();
            }
        }

        private Object convertToInteger(MessageTypeEnum MessageType) {
            String str = MessageType.toString();
            int i = 0;
            while (i < this.mValuesforType.length) {
                if (this.mValuesforType[i] == str) {
                    return new Integer(i);
                }
                ++i;
            }
            return new Integer(0);
        }

        private String getComboDataAsString(int colIndex) {
            return this.m_messageType.toString();
        }

        private MessageTypeEnum convertToMessageType(Object value) {
            if (value instanceof String) {
                String val = (String)value;
                if (val == "STANDARD") {
                    return MessageTypeEnum.STANDARD;
                }
                if (val == "WARNING") {
                    return MessageTypeEnum.WARNING;
                }
                if (val == "ERROR") {
                    return MessageTypeEnum.ERROR;
                }
            }
            if (value instanceof Integer) {
                Integer i = (Integer)value;
                return MessageTypeEnum.valueOf((String)this.mValuesforType[i]);
            }
            return MessageTypeEnum.STANDARD;
        }

        private String convertToString(MessageTypeEnum type) {
            if (type == MessageTypeEnum.ERROR) {
                return "";
            }
            return "";
        }

        public String getData() {
            return "Data";
        }

        public Object getData(String property) {
            if (property == IMessageStrings.NAME) {
                return this.m_messageName;
            }
            if (property == IMessageStrings.TYPE) {
                return this.convertToInteger(this.m_messageType);
            }
            if (property == IMessageStrings.STRING) {
                return this.m_messageContent;
            }
            return "";
        }

        public int getIntData() {
            return 0;
        }

        public Object getStrData(int colIndex) {
            if (colIndex == IMessageStrings.NAME_INT) {
                return (String)this.getData(IMessageStrings.NAME);
            }
            if (colIndex == IMessageStrings.TYPE_INT) {
                return this.getComboDataAsString(1);
            }
            if (colIndex == IMessageStrings.TEXT_INT) {
                return (String)this.getData(IMessageStrings.STRING);
            }
            return "";
        }

        public void setData(String property, Object value) {
            if (property == IMessageStrings.NAME) {
                this.m_messageName = (String)value;
            }
            if (property == IMessageStrings.TYPE) {
                this.m_messageType = this.convertToMessageType(value);
            }
            if (property == IMessageStrings.STRING) {
                this.m_messageContent = (String)value;
            }
        }

        public String commit() {
            try {
                boolean modelChanged = false;
                if (this.m_isDeleted) {
                    try {
                        this.m_messageInstance.delete();
                        modelChanged = true;
                    }
                    catch (DeleteException e) {
                        MessageeditorPlugin.internalError(this.getClass(), "commit()", e.getMessage(), e, true);
                    }
                } else {
                    this.m_errMessage = this.validate(this.m_isNew);
                    if (this.m_errMessage.compareTo("") == 0) {
                        if (this.m_messageInstance == null) {
                            this.m_messageInstance = TabData.this.m_messagePool.createMessage(this.m_messageName);
                        }
                        this.m_messageInstance.setMessageType(this.m_messageType);
                        this.m_messageInstance.setContent(this.m_messageContent);
                        if (this.m_messageContent != null && !this.m_messageContent.equals("")) {
                            if (this.m_messageType == MessageTypeEnum.WARNING) {
                                this.m_messageInstance.getContentAsTranslatableText().setResourceType(ResourceTypeEnum.WARNINGMESSAGE);
                            } else if (this.m_messageType == MessageTypeEnum.ERROR) {
                                this.m_messageInstance.getContentAsTranslatableText().setResourceType(ResourceTypeEnum.ERRORMESSAGE);
                            } else {
                                this.m_messageInstance.getContentAsTranslatableText().setResourceType(ResourceTypeEnum.INFORMATIONMESSAGE);
                            }
                        }
                        this.m_isNew = false;
                        modelChanged = true;
                    }
                }
            }
            catch (CreateException e) {
                this.m_errMessage = e.getMessage();
                MessageeditorPlugin.internalError(this.getClass(), "commit()", e.getMessage(), e, true);
                return this.m_errMessage;
            }
            return this.m_errMessage;
        }

        public String[] getValuesForType() {
            return this.mValuesforType;
        }

        public Message getMessageObject() {
            return this.m_messageInstance;
        }

        public String validate(boolean isNew) {
            String err = "";
            if (this.m_messageName == "") {
                err = "The Message Key cannot be blank";
            }
            if (isNew && TabData.this.m_messagePool.hasMessage(this.m_messageName)) {
                err = "A Message with this Key already exists for this component";
            }
            char[] chars = this.m_messageName.toCharArray();
            int i = 0;
            while (i < chars.length) {
                boolean isValid;
                char value = chars[i];
                boolean conditionLetter = Character.isLetter(value);
                boolean conditionUnderscore = value == '_';
                boolean conditionSlash = value == '\\';
                boolean conditionDigit = Character.isDigit(value);
                boolean conditionLength = this.m_messageName.length() < TabData.this.MPE_NAME_MAXLENGTH;
                boolean bl = isValid = (conditionLetter || conditionUnderscore || conditionSlash || conditionDigit) && conditionLength;
                if (!isValid) {
                    err = "The Message Key is invalid. Please enter a valid name";
                    break;
                }
                ++i;
            }
            return err;
        }

        public void delete() {
            this.m_isDeleted = true;
            TabData.this.raiseModelChangedEvent();
        }

        public TabData getParent() {
            return this.mParent;
        }

        public void save() {
            if (this.m_isNew && !this.m_isDeleted) {
                TabData.this.m_elements.add(this);
            }
            this.commit();
        }

        public boolean isDeleted() {
            return this.m_isDeleted;
        }
    }
}

