/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.messageeditor.editor;

import com.sap.ide.webdynpro.messageeditor.MessageeditorPlugin;
import com.sap.ide.webdynpro.messageeditor.editor.IMessageEditorInput;
import com.sap.ide.webdynpro.messageeditor.editor.IMessageEditorLauncher;
import com.sap.ide.webdynpro.messageeditor.editor.MessageEditorPart;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class MessageEditorLauncher
implements IMessageEditorLauncher {
    private static HashMap mMessageEditorMap;
    private IPartListener mPartlistener;

    public MessageEditorLauncher() {
        if (null == mMessageEditorMap) {
            mMessageEditorMap = new HashMap(10);
        }
    }

    public void openMessageEditor(IMessageEditorInput messageInput) {
        IEditorPart editorPart = this.findEditor(messageInput);
        if (null == editorPart) {
            editorPart = this.openEditor(messageInput);
            this.mPartlistener = this.getPartListener();
            editorPart.getEditorSite().getPage().addPartListener(this.mPartlistener);
        } else {
            this.activateEditor(editorPart);
        }
    }

    protected IPartListener getPartListener() {
        return new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                MessageEditorLauncher.this.disposeEditor(part);
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
    }

    private void disposeEditor(IWorkbenchPart part) {
        if (part instanceof MessageEditorPart) {
            MessageEditorPart epart = (MessageEditorPart)part;
            IMessageEditorInput input = (IMessageEditorInput)epart.getEditorInput();
            epart.getEditorSite().getPage().removePartListener(this.mPartlistener);
            mMessageEditorMap.remove(input.getComponent());
        }
    }

    private void activateEditor(IEditorPart editorPart) {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)editorPart);
    }

    private IEditorPart openEditor(IMessageEditorInput messageInput) {
        IEditorPart editorPart = null;
        try {
            editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)messageInput, messageInput.getEditorID());
        }
        catch (PartInitException e) {
            MessageeditorPlugin.internalError(this.getClass(), "openEditor()", e.getMessage(), e, true);
        }
        mMessageEditorMap.put(messageInput.getComponent(), editorPart);
        return editorPart;
    }

    private IEditorPart findEditor(IMessageEditorInput messageInput) {
        IEditorPart editorPart = null;
        if (null != messageInput && mMessageEditorMap.containsKey(messageInput.getComponent())) {
            editorPart = (IEditorPart)mMessageEditorMap.get(messageInput.getComponent());
        }
        return editorPart;
    }

    public void open(IFile file) {
    }
}

