/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.messageeditor.editor;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.MessagePool;
import com.sap.ide.metamodel.webdynpro.enum.MessageTypeEnum;
import com.sap.ide.metamodel.webdynpro.repository.MessagePoolRepositoryManager;
import com.sap.ide.webdynpro.messageeditor.IMessageStrings;
import com.sap.ide.webdynpro.messageeditor.MessageeditorPlugin;
import com.sap.ide.webdynpro.messageeditor.dialog.MessageEditorDialog;
import com.sap.ide.webdynpro.messageeditor.editor.MessageEditorPart;
import com.sap.ide.webdynpro.messageeditor.filter.CustomFilterDialog;
import com.sap.ide.webdynpro.messageeditor.filter.CustomTabViewerFilter;
import com.sap.ide.webdynpro.messageeditor.model.IModelChangedListener;
import com.sap.ide.webdynpro.messageeditor.model.MessageLabelProvider;
import com.sap.ide.webdynpro.messageeditor.model.MessageTableModel;
import com.sap.ide.webdynpro.messageeditor.model.TabData;
import com.sap.ide.webdynpro.messageeditor.sort.MessageTableSorter;
import com.sap.ide.webdynpro.messageeditor.sort.TableSorterListener;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.glpc.form.AbstractForm;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import com.tssap.util.ui.lfsupport.DefaultWidgetFactory;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.IToolBarPane;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class MessageEditor
extends AbstractForm {
    private AddAction m_AddAction;
    public static final String MPE_MESSAGE_TEXT = "Message Text";
    public static final String MPE_MESSAGE_TYPE = "Message Type";
    public static final String MPE_MESSAGE_KEY = "Message Key";
    private static final int ME_ADD_COMMAND = 0;
    private static final int ME_EDIT_COMMAND = 1;
    private static final int ME_DELETE_COMMAND = 2;
    private static final int MSG_TYPE_COUNT = 3;
    private static final String IMG_NEW_MESSAGE = "resources/icons/NewMessage.gif";
    private static final String IMG_EDIT_MESSAGE = "resources/icons/EditMessage.gif";
    private static final String IMG_DELETE_MESSAGE = "resources/icons/DeleteMessage.gif";
    private static String[] ms_TableColumnProperties = new String[]{IMessageStrings.NAME, IMessageStrings.TYPE, IMessageStrings.STRING};
    private TableSorterListener m_sorterListner;
    private CustomTabViewerFilter m_filter;
    private Button m_setFilterButton;
    private Button m_ActivateFilterButton;
    private CustomTabViewerFilter m_customFilter;
    private Menu m_tableMenu;
    private Component m_Component;
    private MessageTableModel m_messageTableModel;
    private MenuManager m_ContextMenu;
    private Table m_MessageTableControl;
    private TableViewer m_TableViewer;
    private IToolBarPane m_toolbarPane;
    private TabData m_TableData;
    private SelectionListener m_tableSelectListener;
    private SelectionListener m_toolbarListener;
    private boolean m_IsDirty;
    private IModelChangedListener m_ModelChangedListener;
    private Button m_DeleteButton;
    private Button m_EditButton;
    private Button m_AddButton;
    private MenuManager m_MenuManager;
    private DeleteAction m_DeleteAction;
    private EditAction m_EditAction;
    protected MessageEditorPart m_MessageEditorPart;

    public MessageEditor(Component component, MessageEditorPart mec) {
        super((IWidgetFactory)new DefaultWidgetFactory(), 2, "Message Editor");
        this.m_Component = component;
        this.m_MessageEditorPart = mec;
        this.m_IsDirty = false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.m_MessageTableControl.removeSelectionListener(this.m_tableSelectListener);
    }

    protected SelectionListener getTableSelectionListener() {
        SelectionAdapter tabListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                MessageEditor.this.m_AddButton.setEnabled(true);
                MessageEditor.this.setTableContextMenu();
            }
        };
        return tabListener;
    }

    protected SelectionListener getToolbarListener() {
        ToolSelectionAdapter headerListener = new ToolSelectionAdapter();
        return headerListener;
    }

    protected void setupCellEditors(TableViewer tv) {
        CellEditor[] editors = new CellEditor[3];
        editors[0] = new TextCellEditor((Composite)this.m_MessageTableControl);
        editors[0].addListener((ICellEditorListener)new CellEditorListener());
        ArrayList list = MessageEditor.getMessageTypes();
        String[] typeStrings = new String[list.size()];
        list.toArray(typeStrings);
        editors[1] = new ComboBoxCellEditor((Composite)this.m_MessageTableControl, typeStrings);
        editors[1].addListener((ICellEditorListener)new CellEditorListener());
        editors[2] = new TextCellEditor((Composite)this.m_MessageTableControl);
        editors[2].addListener((ICellEditorListener)new CellEditorListener());
        TextCellEditor messageEditor = (TextCellEditor)editors[2];
        Text txt = (Text)messageEditor.getControl();
        tv.setCellEditors(editors);
        editors[0].setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                return null;
            }
        });
        editors[1].setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                return null;
            }
        });
        editors[2].setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                String str = (String)value;
                if (16384 < str.length()) {
                    return "Text is longer than allowed";
                }
                return null;
            }
        });
        tv.setColumnProperties(ms_TableColumnProperties);
        tv.setCellModifier((ICellModifier)new CellModifier());
    }

    public static ArrayList getMessageTypes() {
        Enumeration typeValues = MessageTypeEnum.enumerate();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (typeValues.hasMoreElements()) {
            MessageTypeEnum mte = (MessageTypeEnum)typeValues.nextElement();
            list.add(mte.toString());
            ++i;
        }
        return list;
    }

    protected void setupTableData(TableViewer tv) {
        this.m_TableData = null;
        try {
            this.m_TableData = new TabData(this.m_Component);
            tv.setInput((Object)this.m_TableData);
            this.m_ModelChangedListener = new IModelChangedListener(){

                public void onTableModelChanged() {
                    MessageEditor.this.m_IsDirty = true;
                    MessageEditor.this.updateTable(null, null);
                    MessageEditor.this.m_MessageEditorPart.setDirty(MessageEditor.this.m_IsDirty);
                }

                public void onRowItemChanged(Object rowItem, Object[] property) {
                    MessageEditor.this.m_IsDirty = true;
                    MessageEditor.this.updateTable(rowItem, (String[])property);
                    MessageEditor.this.m_MessageEditorPart.setDirty(MessageEditor.this.m_IsDirty);
                }
            };
            this.m_TableData.addModelChangedListener(this.m_ModelChangedListener);
        }
        catch (Exception e1) {
            MessageeditorPlugin.internalError(((Object)((Object)this)).getClass(), "setupTableData()", e1.getMessage(), e1, true);
        }
    }

    protected void createColumns(Table tab, SelectionListener headerListener) {
        tab.setHeaderVisible(true);
        TableColumnSelectionListener tableHeaderListener = new TableColumnSelectionListener();
        tab.removeAll();
        TableColumn tc = new TableColumn(tab, 0, 0);
        tc.setResizable(true);
        tc.setText(MPE_MESSAGE_KEY);
        tc.setData((Object)MPE_MESSAGE_KEY);
        tc.addSelectionListener((SelectionListener)tableHeaderListener);
        tc = new TableColumn(tab, 0, 1);
        tc.setResizable(true);
        tc.setText(MPE_MESSAGE_TYPE);
        tc.setData((Object)MPE_MESSAGE_TYPE);
        tc.addSelectionListener((SelectionListener)tableHeaderListener);
        tc = new TableColumn(tab, 0, 2);
        tc.setResizable(true);
        tc.setText(MPE_MESSAGE_TEXT);
        tc.setData((Object)MPE_MESSAGE_TEXT);
        tc.addSelectionListener((SelectionListener)tableHeaderListener);
        ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(75), new ColumnWeightData(75), new ColumnWeightData(175)};
        TableLayout l = new TableLayout();
        int i = 0;
        while (i < columnLayouts.length) {
            l.addColumnData(columnLayouts[i]);
            ++i;
        }
        tab.setLayout((Layout)l);
    }

    protected void setupMenu(TableViewer tv, Table tab) {
        this.m_MenuManager = new MenuManager("#PopupMenu");
        this.m_MenuManager.setRemoveAllWhenShown(false);
        this.m_tableMenu = this.m_MenuManager.createContextMenu((Control)tab);
        this.addMenuItems((IMenuManager)this.m_MenuManager);
        this.m_MenuManager.addMenuListener((IMenuListener)new MEMenuListener());
        this.m_MessageEditorPart.getSite().registerContextMenu(this.m_MenuManager, (ISelectionProvider)tv);
        tab.setMenu(this.m_tableMenu);
    }

    private void addMenuItems(IMenuManager mgr) {
        mgr.add((IContributionItem)new Separator("additions"));
        this.m_AddAction = new AddAction();
        mgr.add((IAction)this.m_AddAction);
        this.m_EditAction = new EditAction();
        mgr.add((IAction)this.m_EditAction);
        this.m_DeleteAction = new DeleteAction();
        mgr.add((IAction)this.m_DeleteAction);
        mgr.add((IContributionItem)new Separator());
    }

    protected void addTableViewer(IGridLayoutPane glp) {
        this.m_TableViewer = glp.addTableViewer(true);
        this.m_MessageTableControl = this.m_TableViewer.getTable();
        GridData gdata = new GridData(0);
        gdata.verticalSpan = 5;
        gdata.horizontalSpan = 1;
        gdata.grabExcessVerticalSpace = true;
        gdata.grabExcessHorizontalSpace = true;
        gdata.horizontalAlignment = 4;
        gdata.verticalAlignment = 4;
        this.m_MessageTableControl.setLayoutData((Object)gdata);
        this.m_MessageTableControl.addSelectionListener(this.m_tableSelectListener);
    }

    protected void addToolbarButtons(IGridLayoutPane glp, SelectionListener headerListener) {
        Image img = null;
        img = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_NEW_MESSAGE);
        this.m_AddButton = new Button(glp.getComposite(), 0x800008);
        this.m_AddButton.setText("button1");
        this.m_AddButton.setImage(img);
        this.m_AddButton.setToolTipText("Add Message");
        this.m_AddButton.setData((Object)"AddMessage");
        this.m_AddButton.addSelectionListener(headerListener);
        img = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_EDIT_MESSAGE);
        this.m_EditButton = new Button(glp.getComposite(), 0x800008);
        this.m_EditButton.setText("button2");
        this.m_EditButton.setImage(img);
        this.m_EditButton.setToolTipText("Edit this message - open editor dialog");
        this.m_EditButton.setData((Object)"EditMessage");
        this.m_EditButton.addSelectionListener(headerListener);
        img = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_DELETE_MESSAGE);
        this.m_DeleteButton = new Button(glp.getComposite(), 0x800008);
        this.m_DeleteButton.setText("button3");
        this.m_DeleteButton.setImage(img);
        this.m_DeleteButton.setToolTipText("Delete this message");
        this.m_DeleteButton.setData((Object)"DeleteMessage");
        this.m_DeleteButton.addSelectionListener(headerListener);
        GridData data = new GridData(2);
        this.m_DeleteButton.setLayoutData((Object)data);
        img = SapIdeUtilImages.getImageFromIconsDirectory((IPluginDescriptor)MessageeditorPlugin.getDefault().getDescriptor(), (String)"Filter.ico");
        this.m_setFilterButton = new Button(glp.getComposite(), 0x800008);
        this.m_setFilterButton.setText("Set Filter");
        this.m_setFilterButton.setImage(img);
        this.m_setFilterButton.setToolTipText("Set Filter To Table");
        this.m_setFilterButton.setData((Object)"SetFilter");
        this.m_setFilterButton.addSelectionListener(this.getToolbarListener());
        data = new GridData(2);
        this.m_setFilterButton.setLayoutData((Object)data);
        img = SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_ACTIVATE);
        this.m_ActivateFilterButton = new Button(glp.getComposite(), 2);
        this.m_ActivateFilterButton.setText("Activate Filter");
        this.m_ActivateFilterButton.setImage(img);
        this.m_ActivateFilterButton.setToolTipText("Activate Filter On Table");
        this.m_ActivateFilterButton.setData((Object)"ActivateFilter");
        this.m_ActivateFilterButton.addSelectionListener(this.getToolbarListener());
        data = new GridData(2);
        this.m_ActivateFilterButton.setLayoutData((Object)data);
    }

    private void setTableContextMenu() {
        ISelection selection = null;
        selection = this.m_TableViewer.getSelection();
        int[] menuItems = new int[]{1, 2, 3};
        this.setCommandStates(0, menuItems, true);
        if (selection.isEmpty()) {
            this.setCommandStates(1, menuItems, false);
            this.setCommandStates(2, menuItems, false);
        } else {
            if (((Table)this.m_TableViewer.getControl()).getSelectionCount() == 1) {
                this.setCommandStates(1, menuItems, true);
            } else {
                this.setCommandStates(1, menuItems, false);
            }
            this.setCommandStates(2, menuItems, true);
        }
    }

    private void setCommandStates(int cmdID, int[] name, boolean isEnabled) {
        MenuItem item = null;
        Button btn = null;
        switch (cmdID) {
            case 0: {
                btn = this.m_AddButton;
                if (this.m_MenuManager.getMenu().getItemCount() <= 0) break;
                item = this.m_MenuManager.getMenu().getItem(0);
                break;
            }
            case 1: {
                if (this.m_MenuManager.getMenu().getItemCount() > 0) {
                    item = this.m_MenuManager.getMenu().getItem(1);
                }
                btn = this.m_EditButton;
                break;
            }
            case 2: {
                if (this.m_MenuManager.getMenu().getItemCount() >= 2) {
                    item = this.m_MenuManager.getMenu().getItem(2);
                }
                btn = this.m_DeleteButton;
                break;
            }
        }
        btn.setEnabled(isEnabled);
        if (null != item) {
            item.setEnabled(isEnabled);
        }
    }

    private void onAddMessage() {
        boolean writable = this.isWritable();
        if (writable) {
            TableItem[] item = this.m_MessageTableControl.getSelection();
            TabData.MessageRowItem label = this.m_TableData.getMessageInstance();
            MessageEditorDialog dlg = new MessageEditorDialog(this.m_MessageEditorPart.getSite().getShell(), label, true);
            dlg.setMessagePool(this.m_Component.getMessagePool());
            dlg.open();
        }
    }

    private void onEditMessage() {
        TableItem[] item;
        boolean writable = this.isWritable();
        if (writable && 0 < (item = this.m_MessageTableControl.getSelection()).length) {
            TabData.MessageRowItem label = (TabData.MessageRowItem)item[0].getData();
            MessageEditorDialog dlg = new MessageEditorDialog(this.m_MessageEditorPart.getSite().getShell(), label, false);
            dlg.open();
        }
    }

    private void onDeleteMessage() {
        boolean writable = this.isWritable();
        Vector<TabData.MessageRowItem> vector = new Vector<TabData.MessageRowItem>();
        if (writable) {
            TableItem[] item = this.m_MessageTableControl.getSelection();
            int i = 0;
            while (i < item.length) {
                TableItem tableItem = item[i];
                TabData.MessageRowItem label = (TabData.MessageRowItem)tableItem.getData();
                if (null != label) {
                    vector.add(label);
                }
                ++i;
            }
            Iterator iter = ((AbstractList)vector).iterator();
            while (iter.hasNext()) {
                TabData.MessageRowItem element = (TabData.MessageRowItem)iter.next();
                element.delete();
                element.commit();
            }
        }
    }

    private void onSetFilter() {
        Vector vector = new Vector();
        this.m_customFilter = new CustomTabViewerFilter();
        CustomFilterDialog dialog = new CustomFilterDialog(this.m_MessageEditorPart.getSite().getShell(), this.m_customFilter);
        ArrayList items = MessageEditor.getMessageTypes();
        dialog.addListItems(items);
        dialog.open();
    }

    private void onActivateFilter() {
        try {
            if (null != this.m_ActivateFilterButton && this.m_ActivateFilterButton.getSelection()) {
                this.setFilter(this.m_customFilter);
            } else {
                this.setFilter(null);
            }
        }
        catch (Exception e) {
            MessageeditorPlugin.internalError(((Object)((Object)this)).getClass(), "onActivateFilter()", e.getMessage(), e, true);
        }
    }

    private void initCommandStates() {
        boolean isWritable = true;
        int[] name = new int[]{1, 2};
        this.setCommandStates(0, name, isWritable);
        this.setCommandStates(1, name, isWritable);
        this.setCommandStates(2, name, isWritable);
    }

    private boolean isWritable() {
        try {
            MMRepositoryObject repositoryObject = MessagePoolRepositoryManager.getRepositioryObject((MessagePool)this.m_Component.getMessagePool(), (boolean)false);
            MMRepositoryObject[] repObjects = new MMRepositoryObject[]{repositoryObject};
            return RepositoryServices.checkWriteability((MMRepositoryObject[])repObjects);
        }
        catch (Exception e) {
            MessageeditorPlugin.internalError(((Object)((Object)this)).getClass(), "isWritable()", e.getMessage(), e, true);
            return false;
        }
    }

    public void initForm(IGridLayoutPane glp) {
        GridLayout gridLayout = new GridLayout(0, false);
        gridLayout.numColumns = 2;
        glp.getComposite().setLayout((Layout)gridLayout);
        this.m_tableSelectListener = this.getTableSelectionListener();
        this.m_toolbarListener = this.getToolbarListener();
        this.m_messageTableModel = new MessageTableModel();
        String[] ele = new String[]{"First", "Second", "Third"};
        this.addTableViewer(glp);
        this.setupMenu(this.m_TableViewer, this.m_MessageTableControl);
        this.m_TableViewer.setContentProvider((IContentProvider)this.m_messageTableModel);
        this.m_TableViewer.setLabelProvider((IBaseLabelProvider)new MessageLabelProvider(this.m_messageTableModel));
        this.m_sorterListner = new MessageTableSorter(this.m_TableViewer);
        this.createColumns(this.m_MessageTableControl, this.m_toolbarListener);
        this.setupTableData(this.m_TableViewer);
        this.addToolbarButtons(glp, this.m_toolbarListener);
        this.initCommandStates();
    }

    public void updateTable(Object e, String[] property) {
        if (null == e) {
            this.m_TableViewer.refresh();
        } else {
            this.m_TableViewer.update(e, property);
        }
    }

    public void setDirty(boolean isDirty) {
        boolean dirty = this.m_IsDirty;
        this.m_IsDirty = isDirty;
        if (isDirty != dirty) {
            this.m_MessageEditorPart.setDirty(isDirty);
        }
    }

    public boolean isDirty() {
        return this.m_IsDirty;
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        switch (context.getKind()) {
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void commit() {
        this.m_TableData.commit();
        this.m_IsDirty = false;
        this.updateTable(null, null);
    }

    public void refresh() {
        this.m_TableData.refreshModel();
        this.m_TableViewer.refresh();
    }

    public void setFilter(CustomTabViewerFilter filter) {
        if (null != filter) {
            this.m_TableViewer.removeFilter((ViewerFilter)filter);
            this.m_TableViewer.addFilter((ViewerFilter)filter);
            this.m_filter = filter;
        } else {
            this.m_TableViewer.removeFilter((ViewerFilter)this.m_filter);
        }
    }

    private class TableColumnSelectionListener
    implements SelectionListener {
        private String m_lastColumn;

        private TableColumnSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn column = (TableColumn)e.getSource();
            if (null != this.m_lastColumn && this.m_lastColumn.equals((String)column.getData())) {
                MessageEditor.this.m_sorterListner.setSortDirection(0);
            }
            this.m_lastColumn = (String)column.getData();
            MessageEditor.this.m_sorterListner.setSortColumn((String)column.getData());
            MessageEditor.this.m_sorterListner.sort();
        }
    }

    private class FilterActivateAction
    extends Action {
        private FilterActivateAction() {
        }

        public void run() {
            if (MessageEditor.this.m_ActivateFilterButton.getSelection()) {
                MessageEditor.this.setFilter(MessageEditor.this.m_customFilter);
            } else {
                MessageEditor.this.setFilter(null);
            }
        }
    }

    private class FilterAction
    extends Action {
        private FilterAction() {
        }

        public void run() {
            CustomFilterDialog dialog = new CustomFilterDialog(null, MessageEditor.this.m_customFilter);
            ArrayList items = new ArrayList();
            dialog.addListItems(items);
            dialog.open();
        }
    }

    private class MEMenuListener
    implements IMenuListener {
        private MEMenuListener() {
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            MessageEditor.this.setTableContextMenu();
        }
    }

    class ToolSelectionAdapter
    extends SelectionAdapter {
        ToolSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if ("AddMessage" == e.widget.getData()) {
                MessageEditor.this.onAddMessage();
            }
            if ("EditMessage" == e.widget.getData() && MessageEditor.this.m_MessageTableControl.getSelectionCount() == 1) {
                MessageEditor.this.onEditMessage();
            }
            if ("DeleteMessage" == e.widget.getData() && MessageEditor.this.m_MessageTableControl.getSelectionCount() >= 1) {
                MessageEditor.this.onDeleteMessage();
            }
            if ("SetFilter" == e.widget.getData()) {
                MessageEditor.this.onSetFilter();
            }
            if ("ActivateFilter" == e.widget.getData()) {
                MessageEditor.this.onActivateFilter();
            }
        }
    }

    class DeleteAction
    extends Action {
        public void run() {
            MessageEditor.this.onDeleteMessage();
        }

        public String getText() {
            return "Delete";
        }

        public void runWithEvent(Event event) {
            MessageEditor.this.onDeleteMessage();
        }
    }

    class EditAction
    extends Action {
        public void run() {
            MessageEditor.this.onEditMessage();
        }

        public String getText() {
            return "Edit";
        }

        public void runWithEvent(Event event) {
            MessageEditor.this.onEditMessage();
        }
    }

    class AddAction
    extends Action {
        public void run() {
            MessageEditor.this.onAddMessage();
        }

        public String getText() {
            return "Add";
        }

        public void runWithEvent(Event event) {
            MessageEditor.this.onAddMessage();
        }
    }

    class CellModifier
    implements ICellModifier {
        CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            boolean writable = MessageEditor.this.isWritable();
            if (writable && property == IMessageStrings.NAME) {
                writable = false;
            }
            return writable;
        }

        public Object getValue(Object element, String property) {
            TabData.MessageRowItem label = (TabData.MessageRowItem)element;
            return label.getData(property);
        }

        public void modify(Object element, String property, Object value) {
            if (null != value) {
                TableItem item = (TableItem)element;
                TabData.MessageRowItem label = (TabData.MessageRowItem)item.getData();
                label.setData(property, value);
                Object[] props = new String[]{property};
                MessageEditor.this.m_ModelChangedListener.onRowItemChanged(item.getData(), props);
                boolean i = false;
                i = true;
                label.commit();
            }
        }
    }

    class CellEditorListener
    implements ICellEditorListener {
        CellEditorListener() {
        }

        public void applyEditorValue() {
        }

        public void cancelEditor() {
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            newValidState = MessageEditor.this.isWritable();
        }
    }
}

