/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.messageeditor.dialog;

import com.sap.ide.metamodel.webdynpro.component.MessagePool;
import com.sap.ide.metamodel.webdynpro.enum.MessageTypeEnum;
import com.sap.ide.webdynpro.messageeditor.IMessageStrings;
import com.sap.ide.webdynpro.messageeditor.model.TabData;
import java.util.Enumeration;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MessageEditorDialog
extends TitleAreaDialog {
    public static final int MPE_TEXT_LIMIT = 16384;
    public static final int MPE_TEXTNAME_LIMIT = 32;
    private Text m_ErrorMessageTextBox;
    private TabData.MessageRowItem m_Label;
    private Text m_NameTextBox;
    private Text m_MessageTextBox;
    private Combo m_MessageTypeCombo;
    private boolean m_IsNew;
    private MessagePool m_messagePool;

    public MessageEditorDialog(Shell parent) {
        super(parent);
        this.setTitle("Message Editor");
        this.setShellStyle(67616);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Message Editor");
    }

    public MessageEditorDialog(Shell parentShell, TabData.MessageRowItem label, boolean isNew) {
        super(parentShell);
        this.setShellStyle(67616);
        this.m_IsNew = isNew;
        this.m_Label = label;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite shell = new Composite(parentComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        shell.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        shell.setLayoutData((Object)data);
        Image newTitleImage = null;
        this.setTitleImage(newTitleImage);
        Label label0 = new Label(shell, 0);
        label0.setText("Message Key");
        this.m_NameTextBox = new Text(shell, 2048);
        this.m_NameTextBox.setText("");
        this.m_NameTextBox.setTextLimit(32);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.m_NameTextBox.setLayoutData((Object)data);
        if (this.m_IsNew) {
            this.m_NameTextBox.setEditable(true);
            this.getShell().setText("New Message");
        } else {
            this.m_NameTextBox.setEditable(false);
            this.getShell().setText("Edit Message");
        }
        Label label2 = new Label(shell, 0);
        label2.setText("Message Type");
        this.m_MessageTypeCombo = new Combo(shell, 12);
        data = new GridData();
        data.horizontalAlignment = 4;
        this.m_MessageTypeCombo.setLayoutData((Object)data);
        Label label4 = new Label(shell, 0);
        label4.setText("Message Text");
        data = new GridData();
        data.verticalAlignment = 1;
        label4.setLayoutData((Object)data);
        this.m_MessageTextBox = new Text(shell, 2818);
        this.m_MessageTextBox.setText("");
        this.m_MessageTextBox.setTextLimit(16384);
        data = new GridData();
        data.heightHint = 55;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        this.m_MessageTextBox.setLayoutData((Object)data);
        this.m_ErrorMessageTextBox = new Text(shell, 2);
        this.m_ErrorMessageTextBox.setText("");
        this.m_ErrorMessageTextBox.setEditable(false);
        this.m_ErrorMessageTextBox.setForeground(new Color((Device)this.getShell().getDisplay(), 200, 0, 0));
        this.m_ErrorMessageTextBox.setBackground(shell.getBackground());
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 3;
        data.grabExcessVerticalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 2;
        this.m_ErrorMessageTextBox.setLayoutData((Object)data);
        this.setTitle("Edit the message contents here. ");
        this.fillContentData();
        this.setMessage("The Message Key can consist of a-z A-Z 0-9 & _");
        return shell;
    }

    private void fillContentData() {
        Enumeration typeValues = MessageTypeEnum.enumerate();
        int i = 0;
        while (typeValues.hasMoreElements()) {
            MessageTypeEnum mte = (MessageTypeEnum)typeValues.nextElement();
            this.m_MessageTypeCombo.add(mte.toString());
            ++i;
        }
        Integer i2 = new Integer(0);
        if (!this.m_IsNew) {
            this.m_NameTextBox.setText((String)this.m_Label.getData(IMessageStrings.NAME));
            this.m_MessageTextBox.setText((String)this.m_Label.getData(IMessageStrings.STRING));
            i2 = (Integer)this.m_Label.getData(IMessageStrings.TYPE);
        }
        this.m_MessageTypeCombo.select(i2.intValue());
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    protected void okPressed() {
        if (this.m_IsNew) {
            this.m_Label.setData(IMessageStrings.NAME, this.m_NameTextBox.getText());
        }
        this.m_Label.setData(IMessageStrings.STRING, this.m_MessageTextBox.getText());
        this.m_Label.setData(IMessageStrings.TYPE, new Integer(this.m_MessageTypeCombo.indexOf(this.m_MessageTypeCombo.getText())));
        this.m_ErrorMessageTextBox.setText("");
        String err = this.validate();
        if (err.compareTo("") == 0) {
            this.m_Label.save();
            this.m_Label.getParent().raiseModelChangedEvent();
            super.okPressed();
        } else {
            this.m_ErrorMessageTextBox.setText(err);
        }
    }

    private String validate() {
        String err = this.m_Label.validate(this.m_IsNew);
        return err;
    }

    public void setMessagePool(MessagePool messagePool) {
        this.m_messagePool = messagePool;
    }
}

