/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.util;

import java.util.Date;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageInfo {
    public static int BAD_STATISTIC = 0;
    public static int GOOD_STATISTIC = 1;
    private Image img;
    private boolean checkedIn = true;
    private int timesCheckedOut = 0;
    private Date checkinTime = new Date();
    private Dimension iSize;
    private Object source;

    public ImageInfo(Dimension d) {
        this(d.width, d.height);
    }

    public ImageInfo(int width, int height) {
        this.img = new Image((Device)Display.getDefault(), width, height);
        this.iSize = new Dimension(width, height);
    }

    private double calculateStatistic() {
        double step1 = this.timesCheckedOut * 3;
        step1 = step1 > 45.0 ? 45.0 : step1;
        double step2 = (double)this.timeSinceLastUse() * 3.0 / 16.0;
        step2 = 45.0 - step2;
        step2 = step2 < 0.0 ? 0.0 : step2;
        double step3 = (double)(this.iSize.width * this.iSize.height) * 15.0 / 1310720.0;
        step3 = 15.0 - step3;
        step3 = step3 < 0.0 ? 0.0 : step3;
        return (step1 + step2 + step3) / 100.0;
    }

    public boolean checkin(Image i) {
        if (i != this.img) {
            return false;
        }
        this.checkinTime = new Date();
        this.checkedIn = true;
        return true;
    }

    public Image checkout(Dimension d, Object holder) {
        if (!this.checkedIn || !ImageInfo.fits(d, this.img)) {
            return null;
        }
        ++this.timesCheckedOut;
        this.checkedIn = false;
        this.source = holder;
        return this.img;
    }

    public void dispose() {
        this.img.dispose();
    }

    public static boolean fits(Dimension d, Image i) {
        Dimension imageSize = new Dimension(i.getBounds().width, i.getBounds().height);
        if (imageSize.equals(d)) {
            return true;
        }
        return imageSize.greaterThan(d) && imageSize.getArea() < d.getArea() * 3;
    }

    public int getStatistic() {
        if (!this.checkedIn) {
            return GOOD_STATISTIC;
        }
        return this.calculateStatistic() < 0.46 ? BAD_STATISTIC : GOOD_STATISTIC;
    }

    public boolean isCheckedIn() {
        return this.checkedIn;
    }

    public boolean merge(ImageInfo info) {
        if (this.isCheckedIn() && info.isCheckedIn() && info.iSize.equals(this.iSize) && info != this) {
            this.timesCheckedOut += info.timesCheckedOut;
            this.source = info.source;
            this.checkinTime = this.checkinTime.before(info.checkinTime) ? info.checkinTime : this.checkinTime;
            info.dispose();
            return true;
        }
        return false;
    }

    public long timeSinceLastUse() {
        if (!this.checkedIn) {
            return 0L;
        }
        return (new Date().getTime() - this.checkinTime.getTime()) / 1000L;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "\n\tImage Checked In: " + this.checkedIn + "\n\tImage Bounds: " + this.img.getBounds() + "\n\tNumber of times checked out: " + this.timesCheckedOut + "\n\tTime since last use: " + this.timeSinceLastUse() + " seconds\n\tStatistic: " + this.calculateStatistic() + "\n\tChecked out by: " + this.source;
    }
}

