/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.util.ImageInfo;
import org.eclipse.swt.graphics.Image;

public class ImageCache {
    private static List checkedOut = new ArrayList();
    private static List checkedIn = new ArrayList();
    private static int totalNumberOfImagesCreated = 0;
    private static int numberOfImagesDisposed = 0;

    public static boolean checkin(Image img) {
        if (img == null) {
            return false;
        }
        int i = 0;
        while (i < checkedOut.size()) {
            ImageInfo info = (ImageInfo)checkedOut.get(i);
            if (info.checkin(img)) {
                checkedOut.remove(info);
                checkedIn.add(info);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Image checkinCheckout(Image i, Dimension d, Object o) {
        if (i != null && ImageInfo.fits(d, i)) {
            return i;
        }
        ImageCache.checkin(i);
        return ImageCache.checkout(d, o);
    }

    public static Image checkout(Dimension d, Object o) {
        Image result = null;
        int i = 0;
        while (i < checkedIn.size()) {
            ImageInfo info = (ImageInfo)checkedIn.get(i);
            result = info.checkout(d, o);
            if (result != null) {
                checkedIn.remove(info);
                checkedOut.add(info);
                return result;
            }
            if (info.getStatistic() == ImageInfo.BAD_STATISTIC) {
                checkedIn.remove(info);
                info.dispose();
                ++numberOfImagesDisposed;
                --i;
            }
            ++i;
        }
        Dimension newD = d.getExpanded((int)((double)d.width * 0.15), (int)((double)d.height * 0.15));
        ++totalNumberOfImagesCreated;
        try {
            ImageInfo newInfo = new ImageInfo(newD);
            checkedOut.add(newInfo);
            return newInfo.checkout(newD, o);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void printContents() {
        System.out.println("Checked in List: \n");
        int i = 0;
        while (i < checkedIn.size()) {
            System.out.println(String.valueOf(i) + ": " + checkedIn.get(i));
            ++i;
        }
        System.out.println("*************************************************\n");
        System.out.println("Checked out list: \n");
        i = 0;
        while (i < checkedOut.size()) {
            System.out.println(String.valueOf(i) + ": " + checkedOut.get(i));
            ++i;
        }
        System.out.println("=================================================");
        System.out.println("=================================================\n");
    }
}

