/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.parts;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.parts.ThumbnailUpdateManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class Thumbnail
extends Figure {
    private IFigure sourceFigure;
    private boolean isDirty;
    private float scaleX;
    private float scaleY;
    private Dimension targetSize = new Dimension(0, 0);
    private Image thumbnailImage;
    private Dimension thumbnailImageSize;
    private ThumbnailUpdater updater = new ThumbnailUpdater();

    public Thumbnail() {
    }

    public Thumbnail(IFigure fig) {
        this();
        this.setSource(fig);
    }

    private Dimension adjustToAspectRatio(Dimension size, boolean adjustToMaxDimension) {
        int height;
        int width;
        Dimension sourceSize = this.sourceFigure.getSize();
        Dimension borderSize = new Dimension(this.getInsets().getWidth(), this.getInsets().getHeight());
        size.expand(borderSize.getNegated());
        if (adjustToMaxDimension) {
            width = Math.max(size.width, (int)((double)((float)(size.height * sourceSize.width) / (float)sourceSize.height) + 0.5));
            height = Math.max(size.height, (int)((double)((float)(size.width * sourceSize.height) / (float)sourceSize.width) + 0.5));
        } else {
            width = Math.min(size.width, (int)((double)((float)(size.height * sourceSize.width) / (float)sourceSize.height) + 0.5));
            height = Math.min(size.height, (int)((double)((float)(size.width * sourceSize.height) / (float)sourceSize.width) + 0.5));
        }
        size.width = width;
        size.height = height;
        return size.expand(borderSize);
    }

    public void deactivate() {
        this.updater.deactivate();
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            return this.adjustToAspectRatio(this.getBounds().getSize(), false);
        }
        Dimension preferredSize = this.adjustToAspectRatio(this.prefSize.getCopy(), true);
        if (this.maxSize == null) {
            return preferredSize;
        }
        Dimension maximumSize = this.adjustToAspectRatio(this.maxSize.getCopy(), true);
        if (preferredSize.greaterThan(maximumSize)) {
            return maximumSize;
        }
        return preferredSize;
    }

    protected float getScaleX() {
        return this.scaleX;
    }

    protected float getScaleY() {
        return this.scaleY;
    }

    protected Image getThumbnailImage() {
        Dimension oldSize = this.targetSize;
        this.targetSize = this.getPreferredSize();
        this.targetSize.expand(new Dimension(this.getInsets().getWidth(), this.getInsets().getHeight()).negate());
        if (this.isDirty() && !this.updater.isRunning()) {
            this.updater.start();
        } else if (oldSize != null && !this.targetSize.equals(oldSize)) {
            this.revalidate();
            this.updater.restart();
        }
        return this.thumbnailImage;
    }

    protected boolean isDirty() {
        return this.isDirty;
    }

    protected void paintFigure(Graphics graphics) {
        Image thumbnail = this.getThumbnailImage();
        if (thumbnail == null) {
            return;
        }
        graphics.drawImage(thumbnail, this.getClientArea().getLocation());
    }

    public void setDirty(boolean value) {
        this.isDirty = value;
    }

    protected void setScales(float x, float y) {
        this.scaleX = x;
        this.scaleY = y;
    }

    public void setSource(IFigure fig) {
        this.sourceFigure = fig;
        this.setScales((float)this.getSize().width / (float)this.sourceFigure.getSize().width, (float)this.getSize().height / (float)this.sourceFigure.getSize().height);
        new ThumbnailUpdateManager(this.sourceFigure, this);
        this.sourceFigure.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure fig) {
                Thumbnail.this.setDirty(true);
                Thumbnail.this.revalidate();
            }
        });
    }

    class ThumbnailUpdater
    implements Runnable {
        protected int MAX_BUFFER_SIZE = 256;
        private boolean isRunning = false;
        private boolean isActive = true;
        private int hTiles;
        private int vTiles;
        private Dimension tileSize;
        private Image sourceBuffer;
        private Dimension sourceBufferSize;
        private GC sourceGC;
        private GC thumbnailGC;
        private Graphics sourceGraphics;
        private int currentHTile;
        private int currentVTile;

        ThumbnailUpdater() {
        }

        public void deactivate() {
            this.setActive(false);
            this.stop();
            if (Thumbnail.this.thumbnailImage != null) {
                Thumbnail.this.thumbnailImage.dispose();
                Thumbnail.this.thumbnailImage = null;
                Thumbnail.this.thumbnailImageSize = null;
            }
        }

        protected int getCurrentHTile() {
            return this.currentHTile;
        }

        protected int getCurrentVTile() {
            return this.currentVTile;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public void resetTileValues() {
            this.hTiles = (int)Math.ceil((float)((Thumbnail)Thumbnail.this).sourceFigure.getSize().width / (float)this.MAX_BUFFER_SIZE);
            this.vTiles = (int)Math.ceil((float)((Thumbnail)Thumbnail.this).sourceFigure.getSize().height / (float)this.MAX_BUFFER_SIZE);
            this.tileSize = new Dimension((int)Math.ceil((float)((Thumbnail)Thumbnail.this).sourceFigure.getSize().width / (float)this.hTiles), (int)Math.ceil((float)((Thumbnail)Thumbnail.this).sourceFigure.getSize().height / (float)this.vTiles));
            this.currentHTile = 0;
            this.currentVTile = 0;
        }

        public void restart() {
            this.stop();
            this.start();
        }

        public void run() {
            if (!this.isActive()) {
                return;
            }
            int v = this.getCurrentVTile();
            int sy1 = v * this.tileSize.height;
            int sy2 = Math.min((v + 1) * this.tileSize.height, ((Thumbnail)Thumbnail.this).sourceFigure.getSize().height);
            int ty1 = Math.round((float)sy1 * Thumbnail.this.getScaleY());
            int ty2 = Math.min(Math.round((float)sy2 * Thumbnail.this.getScaleY()), ((Thumbnail)Thumbnail.this).targetSize.height);
            int h = this.getCurrentHTile();
            int sx1 = h * this.tileSize.width;
            int sx2 = Math.min((h + 1) * this.tileSize.width, ((Thumbnail)Thumbnail.this).sourceFigure.getSize().width);
            int tx1 = Math.round((float)sx1 * Thumbnail.this.getScaleX());
            int tx2 = Math.min(Math.round((float)sx2 * Thumbnail.this.getScaleX()), ((Thumbnail)Thumbnail.this).targetSize.width);
            Point p = Thumbnail.this.sourceFigure.getBounds().getLocation();
            Rectangle rect = new Rectangle(sx1 + p.x, sy1 + p.y, sx2 - sx1, sy2 - sy1);
            this.sourceGraphics.pushState();
            this.sourceGraphics.translate(-sx1 - p.x, -sy1 - p.y);
            this.sourceGraphics.setClip(rect);
            this.sourceGraphics.fillRectangle(rect);
            Thumbnail.this.sourceFigure.paint(this.sourceGraphics);
            if (tx2 - tx1 > 0 && ty2 - ty1 > 0) {
                this.thumbnailGC.drawImage(this.sourceBuffer, 0, 0, sx2 - sx1, sy2 - sy1, tx1, ty1, tx2 - tx1, ty2 - ty1);
            }
            this.sourceGraphics.popState();
            Thumbnail.this.repaint();
            if (this.getCurrentHTile() < this.hTiles - 1) {
                this.setCurrentHTile(this.getCurrentHTile() + 1);
            } else {
                this.setCurrentHTile(0);
                if (this.getCurrentVTile() < this.vTiles - 1) {
                    this.setCurrentVTile(this.getCurrentVTile() + 1);
                } else {
                    this.setCurrentVTile(0);
                }
            }
            if (this.getCurrentHTile() != 0 || this.getCurrentVTile() != 0) {
                Display.getCurrent().timerExec(10, (Runnable)this);
            } else if (Thumbnail.this.isDirty()) {
                Thumbnail.this.setDirty(false);
                Display.getCurrent().timerExec(10, (Runnable)this);
            } else {
                this.stop();
            }
        }

        public void setActive(boolean value) {
            this.isActive = value;
        }

        protected void setCurrentHTile(int count) {
            this.currentHTile = count;
        }

        protected void setCurrentVTile(int count) {
            this.currentVTile = count;
        }

        public void start() {
            if (!this.isActive()) {
                return;
            }
            this.isRunning = true;
            Thumbnail.this.setDirty(false);
            this.resetTileValues();
            if (!this.tileSize.equals(this.sourceBufferSize)) {
                if (this.sourceBuffer != null) {
                    this.sourceBuffer.dispose();
                }
                this.sourceBuffer = new Image((Device)Display.getDefault(), this.tileSize.width, this.tileSize.height);
                this.sourceBufferSize = new Dimension(this.tileSize);
            }
            this.sourceGC = new GC((Drawable)this.sourceBuffer);
            this.sourceGraphics = new SWTGraphics(this.sourceGC);
            Color color = Thumbnail.this.sourceFigure.getForegroundColor();
            if (color != null) {
                this.sourceGraphics.setForegroundColor(color);
            }
            if ((color = Thumbnail.this.sourceFigure.getBackgroundColor()) != null) {
                this.sourceGraphics.setBackgroundColor(color);
            }
            this.sourceGraphics.setFont(Thumbnail.this.sourceFigure.getFont());
            Thumbnail.this.setScales((float)((Thumbnail)Thumbnail.this).targetSize.width / (float)((Thumbnail)Thumbnail.this).sourceFigure.getSize().width, (float)((Thumbnail)Thumbnail.this).targetSize.height / (float)((Thumbnail)Thumbnail.this).sourceFigure.getSize().height);
            if (!Thumbnail.this.targetSize.equals(Thumbnail.this.thumbnailImageSize)) {
                if (Thumbnail.this.thumbnailImage != null) {
                    Thumbnail.this.thumbnailImage.dispose();
                }
                Thumbnail.this.thumbnailImage = new Image((Device)Display.getDefault(), ((Thumbnail)Thumbnail.this).targetSize.width, ((Thumbnail)Thumbnail.this).targetSize.height);
                Thumbnail.this.thumbnailImageSize = new Dimension(Thumbnail.this.targetSize);
            }
            this.thumbnailGC = new GC((Drawable)Thumbnail.this.thumbnailImage);
            Display.getCurrent().asyncExec((Runnable)this);
        }

        public void stop() {
            if (this.sourceGC != null) {
                this.sourceGC.dispose();
                this.sourceGC = null;
            }
            if (this.thumbnailGC != null) {
                this.thumbnailGC.dispose();
                this.thumbnailGC = null;
            }
            this.sourceGraphics = null;
            if (this.sourceBuffer != null) {
                this.sourceBuffer.dispose();
                this.sourceBuffer = null;
            }
            this.sourceBufferSize = null;
            this.isRunning = false;
        }
    }
}

