/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class ScrollableThumbnail
extends Thumbnail {
    private SelectorFigure selector;
    private Viewport viewport;
    private ScrollBar hBar;
    private ScrollBar vBar;
    private ScrollSynchronizer syncher;

    public ScrollableThumbnail() {
        this.initialize();
    }

    public ScrollableThumbnail(Viewport port) {
        this.setViewport(port);
        this.initialize();
    }

    private void initialize() {
        this.selector = new SelectorFigure();
        this.syncher = new ScrollSynchronizer();
        this.selector.addMouseListener(this.syncher);
        this.selector.addMouseMotionListener(this.syncher);
        this.add(this.selector);
        ClickScrollerAndDragTransferrer transferrer = new ClickScrollerAndDragTransferrer();
        this.addMouseListener(transferrer);
        this.addMouseMotionListener(transferrer);
    }

    private void reconfigureSelectorBounds() {
        Rectangle rect = new Rectangle();
        rect.setLocation(this.viewport.getViewLocation());
        rect.setSize(this.viewport.getSize());
        rect.scale(this.getScaleX(), this.getScaleY());
        rect.translate(this.getClientArea().getLocation());
        this.selector.setBounds(rect);
    }

    protected void setScales(float scaleX, float scaleY) {
        if (scaleX == this.getScaleX() && scaleY == this.getScaleY()) {
            return;
        }
        super.setScales(scaleX, scaleY);
        this.reconfigureSelectorBounds();
    }

    public void setViewport(Viewport port) {
        port.addPropertyChangeListener(Viewport.PROPERTY_VIEW_LOCATION, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ScrollableThumbnail.this.reconfigureSelectorBounds();
            }
        });
        port.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure fig) {
                ScrollableThumbnail.this.reconfigureSelectorBounds();
            }
        });
        this.viewport = port;
    }

    private class ScrollSynchronizer
    extends MouseMotionListener.Stub
    implements MouseListener {
        private Point startLocation;
        private Point viewLocation;

        ScrollSynchronizer() {
        }

        public void mouseDragged(MouseEvent me) {
            Dimension d = me.getLocation().getDifference(this.startLocation);
            d.scale(1.0f / ScrollableThumbnail.this.getScaleX(), 1.0f / ScrollableThumbnail.this.getScaleY());
            ScrollableThumbnail.this.viewport.setViewLocation(this.viewLocation.getTranslated(d));
            me.consume();
        }

        public void mousePressed(MouseEvent me) {
            this.startLocation = me.getLocation();
            this.viewLocation = ScrollableThumbnail.this.viewport.getViewLocation();
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    }

    private class ClickScrollerAndDragTransferrer
    extends MouseMotionListener.Stub
    implements MouseListener {
        private boolean dragTransfer;

        ClickScrollerAndDragTransferrer() {
        }

        public void mouseDragged(MouseEvent me) {
            if (this.dragTransfer) {
                ScrollableThumbnail.this.syncher.mouseDragged(me);
            }
        }

        public void mousePressed(MouseEvent me) {
            if (!ScrollableThumbnail.this.getClientArea().contains(me.getLocation())) {
                return;
            }
            Dimension selectorCenter = ScrollableThumbnail.this.selector.getBounds().getSize().scale(0.5f);
            Point scrollPoint = me.getLocation().getTranslated(ScrollableThumbnail.this.getLocation().getNegated()).translate(selectorCenter.negate()).scale(1.0f / ScrollableThumbnail.this.getScaleX(), 1.0f / ScrollableThumbnail.this.getScaleY());
            ScrollableThumbnail.this.viewport.setViewLocation(scrollPoint);
            ScrollableThumbnail.this.syncher.mousePressed(me);
            this.dragTransfer = true;
        }

        public void mouseReleased(MouseEvent me) {
            ScrollableThumbnail.this.syncher.mouseReleased(me);
            this.dragTransfer = false;
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    }

    private class SelectorFigure
    extends Figure {
        private Image image;
        private Rectangle iBounds = new Rectangle(0, 0, 1, 1);

        SelectorFigure() {
            Display display = Display.getDefault();
            PaletteData pData = new PaletteData(255, 65280, 0xFF0000);
            RGB rgb = new RGB(255, 157, 20);
            int fillColor = pData.getPixel(rgb);
            ImageData iData = new ImageData(1, 1, 24, pData);
            iData.setPixel(0, 0, fillColor);
            iData.setAlpha(0, 0, 40);
            this.image = new Image((Device)display, iData);
        }

        protected void finalize() {
            this.image.dispose();
        }

        public void paintFigure(Graphics g) {
            Rectangle bounds = this.getBounds();
            if (bounds.width < 5 || bounds.height < 5) {
                return;
            }
            Dimension thumbnailSize = ScrollableThumbnail.this.getClientArea().getSize();
            Dimension size = this.getSize().getExpanded(1, 1);
            if (size.greaterThan(thumbnailSize) || size.equals(thumbnailSize)) {
                return;
            }
            --bounds.height;
            --bounds.width;
            g.drawImage(this.image, this.iBounds, bounds);
            ++bounds.height;
            ++bounds.width;
            g.drawImage(this.image, this.iBounds.x, this.iBounds.y, this.iBounds.width, this.iBounds.height, bounds.x, bounds.y, bounds.width - 2, 1);
            g.drawImage(this.image, this.iBounds.x, this.iBounds.y, this.iBounds.width, this.iBounds.height, bounds.x, bounds.y + 1, 1, bounds.height - 2);
            g.setForegroundColor(ColorConstants.gray);
            g.drawLine(bounds.x + 2, bounds.bottom() - 1, bounds.right() - 1, bounds.bottom() - 1);
            g.drawLine(bounds.right() - 1, bounds.y + 2, bounds.right() - 1, bounds.bottom() - 1);
        }
    }
}

