/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.parts;

import java.util.List;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.AbstractLabeledBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.parts.AnimationModel;
import org.eclipse.draw2d.parts.TabBorder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class Dock
extends Figure {
    private IFigure host;
    private IFigure contents;
    private IFigure resizeFigure;
    private AnimationModel animation;
    private Dimension oldSize;
    private Border contentBorder = new CompoundBorder(new AbstractBorder(){

        public Insets getInsets(IFigure fig) {
            return new Insets(1, 1, 0, 0);
        }

        public void paint(IFigure fig, Graphics g, Insets insets) {
            Rectangle rect = AbstractBorder.getPaintRectangle(fig, insets);
            g.setForegroundColor(ColorConstants.button);
            g.drawLine(rect.x + 2, rect.y, rect.right() - 1, rect.y);
            g.drawLine(rect.x, rect.y + 2, rect.x, rect.bottom() - 1);
            g.drawLine(rect.x + 1, rect.y + 1, rect.x + 1, rect.y + 1);
        }

        public boolean isOpaque() {
            return false;
        }
    }, new SchemeBorder(new SchemeBorder.Scheme(new Color[]{ColorConstants.buttonLightest, ColorConstants.button, ColorConstants.buttonDarker}, new Color[]{ColorConstants.buttonDarkest, ColorConstants.button, ColorConstants.buttonLightest, ColorConstants.button})));
    boolean isCollapsing;

    public Dock() {
        this.resizeFigure = new ResizeFigure();
        this.setLayoutManager(new StackLayout());
        this.setBorder(new TabBorder());
        this.setTitle("");
        this.setRequestFocusEnabled(true);
        this.addMouseListener(new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                Dock.this.requestFocus();
                if (Dock.this.contents.getParent() == Dock.this) {
                    Dock.this.minimizeDockIfMaximized();
                } else {
                    Dock.this.maximizeDockIfMinimized();
                }
                me.consume();
            }
        });
        this.addFocusListener(new FocusListener.Stub(){

            public void focusLost(FocusEvent fe) {
                Dock.this.minimizeDockIfMaximized();
            }
        });
    }

    public Dock(IFigure port, IFigure overview) {
        this();
        this.setHost(port);
        this.setContents(overview);
    }

    void animate() {
        if (this.animation != null) {
            return;
        }
        this.animation = new AnimationModel(250L);
        this.animation.start();
        new Thread(new Runnable(){

            public void run() {
                boolean loop;
                do {
                    float value;
                    loop = (double)(value = Dock.this.animation.getValue()) < 1.0;
                    Display.getDefault().syncExec(new Runnable(this){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            4.access$0(this.this$1).revalidate();
                        }
                    });
                    if (loop) continue;
                    Dock.this.animation = null;
                } while (loop);
                Dock.this.oldSize = null;
                if (Dock.this.isCollapsing) {
                    Display.getDefault().syncExec(new Runnable(this){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            4.access$0(this.this$1).remove(Dock.access$0(4.access$0(this.this$1)));
                            4.access$0(this.this$1).remove(Dock.access$4(4.access$0(this.this$1)));
                        }
                    });
                    Dock.this.isCollapsing = false;
                }
            }

            static /* synthetic */ Dock access$0(4 var0) {
                return var0.Dock.this;
            }
        }).start();
    }

    Dimension calculatePreferredSize() {
        Dimension result = new Dimension();
        List children = this.getChildren();
        if (!this.isCollapsing) {
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                result.union(child.getPreferredSize());
                ++i;
            }
        }
        Dimension borderSize = ((AbstractLabeledBorder)this.getBorder()).getPreferredSize(this);
        result.width = Math.max(result.width, borderSize.width);
        result.expand(0, borderSize.height);
        return result;
    }

    public boolean containsPoint(int x, int y) {
        return ((TabBorder)this.getBorder()).containsPoint(x, y) || this.getClientArea().contains(x, y);
    }

    public IFigure findMouseEventTargetAt(int x, int y) {
        if (((TabBorder)this.getBorder()).containsPoint(x, y)) {
            return this;
        }
        return super.findMouseEventTargetAt(x, y);
    }

    public IFigure getHost() {
        return this.host;
    }

    public Dimension getPreferredSize() {
        if (this.animation == null) {
            return this.calculatePreferredSize();
        }
        float value = this.animation.getValue();
        Dimension size = new Dimension(this.calculatePreferredSize());
        size.width = Math.max(size.width, this.oldSize.width);
        size.height = (int)((float)size.height * value);
        size.height = (int)((float)size.height + (float)this.oldSize.height * (1.0f - value));
        return size;
    }

    void maximizeDockIfMinimized() {
        if (this.contents.getParent() != this) {
            this.oldSize = this.getPreferredSize();
            this.setCursor(Cursors.APPSTARTING);
            this.add(this.contents);
            this.add(this.resizeFigure);
            Image image = new Image((Device)Display.getDefault(), this.getSize().width, this.getSize().height);
            GC gc = new GC((Drawable)image);
            this.contents.paint(new SWTGraphics(gc));
            gc.dispose();
            image.dispose();
            this.setCursor(Cursors.ARROW);
            this.animate();
        }
    }

    void minimizeDockIfMaximized() {
        if (this.contents.getParent() == this) {
            this.oldSize = this.getPreferredSize();
            this.isCollapsing = true;
            this.animate();
        }
    }

    public void setContents(IFigure fig) {
        this.contents = fig;
        this.contents.setBorder(this.contentBorder);
        this.contents.setPreferredSize(new Dimension(150, 150));
        if (this.getHost() != null) {
            this.contents.setMaximumSize(this.getHost().getSize().getScaled(0.5f));
        }
    }

    public void setTitle(String title) {
        ((AbstractLabeledBorder)this.getBorder()).setLabel(title);
    }

    public void setHost(IFigure port) {
        this.host = port;
        if (this.contents != null) {
            this.contents.setMaximumSize(this.host.getSize().getScaled(0.5f));
        }
        port.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure ignored) {
                Dock.this.contents.setMaximumSize(Dock.this.getHost().getSize().getScaled(0.5f));
                Dock.this.revalidate();
            }
        });
    }

    static /* synthetic */ IFigure access$4(Dock dock) {
        return dock.resizeFigure;
    }

    private class ResizeFigure
    extends Figure {
        private Color[] scheme = new Color[]{ColorConstants.buttonDarker, ColorConstants.buttonDarker, ColorConstants.buttonLightest, ColorConstants.button};
        private int squareSize = 16;

        public ResizeFigure() {
            ResizeListener listener = new ResizeListener();
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
            this.setCursor(Cursors.SIZENW);
        }

        public boolean containsPoint(int x, int y) {
            if (!super.containsPoint(x, y)) {
                return false;
            }
            Point p = this.getLocation();
            p.negate().translate(x, y);
            return p.x + p.y <= this.squareSize;
        }

        public Dimension getPreferredSize() {
            return new Dimension();
        }

        public void paintFigure(Graphics g) {
            Rectangle resizeIcon = new Rectangle();
            int offset = Math.min(((Dock)Dock.this).contents.getInsets().left - 1, ((Dock)Dock.this).contents.getInsets().top - 1);
            resizeIcon.setLocation(this.getLocation().getTranslated(offset, offset));
            resizeIcon.setSize(new Dimension(this.squareSize - (offset *= 2), this.squareSize - offset));
            Point p1 = resizeIcon.getTopRight();
            Point p2 = resizeIcon.getBottomLeft();
            g.setLineStyle(1);
            int count = 0;
            while (count <= resizeIcon.width) {
                g.setForegroundColor(this.scheme[count % this.scheme.length]);
                g.drawLine(p1, p2);
                --p1.x;
                --p2.y;
                ++count;
            }
            g.setForegroundColor(ColorConstants.button);
            Point hack = this.getLocation().getTranslated(1, 1);
            g.drawLine(hack, hack);
        }

        private class ResizeListener
        extends MouseMotionListener.Stub
        implements MouseListener {
            Point startLocation;
            Dimension originalSize;

            ResizeListener() {
            }

            public void mouseDragged(MouseEvent me) {
                Dimension newSize = this.originalSize.getExpanded(me.getLocation().getDifference(this.startLocation).getNegated());
                newSize.width = Math.max(newSize.width, ((TabBorder)((ResizeFigure)ResizeFigure.this).Dock.this.getBorder()).getPreferredSize((IFigure)((ResizeFigure)ResizeFigure.this).Dock.this).width);
                Dock.this.contents.setPreferredSize(newSize);
                me.consume();
            }

            public void mousePressed(MouseEvent me) {
                this.startLocation = me.getLocation();
                this.originalSize = Dock.this.contents.getSize().getCopy();
                me.consume();
            }

            public void mouseReleased(MouseEvent me) {
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        }
    }
}

