/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import java.io.Serializable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.internal.Draw2dMessages;

public class PointList
implements Serializable {
    private int[] points = new int[0];
    private Rectangle bounds;
    private int size = 0;
    static final long serialVersionUID = 1L;

    public PointList() {
    }

    public PointList(int size) {
        this.points = new int[size * 2];
    }

    public void addPoint(Point p) {
        this.addPoint(p.x, p.y);
    }

    public void addPoint(int x, int y) {
        this.bounds = null;
        int arrayLength = this.points.length;
        int usedLength = this.size * 2;
        if (arrayLength == usedLength) {
            int[] old = this.points;
            this.points = new int[arrayLength + 2];
            System.arraycopy(old, 0, this.points, 0, arrayLength);
        }
        this.points[usedLength] = x;
        this.points[usedLength + 1] = y;
        ++this.size;
    }

    public Rectangle getBounds() {
        if (this.bounds != null) {
            return this.bounds;
        }
        this.bounds = new Rectangle();
        if (this.size > 0) {
            this.bounds.setLocation(this.getPoint(0));
            int i = 0;
            while (i < this.size) {
                this.bounds.union(this.getPoint(i));
                ++i;
            }
        }
        return this.bounds;
    }

    public Point getFirstPoint() {
        if (this.size < 1) {
            return null;
        }
        return this.getPoint(0);
    }

    public Point getLastPoint() {
        if (this.size < 1) {
            return null;
        }
        return this.getPoint(this.size - 1);
    }

    public Point getMidpoint() {
        if (this.size() % 2 == 0) {
            return this.getPoint(this.size() / 2 - 1).getTranslated(this.getPoint(this.size() / 2)).scale(0.5f);
        }
        return this.getPoint(this.size() / 2);
    }

    public Point getPoint(int index) {
        return new Point(this.points[index *= 2], this.points[index + 1]);
    }

    public Point getPoint(Point p, int index) {
        p.x = this.points[index *= 2];
        p.y = this.points[index + 1];
        return p;
    }

    public void insertPoint(Point p, int index) {
        this.bounds = null;
        if ((index *= 2) > this.points.length || index < 0) {
            throw new IndexOutOfBoundsException(Draw2dMessages.ERR_PointList_InsertPoint_Exception_IndexOutOfBounds);
        }
        int length = this.points.length;
        int[] old = this.points;
        this.points = new int[length + 2];
        System.arraycopy(old, 0, this.points, 0, index);
        System.arraycopy(old, index, this.points, index + 2, length - index);
        this.points[index] = p.x;
        this.points[index + 1] = p.y;
        ++this.size;
    }

    public void removeAllPoints() {
        this.bounds = null;
        this.size = 0;
    }

    public Point removePoint(int index) {
        this.bounds = null;
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(Draw2dMessages.ERR_PointList_RemovePoint_Exception_IndexOutOfBounds);
        }
        Point pt = new Point(this.points[index *= 2], this.points[index + 1]);
        if (index != this.size * 2 - 2) {
            System.arraycopy(this.points, index + 2, this.points, index, this.size * 2 - index - 2);
        }
        --this.size;
        return pt;
    }

    public void setPoint(Point pt, int index) {
        this.removePoint(index);
        this.insertPoint(pt, index);
    }

    public int size() {
        return this.size;
    }

    public int[] toIntArray() {
        if (this.points.length != this.size * 2) {
            int[] old = this.points;
            this.points = new int[this.size * 2];
            System.arraycopy(old, 0, this.points, 0, this.size * 2);
        }
        return this.points;
    }

    public void translate(Point pt) {
        this.translate(pt.x, pt.y);
    }

    public void translate(int x, int y) {
        if (this.bounds != null) {
            this.bounds.translate(x, y);
        }
        int i = 0;
        while (i < this.size * 2) {
            int n = i;
            this.points[n] = this.points[n] + x;
            int n2 = i + 1;
            this.points[n2] = this.points[n2] + y;
            i += 2;
        }
    }
}

