/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class StackLayout
extends AbstractLayout {
    protected Dimension calculatePreferredSize(IFigure figure) {
        Dimension d = new Dimension();
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            d.union(child.getPreferredSize());
            ++i;
        }
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        d.union(this.getBorderPreferredSize(figure));
        return d;
    }

    public Dimension getMinimumSize(IFigure figure) {
        Dimension d = new Dimension();
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            d.union(child.getMinimumSize());
            ++i;
        }
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        return d;
    }

    public Dimension getPreferredSize(IFigure figure) {
        return this.calculatePreferredSize(figure);
    }

    public void layout(IFigure figure) {
        Rectangle r = figure.getClientArea();
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            child.setBounds(r);
            ++i;
        }
    }
}

