/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class ScrollPaneLayout
extends AbstractLayout {
    private Dimension minimumSize;
    protected static final int NEVER = 0;
    protected static final int AUTO = 1;
    protected static final int ALWAYS = 2;

    public Dimension calculateMinimumSize(IFigure figure) {
        ScrollPane scrollpane = (ScrollPane)figure;
        Insets insets = scrollpane.getInsets();
        Dimension d = scrollpane.getViewport().getMinimumSize();
        return d.getExpanded(insets.getWidth(), insets.getHeight());
    }

    protected Dimension calculatePreferredSize(IFigure container) {
        ScrollPane scrollpane = (ScrollPane)container;
        Dimension pref = new Dimension();
        pref.width += container.getInsets().getWidth();
        pref.height += container.getInsets().getHeight();
        pref.expand(scrollpane.getViewport().getPreferredSize());
        return pref;
    }

    public Dimension getMinimumSize(IFigure container) {
        if (this.minimumSize == null) {
            this.minimumSize = this.calculateMinimumSize(container);
        }
        return this.minimumSize;
    }

    public void invalidate() {
        this.minimumSize = null;
        super.invalidate();
    }

    public void layout(IFigure parent) {
        Rectangle bounds;
        boolean none;
        ScrollPane scrollpane = (ScrollPane)parent;
        Rectangle $REFclientArea = parent.getClientArea();
        ScrollBar hBar = scrollpane.getHorizontalScrollBar();
        ScrollBar vBar = scrollpane.getVerticalScrollBar();
        Viewport viewport = scrollpane.getViewport();
        Insets insets = new Insets();
        insets.bottom = hBar.getPreferredSize().height;
        insets.right = vBar.getPreferredSize().width;
        int hVis = scrollpane.getHorizontalScrollBarVisibility();
        int vVis = scrollpane.getVerticalScrollBarVisibility();
        Dimension preferred = viewport.getPreferredSize().getCopy();
        Dimension available = $REFclientArea.getSize();
        Dimension guaranteed = new Dimension(available).shrink(vVis == 0 ? 0 : insets.right, hVis == 0 ? 0 : insets.bottom);
        Dimension viewportMinSize = viewport.getMinimumSize();
        if (viewport.getContentsTracksHeight()) {
            preferred.height = viewportMinSize.height;
        }
        if (viewport.getContentsTracksWidth()) {
            preferred.width = viewportMinSize.width;
        }
        boolean both = !(none = available.contains(preferred)) && preferred.containsProper(guaranteed);
        boolean showV = both || preferred.height > available.height;
        boolean showH = both || preferred.width > available.width;
        showV = vVis != 0 && (showV || vVis == 2);
        boolean bl = showH = hVis != 0 && (showH || hVis == 2);
        if (!showV) {
            insets.right = 0;
        }
        if (!showH) {
            insets.bottom = 0;
        }
        Rectangle viewportArea = $REFclientArea.getCropped(insets);
        if (showV) {
            bounds = new Rectangle(viewportArea.right(), viewportArea.y, insets.right, viewportArea.height);
            vBar.setBounds(bounds);
        }
        if (showH) {
            bounds = new Rectangle(viewportArea.x, viewportArea.bottom(), viewportArea.width, insets.bottom);
            hBar.setBounds(bounds);
        }
        vBar.setVisible(showV);
        hBar.setVisible(showH);
        viewport.setBounds(viewportArea);
    }
}

