/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;

public final class ManhattanConnectionRouter
extends AbstractRouter {
    private Map rowsUsed = new HashMap();
    private Map colsUsed = new HashMap();
    private Map reservedInfo = new HashMap();
    private static Ray UP = new Ray(0, -1);
    private static Ray DOWN = new Ray(0, 1);
    private static Ray LEFT = new Ray(-1, 0);
    private static Ray RIGHT = new Ray(1, 0);

    public void invalidate(Connection connection) {
        this.removeReservedLines(connection);
    }

    private int getColumnNear(Connection connection, int r, int n, int x) {
        int min = Math.min(n, x);
        int max = Math.max(n, x);
        if (min > r) {
            max = min;
            min = r - (min - r);
        }
        if (max < r) {
            min = max;
            max = r + (r - max);
        }
        int proximity = 0;
        int direction = -1;
        if (r % 2 == 1) {
            --r;
        }
        while (proximity < r) {
            Integer i = new Integer(r + proximity * direction);
            if (!this.colsUsed.containsKey(i)) {
                this.colsUsed.put(i, i);
                this.reserveColumn(connection, i);
                return i;
            }
            int j = i;
            if (j <= min) {
                return j + 2;
            }
            if (j >= max) {
                return j - 2;
            }
            if (direction == 1) {
                direction = -1;
                continue;
            }
            direction = 1;
            proximity += 2;
        }
        return r;
    }

    protected Ray getDirection(Rectangle r, Point p) {
        int distance = Math.abs(r.x - p.x);
        Ray direction = LEFT;
        int i = Math.abs(r.y - p.y);
        if (i <= distance) {
            distance = i;
            direction = UP;
        }
        if ((i = Math.abs(r.bottom() - p.y)) <= distance) {
            distance = i;
            direction = DOWN;
        }
        if ((i = Math.abs(r.right() - p.x)) < distance) {
            distance = i;
            direction = RIGHT;
        }
        return direction;
    }

    protected Ray getEndDirection(Connection conn) {
        Rectangle rect;
        ConnectionAnchor anchor = conn.getTargetAnchor();
        Point p = this.getEndPoint(conn);
        if (anchor.getOwner() == null) {
            rect = new Rectangle(p.x - 1, p.y - 1, 2, 2);
        } else {
            rect = conn.getTargetAnchor().getOwner().getBounds().getCopy();
            conn.getTargetAnchor().getOwner().translateToAbsolute(rect);
        }
        return this.getDirection(rect, p);
    }

    protected int getRowNear(Connection connection, int r, int n, int x) {
        int min = Math.min(n, x);
        int max = Math.max(n, x);
        if (min > r) {
            max = min;
            min = r - (min - r);
        }
        if (max < r) {
            min = max;
            max = r + (r - max);
        }
        int proximity = 0;
        int direction = -1;
        if (r % 2 == 1) {
            --r;
        }
        while (proximity < r) {
            Integer i = new Integer(r + proximity * direction);
            if (!this.rowsUsed.containsKey(i)) {
                this.rowsUsed.put(i, i);
                this.reserveRow(connection, i);
                return i;
            }
            int j = i;
            if (j <= min) {
                return j + 2;
            }
            if (j >= max) {
                return j - 2;
            }
            if (direction == 1) {
                direction = -1;
                continue;
            }
            direction = 1;
            proximity += 2;
        }
        return r;
    }

    protected Ray getStartDirection(Connection conn) {
        Rectangle rect;
        ConnectionAnchor anchor = conn.getSourceAnchor();
        Point p = this.getStartPoint(conn);
        if (anchor.getOwner() == null) {
            rect = new Rectangle(p.x - 1, p.y - 1, 2, 2);
        } else {
            rect = conn.getSourceAnchor().getOwner().getBounds().getCopy();
            conn.getSourceAnchor().getOwner().translateToAbsolute(rect);
        }
        return this.getDirection(rect, p);
    }

    protected void processPositions(Ray start, Ray end, List positions, boolean horizontal, Connection conn) {
        this.removeReservedLines(conn);
        int[] pos = new int[positions.size() + 2];
        pos[0] = horizontal ? start.x : start.y;
        int i = 0;
        while (i < positions.size()) {
            pos[i + 1] = (Integer)positions.get(i);
            ++i;
        }
        pos[++i] = horizontal == (positions.size() % 2 == 1) ? end.x : end.y;
        PointList points = new PointList();
        points.addPoint(new Point(start.x, start.y));
        i = 2;
        while (i < pos.length - 1) {
            Point p;
            int max;
            int min;
            boolean adjust;
            horizontal = !horizontal;
            int prev = pos[i - 1];
            int current = pos[i];
            boolean bl = adjust = i != pos.length - 2;
            if (horizontal) {
                if (adjust) {
                    min = pos[i - 2];
                    max = pos[i + 2];
                    pos[i] = current = this.getRowNear(conn, current, min, max);
                }
                p = new Point(prev, current);
            } else {
                if (adjust) {
                    min = pos[i - 2];
                    max = pos[i + 2];
                    pos[i] = current = this.getColumnNear(conn, current, min, max);
                }
                p = new Point(current, prev);
            }
            points.addPoint(p);
            ++i;
        }
        points.addPoint(new Point(end.x, end.y));
        conn.setPoints(points);
    }

    public void remove(Connection connection) {
        this.removeReservedLines(connection);
    }

    protected void removeReservedLines(Connection connection) {
        ReservedInfo rInfo = (ReservedInfo)this.reservedInfo.get(connection);
        if (rInfo == null) {
            return;
        }
        int i = 0;
        while (i < rInfo.reservedRows.size()) {
            this.rowsUsed.remove(rInfo.reservedRows.get(i));
            ++i;
        }
        i = 0;
        while (i < rInfo.reservedCols.size()) {
            this.colsUsed.remove(rInfo.reservedCols.get(i));
            ++i;
        }
        this.reservedInfo.remove(connection);
    }

    protected void reserveColumn(Connection connection, Integer column) {
        ReservedInfo info = (ReservedInfo)this.reservedInfo.get(connection);
        if (info == null) {
            info = new ReservedInfo();
            this.reservedInfo.put(connection, info);
        }
        info.reservedCols.add(column);
    }

    protected void reserveRow(Connection connection, Integer row) {
        ReservedInfo info = (ReservedInfo)this.reservedInfo.get(connection);
        if (info == null) {
            info = new ReservedInfo();
            this.reservedInfo.put(connection, info);
        }
        info.reservedRows.add(row);
    }

    public void route(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        Point startPoint = this.getStartPoint(conn);
        conn.translateToRelative(startPoint);
        Point endPoint = this.getEndPoint(conn);
        conn.translateToRelative(endPoint);
        Ray start = new Ray(startPoint);
        Ray end = new Ray(endPoint);
        Ray average = start.getAveraged(end);
        Ray direction = new Ray(start, end);
        Ray startNormal = this.getStartDirection(conn);
        Ray endNormal = this.getEndDirection(conn);
        Vector<Integer> positions = new Vector<Integer>(5);
        boolean horizontal = startNormal.isHorizontal();
        if (horizontal) {
            positions.add(new Integer(start.y));
        } else {
            positions.add(new Integer(start.x));
        }
        boolean bl = horizontal = !horizontal;
        if (startNormal.dotProduct(endNormal) == 0) {
            if (startNormal.dotProduct(direction) < 0 || endNormal.dotProduct(direction) > 0) {
                int i = startNormal.dotProduct(direction) < 0 ? startNormal.similarity(start.getAdded(startNormal.getScaled(10))) : (horizontal ? average.y : average.x);
                positions.add(new Integer(i));
                boolean bl2 = horizontal = !horizontal;
                i = endNormal.dotProduct(direction) > 0 ? endNormal.similarity(end.getAdded(endNormal.getScaled(10))) : (horizontal ? average.y : average.x);
                positions.add(new Integer(i));
                horizontal = !horizontal;
            }
        } else if (startNormal.dotProduct(endNormal) > 0) {
            int i = startNormal.dotProduct(direction) >= 0 ? startNormal.similarity(start.getAdded(startNormal.getScaled(10))) : endNormal.similarity(end.getAdded(endNormal.getScaled(10)));
            positions.add(new Integer(i));
            horizontal = !horizontal;
        } else {
            int i;
            if (startNormal.dotProduct(direction) < 0) {
                i = startNormal.similarity(start.getAdded(startNormal.getScaled(10)));
                positions.add(new Integer(i));
                horizontal = !horizontal;
            }
            i = horizontal ? average.y : average.x;
            positions.add(new Integer(i));
            boolean bl3 = horizontal = !horizontal;
            if (startNormal.dotProduct(direction) < 0) {
                i = endNormal.similarity(end.getAdded(endNormal.getScaled(10)));
                positions.add(new Integer(i));
                boolean bl4 = horizontal = !horizontal;
            }
        }
        if (horizontal) {
            positions.add(new Integer(end.y));
        } else {
            positions.add(new Integer(end.x));
        }
        this.processPositions(start, end, positions, startNormal.isHorizontal(), conn);
    }

    private class ReservedInfo {
        public List reservedRows = new ArrayList(2);
        public List reservedCols = new ArrayList(2);

        ReservedInfo() {
        }
    }
}

