/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;

public class LineBorder
extends AbstractBorder {
    protected int width = 1;
    protected Color color;

    public LineBorder(Color c, int width) {
        this.color = c;
        this.width = width;
    }

    public LineBorder(Color c) {
        this(c, 1);
    }

    public LineBorder(int width) {
        this(null, width);
    }

    public LineBorder() {
    }

    public Insets getInsets(IFigure figure) {
        return new Insets(this.width);
    }

    public boolean isOpaque() {
        return true;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        AbstractBorder.tempRect.setBounds(AbstractBorder.getPaintRectangle(figure, insets));
        if (this.width % 2 == 1) {
            --AbstractBorder.tempRect.width;
            --AbstractBorder.tempRect.height;
        }
        AbstractBorder.tempRect.shrink(this.width / 2, this.width / 2);
        graphics.setLineWidth(this.width);
        if (this.color != null) {
            graphics.setForegroundColor(this.color);
        }
        graphics.drawRectangle(AbstractBorder.tempRect);
    }
}

