/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.TransparentFigure;

public class LayeredPane
extends TransparentFigure {
    private List layerKeys = new ArrayList();

    public LayeredPane() {
        this.setLayoutManager(new StackLayout());
    }

    public void add(IFigure figure, Object layerKey, int index) {
        if (index == -1) {
            index = this.layerKeys.size();
        }
        Layer layer = (Layer)figure;
        if (index > 0) {
            this.getLayer(index - 1).setNextLayer(layer);
            layer.setPreviousLayer(this.getLayer(index - 1));
        }
        if (index < this.getChildren().size()) {
            this.getLayer(index).setPreviousLayer(layer);
            layer.setNextLayer(this.getLayer(index));
        }
        super.add(layer, layerKey, index);
        this.layerKeys.add(index, layerKey);
    }

    public void addLayerAfter(Layer layer, Object key, Object after) {
        int index = this.layerKeys.indexOf(after);
        this.add(layer, key, ++index);
    }

    public void addLayerBefore(Layer layer, Object key, Object before) {
        int index = this.layerKeys.indexOf(before);
        this.add(layer, key, index);
    }

    public Layer getLayer(Object key) {
        int index = this.layerKeys.indexOf(key);
        return (Layer)this.getChildren().get(index);
    }

    protected Layer getLayer(int index) {
        return (Layer)this.getChildren().get(index);
    }

    public boolean isOpaque() {
        if (super.isOpaque()) {
            return true;
        }
        Figure.FigureIterator iterator = new Figure.FigureIterator(this);
        while (iterator.hasNext()) {
            if (!iterator.nextFigure().isOpaque()) continue;
            return true;
        }
        return false;
    }

    protected void paintChildren(Graphics g) {
        List list = this.getChildren();
        if (list.isEmpty()) {
            return;
        }
        ((IFigure)list.get(list.size() - 1)).paint(g);
    }

    public void removeLayer(Object key) {
        this.removeLayer(this.layerKeys.indexOf(key));
    }

    public void removeLayer(IFigure layer) {
        this.removeLayer(this.getChildren().indexOf(layer));
    }

    protected void removeLayer(int index) {
        Layer removeLayer = this.getLayer(index);
        Layer prevLayer = index > 0 ? this.getLayer(index - 1) : null;
        Layer nextLayer = this.getChildren().size() > index + 1 ? this.getLayer(index + 1) : null;
        removeLayer.setNextLayer(null);
        removeLayer.setPreviousLayer(null);
        if (prevLayer != null) {
            prevLayer.setNextLayer(nextLayer);
        }
        if (nextLayer != null) {
            nextLayer.setPreviousLayer(prevLayer);
        }
        this.remove(removeLayer);
        this.layerKeys.remove(index);
    }
}

