/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;

public abstract class Graphics {
    public static TransparencyFlag TRANSPARENT = new TransparencyFlag(true);
    public static TransparencyFlag NON_TRANSPARENT = new TransparencyFlag(false);
    public static final int LINE_SOLID = 1;
    public static final int LINE_DASH = 2;
    public static final int LINE_DASHDOT = 4;
    public static final int LINE_DASHDOTDOT = 5;
    public static final int LINE_DOT = 3;

    public abstract void clipRect(Rectangle var1);

    public abstract void drawArc(Rectangle var1, int var2, int var3);

    public abstract void fillArc(Rectangle var1, int var2, int var3);

    public abstract void drawFocus(Rectangle var1);

    public abstract void drawFocus(int var1, int var2, int var3, int var4);

    public abstract void drawImage(Image var1, Point var2);

    public abstract void drawImage(Image var1, int var2, int var3);

    public abstract void drawImage(Image var1, Rectangle var2, Rectangle var3);

    public abstract void drawImage(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract void drawLine(Point var1, Point var2);

    public abstract void drawLine(int var1, int var2, int var3, int var4);

    public abstract void drawOval(Rectangle var1);

    public abstract void fillOval(Rectangle var1);

    public abstract void drawPolygon(PointList var1);

    public abstract void fillPolygon(PointList var1);

    public abstract void drawPolyline(PointList var1);

    public abstract void drawRectangle(Rectangle var1);

    public abstract void drawRectangle(int var1, int var2, int var3, int var4);

    public abstract void fillRectangle(Rectangle var1);

    public abstract void fillRectangle(int var1, int var2, int var3, int var4);

    public abstract void drawRoundRectangle(Rectangle var1, int var2, int var3);

    public abstract void fillRoundRectangle(Rectangle var1, int var2, int var3);

    public abstract void drawString(String var1, Point var2, TransparencyFlag var3);

    public abstract void drawText(String var1, Point var2, TransparencyFlag var3);

    public abstract void drawString(String var1, int var2, int var3, TransparencyFlag var4);

    public abstract void drawText(String var1, int var2, int var3, TransparencyFlag var4);

    public void drawText(String s, int x, int y) {
        this.drawText(s, x, y, TRANSPARENT);
    }

    public void fillText(String s, int x, int y) {
        this.drawText(s, x, y, NON_TRANSPARENT);
    }

    public void drawString(String s, int x, int y) {
        this.drawText(s, x, y, TRANSPARENT);
    }

    public void fillString(String s, int x, int y) {
        this.drawString(s, x, y, NON_TRANSPARENT);
    }

    public void drawText(String s, Point p) {
        this.drawText(s, p.x, p.y, TRANSPARENT);
    }

    public void fillText(String s, Point p) {
        this.drawText(s, p.x, p.y, NON_TRANSPARENT);
    }

    public void drawString(String s, Point p) {
        this.drawString(s, p.x, p.y, TRANSPARENT);
    }

    public void fillString(String s, Point p) {
        this.drawString(s, p.x, p.y, NON_TRANSPARENT);
    }

    public abstract int getAdvanceWidth(char var1);

    public abstract Color getBackgroundColor();

    public abstract int getCharWidth(char var1);

    public abstract Rectangle getClip(Rectangle var1);

    public abstract Font getFont();

    public abstract FontMetrics getFontMetrics();

    public abstract Color getForegroundColor();

    public abstract int getLineStyle();

    public abstract int getLineWidth();

    public abstract Dimension getStringExtent(String var1);

    public abstract Dimension getTextExtent(String var1);

    public abstract boolean getXORMode();

    public abstract void popState();

    public abstract void pushState();

    public abstract void restoreState();

    public abstract void scale(float var1);

    public abstract void setBackgroundColor(Color var1);

    public abstract void setClip(Rectangle var1);

    public abstract void setFont(Font var1);

    public abstract void setForegroundColor(Color var1);

    public abstract void setLineStyle(int var1);

    public abstract void setLineWidth(int var1);

    public abstract void setXORMode(boolean var1);

    public abstract void translate(Point var1);

    public abstract void translate(int var1, int var2);

    protected static final class TransparencyFlag {
        boolean val;

        protected TransparencyFlag(boolean b) {
            this.val = b;
        }

        public boolean toBoolean() {
            return this.val;
        }
    }
}

