/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ScrollPaneSolver;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class FigureCanvas
extends Canvas {
    public static int NEVER = 0;
    public static int AUTOMATIC = 1;
    public static int ALWAYS = 2;
    private static int DEFAULT_INCREMENT = 10;
    private int vBarVisibility = AUTOMATIC;
    private int hBarVisibility = AUTOMATIC;
    private Viewport viewport;
    private int hBarOffset;
    private int vBarOffset;
    private PropertyChangeListener horizontalChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            RangeModel model = FigureCanvas.this.getViewport().getHorizontalRangeModel();
            FigureCanvas.this.hBarOffset = Math.max(0, -model.getMinimum());
            FigureCanvas.this.getHorizontalBar().setValues(model.getValue() + FigureCanvas.this.hBarOffset, model.getMinimum() + FigureCanvas.this.hBarOffset, model.getMaximum() + FigureCanvas.this.hBarOffset, model.getExtent(), model.getExtent() / 20, model.getExtent() * 3 / 4);
        }
    };
    private PropertyChangeListener verticalChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            RangeModel model = FigureCanvas.this.getViewport().getVerticalRangeModel();
            FigureCanvas.this.vBarOffset = Math.max(0, -model.getMinimum());
            FigureCanvas.this.getVerticalBar().setValues(model.getValue() + FigureCanvas.this.vBarOffset, model.getMinimum() + FigureCanvas.this.vBarOffset, model.getMaximum() + FigureCanvas.this.vBarOffset, model.getExtent(), model.getExtent() / 20, model.getExtent() * 3 / 4);
        }
    };
    private InternalLightweightSystem lws;

    public FigureCanvas(Composite parent) {
        super(parent, 1311488);
        this.init();
        this.hookControl();
    }

    public IFigure getContents() {
        return this.getViewport().getContents();
    }

    public int getHorizontalScrollBarVisibility() {
        return this.hBarVisibility;
    }

    public LightweightSystem getLightweightSystem() {
        return this.lws;
    }

    public int getVerticalScrollBarVisibility() {
        return this.vBarVisibility;
    }

    public Viewport getViewport() {
        if (this.viewport == null) {
            this.setViewport(new Viewport(true));
        }
        return this.viewport;
    }

    private void hookControl() {
        this.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FigureCanvas.this.scrollToX(FigureCanvas.this.getHorizontalBar().getSelection() - FigureCanvas.this.hBarOffset);
            }
        });
        this.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FigureCanvas.this.scrollToY(FigureCanvas.this.getVerticalBar().getSelection() - FigureCanvas.this.vBarOffset);
            }
        });
    }

    private void hookViewport() {
        this.getViewport().getHorizontalRangeModel().addPropertyChangeListener(this.horizontalChangeListener);
        this.getViewport().getVerticalRangeModel().addPropertyChangeListener(this.verticalChangeListener);
    }

    private void unhookViewport() {
        this.getViewport().getHorizontalRangeModel().removePropertyChangeListener(this.horizontalChangeListener);
        this.getViewport().getVerticalRangeModel().removePropertyChangeListener(this.verticalChangeListener);
    }

    private void init() {
        this.lws = new InternalLightweightSystem();
        this.lws.setControl(this);
        this.getHorizontalBar().setIncrement(DEFAULT_INCREMENT);
        this.getVerticalBar().setIncrement(DEFAULT_INCREMENT);
    }

    private void layoutViewport() {
        ScrollPaneSolver.Result result = ScrollPaneSolver.solve(new Rectangle(this.getBounds()).setLocation(0, 0), this.getViewport(), this.getHorizontalScrollBarVisibility(), this.getVerticalScrollBarVisibility(), this.computeTrim((int)0, (int)0, (int)0, (int)0).width, this.computeTrim((int)0, (int)0, (int)0, (int)0).height);
        this.getHorizontalBar().setVisible(result.showH);
        this.getVerticalBar().setVisible(result.showV);
    }

    public void scrollSmoothTo(int x, int y) {
        x = this.verifyScrollBarOffset(this.getViewport().getHorizontalRangeModel(), x);
        y = this.verifyScrollBarOffset(this.getViewport().getVerticalRangeModel(), y);
        int oldX = this.getViewport().getViewLocation().x;
        int oldY = this.getViewport().getViewLocation().y;
        int dx = x - oldX;
        int dy = y - oldY;
        if (dx == 0 && dy == 0) {
            return;
        }
        Dimension viewingArea = this.getViewport().getClientArea().getSize();
        int MIN_FRAMES = 3;
        int MAX_FRAMES = 6;
        if (dx == 0 || dy == 0) {
            MIN_FRAMES = 5;
            MAX_FRAMES = 13;
        }
        int FRAMES = (Math.abs(dx) + Math.abs(dy)) / 15;
        FRAMES = Math.max(FRAMES, MIN_FRAMES);
        FRAMES = Math.min(FRAMES, MAX_FRAMES);
        int stepX = Math.min(dx / FRAMES, viewingArea.width / 3);
        int stepY = Math.min(dy / FRAMES, viewingArea.height / 3);
        int i = 1;
        while (i < FRAMES) {
            this.scrollTo(oldX + i * stepX, oldY + i * stepY);
            this.getViewport().getUpdateManager().performUpdate();
            ++i;
        }
        this.scrollTo(x, y);
    }

    public void scrollTo(int x, int y) {
        x = this.verifyScrollBarOffset(this.getViewport().getHorizontalRangeModel(), x);
        y = this.verifyScrollBarOffset(this.getViewport().getVerticalRangeModel(), y);
        if (x == this.getViewport().getViewLocation().x) {
            this.scrollToY(y);
        } else if (y == this.getViewport().getViewLocation().y) {
            this.scrollToX(x);
        } else {
            this.getViewport().setViewLocation(x, y);
        }
    }

    public void scrollToX(int hOffset) {
        int hOffsetOld;
        hOffset = this.verifyScrollBarOffset(this.getViewport().getHorizontalRangeModel(), hOffset);
        if (hOffset == (hOffsetOld = this.getViewport().getViewLocation().x)) {
            return;
        }
        int dx = -hOffset + hOffsetOld;
        this.getHorizontalBar().setSelection(hOffset);
        Rectangle clientArea = this.getViewport().getBounds().getCropped(this.getViewport().getInsets());
        Rectangle blit = clientArea.getResized(-Math.abs(dx), 0);
        Rectangle expose = clientArea.getCopy();
        Point dest = clientArea.getTopLeft();
        expose.width = Math.abs(dx);
        if (dx < 0) {
            blit.translate(-dx, 0);
            expose.x = dest.x + blit.width;
        } else {
            dest.x += dx;
        }
        this.scroll(dest.x, dest.y, blit.x, blit.y, blit.width, blit.height, false);
        this.getViewport().setIgnoreScroll(true);
        this.getViewport().setHorizontalLocation(hOffset);
        this.getViewport().setIgnoreScroll(false);
        this.redraw(expose.x, expose.y, expose.width, expose.height, true);
    }

    public void scrollToY(int vOffset) {
        int vOffsetOld;
        vOffset = this.verifyScrollBarOffset(this.getViewport().getVerticalRangeModel(), vOffset);
        if (vOffset == (vOffsetOld = this.getViewport().getViewLocation().y)) {
            return;
        }
        int dy = -vOffset + vOffsetOld;
        this.getVerticalBar().setSelection(vOffset);
        Rectangle clientArea = this.getViewport().getBounds().getCropped(this.getViewport().getInsets());
        Rectangle blit = clientArea.getResized(0, -Math.abs(dy));
        Rectangle expose = clientArea.getCopy();
        Point dest = clientArea.getTopLeft();
        expose.height = Math.abs(dy);
        if (dy < 0) {
            blit.translate(0, -dy);
            expose.y = dest.y + blit.height;
        } else {
            dest.y += dy;
        }
        this.scroll(dest.x, dest.y, blit.x, blit.y, blit.width, blit.height, false);
        this.getViewport().setIgnoreScroll(true);
        this.getViewport().setVerticalLocation(vOffset);
        this.getViewport().setIgnoreScroll(false);
        this.redraw(expose.x, expose.y, expose.width, expose.height, true);
    }

    public void setContents(IFigure figure) {
        this.getViewport().setContents(figure);
    }

    public void setHorizontalScrollBarVisibility(int v) {
        this.hBarVisibility = v;
    }

    public void setScrollBarVisibility(int both) {
        this.setHorizontalScrollBarVisibility(both);
        this.setVerticalScrollBarVisibility(both);
    }

    public void setVerticalScrollBarVisibility(int v) {
        this.vBarVisibility = v;
    }

    public void setViewport(Viewport vp) {
        if (this.viewport != null) {
            this.unhookViewport();
        }
        this.viewport = vp;
        this.lws.setContents(this.viewport);
        this.hookViewport();
    }

    private int verifyScrollBarOffset(RangeModel model, int value) {
        value = Math.max(model.getMinimum(), value);
        return Math.min(model.getMaximum(), value);
    }

    class InternalLightweightSystem
    extends LightweightSystem {
        InternalLightweightSystem() {
        }

        protected LightweightSystem.RootFigure createRootFigure() {
            return new ProxyRootFigure();
        }

        class ProxyRootFigure
        extends LightweightSystem.RootFigure {
            ProxyRootFigure() {
                super(InternalLightweightSystem.this);
            }

            public void validate() {
                if (FigureCanvas.this.isDisposed()) {
                    return;
                }
                FigureCanvas.this.layoutViewport();
                super.validate();
            }

            public boolean isOpaque() {
                return true;
            }
        }
    }
}

