/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.draw2d.RangeModel;

public class DefaultRangeModel
implements RangeModel {
    protected PropertyChangeSupport propertyListeners = new PropertyChangeSupport(this);
    private int minimum = 0;
    private int maximum = 100;
    private int extent = 20;
    private int value = 0;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.addPropertyChangeListener(listener);
    }

    protected void firePropertyChange(String string, int oldValue, int newValue) {
        this.propertyListeners.firePropertyChange(string, oldValue, newValue);
    }

    public int getExtent() {
        return this.extent;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isEnabled() {
        return this.getMaximum() - this.getMinimum() > this.getExtent();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.removePropertyChangeListener(listener);
    }

    public void setExtent(int extent) {
        if (this.extent == extent) {
            return;
        }
        int oldValue = this.extent;
        this.extent = extent;
        this.firePropertyChange("extent", oldValue, extent);
        this.setValue(this.getValue());
    }

    public void setMaximum(int maximum) {
        if (this.maximum == maximum) {
            return;
        }
        int oldValue = this.maximum;
        this.maximum = maximum;
        this.firePropertyChange("maximum", oldValue, maximum);
        this.setValue(this.getValue());
    }

    public void setMinimum(int minimum) {
        if (this.minimum == minimum) {
            return;
        }
        int oldValue = this.minimum;
        this.minimum = minimum;
        this.firePropertyChange("minimum", oldValue, minimum);
        this.setValue(this.getValue());
    }

    public void setValue(int value) {
        value = Math.max(this.getMinimum(), Math.min(this.getMaximum() - this.getExtent(), value));
        if (this.value == value) {
            return;
        }
        int oldValue = this.value;
        this.value = value;
        this.firePropertyChange("value", oldValue, value);
    }
}

