/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LabeledContainer;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.SimpleRaisedBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Canvas;

public class DebugLightweightSystem
extends LightweightSystem {
    LayeredPane layers = new LayeredPane();
    Layer primary = new Layer();
    Layer debug = new Layer(){

        public boolean containsPoint(int x, int y) {
            return false;
        }
    };
    LabeledContainer cursorHighlight;
    LabeledContainer mouseHighlight;

    public DebugLightweightSystem() {
        this.getRootFigure().add(this.layers);
        this.layers.add(this.primary);
        this.primary.setLayoutManager(new StackLayout());
        this.layers.add(this.debug);
        this.cursorHighlight = this.createHighlight();
        this.mouseHighlight = this.createHighlight();
        this.debug.add(this.cursorHighlight);
        this.debug.add(this.mouseHighlight);
    }

    public DebugLightweightSystem(Canvas c) {
        super(c);
        this.getRootFigure().add(this.layers);
        this.layers.add(this.primary);
        this.primary.setLayoutManager(new StackLayout());
        this.layers.add(this.debug);
        this.cursorHighlight = this.createHighlight();
        this.mouseHighlight = this.createHighlight();
        this.debug.add(this.cursorHighlight);
        this.debug.add(this.mouseHighlight);
    }

    LabeledContainer createHighlight() {
        TitleBarBorder titleBarBorder = new TitleBarBorder();
        titleBarBorder.setBackgroundColor(ColorConstants.orange);
        LabeledContainer c = new LabeledContainer(new CompoundBorder(new SimpleRaisedBorder(), titleBarBorder));
        c.setOpaque(false);
        c.setVisible(false);
        return c;
    }

    void followCursorTarget() {
        IFigure f = this.getEventDispatcher().getCursorTarget();
        this.cursorHighlight.setLabel("Cursor: " + f);
        if (f == this.getEventDispatcher().getMouseTarget()) {
            f = this.mouseHighlight;
        }
        this.highlight(f, this.cursorHighlight);
    }

    void followMouseTarget() {
        IFigure f = this.getEventDispatcher().getMouseTarget();
        this.mouseHighlight.setLabel("Mouse: " + f);
        this.highlight(f, this.mouseHighlight);
    }

    LightweightSystem.EventHandler internalCreateEventHandler() {
        return new DebugEventHandler();
    }

    void highlight(IFigure f, LabeledContainer c) {
        if (f == null || f.getParent() == null) {
            c.setVisible(false);
        } else {
            c.setVisible(true);
            Rectangle r = f.getBounds().getExpanded(c.getInsets());
            f.translateToAbsolute(r);
            c.setBounds(r);
        }
    }

    public void setContents(IFigure figure) {
        if (this.contents != null) {
            this.primary.remove(this.contents);
        }
        this.contents = figure;
        this.primary.add(this.contents);
    }

    class TitleBarBorder
    extends org.eclipse.draw2d.TitleBarBorder {
        TitleBarBorder() {
        }

        public void paint(IFigure figure, Graphics g, Insets insets) {
            g.setXORMode(true);
            super.paint(figure, g, insets);
        }
    }

    protected class DebugEventHandler
    extends LightweightSystem.EventHandler {
        protected DebugEventHandler() {
            super(DebugLightweightSystem.this);
        }

        public void keyPressed(KeyEvent e) {
            super.keyPressed(e);
            if (e.character == ' ') {
                DebugLightweightSystem.this.debug.setVisible(!DebugLightweightSystem.this.debug.isVisible());
            }
        }

        public void mouseMove(MouseEvent e) {
            super.mouseMove(e);
            DebugLightweightSystem.this.followCursorTarget();
            DebugLightweightSystem.this.followMouseTarget();
        }
    }
}

