/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;

class ClickableEventHandler
extends MouseMotionListener.Stub
implements MouseListener,
FigureListener,
ChangeListener,
KeyListener,
FocusListener {
    private MouseEvent lastEvent;

    ClickableEventHandler() {
    }

    public void focusLost(FocusEvent fe) {
        Clickable loser = (Clickable)fe.loser;
        loser.repaint();
        loser.getModel().setPressed(false);
        loser.getModel().setArmed(false);
    }

    public void focusGained(FocusEvent fe) {
        Clickable clickable = (Clickable)fe.gainer;
        clickable.repaint();
    }

    public void figureMoved(IFigure source) {
        if (this.lastEvent == null) {
            return;
        }
        this.mouseDragged(this.lastEvent);
    }

    public void handleStateChanged(ChangeEvent change) {
        Clickable clickable = (Clickable)change.getSource();
        if (change.getPropertyName() == "mouseover" && !clickable.isRolloverEnabled()) {
            return;
        }
        clickable.repaint();
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
        this.lastEvent = me;
        Clickable click = (Clickable)me.getSource();
        ButtonModel model = click.getModel();
        if (model.isPressed()) {
            boolean over = click.containsPoint(me.getLocation());
            model.setArmed(over);
            model.setMouseOver(over);
        }
    }

    public void mouseEntered(MouseEvent me) {
        Clickable click = (Clickable)me.getSource();
        click.getModel().setMouseOver(true);
        click.addFigureListener(this);
    }

    public void mouseExited(MouseEvent me) {
        Clickable click = (Clickable)me.getSource();
        click.getModel().setMouseOver(false);
        click.removeFigureListener(this);
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        if (me.button != 1) {
            return;
        }
        this.lastEvent = me;
        Clickable click = (Clickable)me.getSource();
        ButtonModel model = click.getModel();
        click.requestFocus();
        model.setArmed(true);
        model.setPressed(true);
        me.consume();
    }

    public void mouseReleased(MouseEvent me) {
        if (me.button != 1) {
            return;
        }
        ButtonModel model = ((Clickable)me.getSource()).getModel();
        if (!model.isPressed()) {
            return;
        }
        model.setPressed(false);
        model.setArmed(false);
        me.consume();
    }

    public void keyPressed(KeyEvent ke) {
        ButtonModel model = ((Clickable)ke.getSource()).getModel();
        if (ke.character == ' ') {
            model.setPressed(true);
            model.setArmed(true);
        }
    }

    public void keyReleased(KeyEvent ke) {
        ButtonModel model = ((Clickable)ke.getSource()).getModel();
        if (ke.character == ' ') {
            model.setPressed(false);
            model.setArmed(false);
        }
    }
}

