/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.velocity.runtime;

import com.sap.ide.generationfwk.text.UCAMergeWriter;
import com.sap.tc.logging.Location;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public abstract class CompiledTemplateBase {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$generationfwk$velocity$runtime$CompiledTemplateBase == null ? (class$com$sap$ide$generationfwk$velocity$runtime$CompiledTemplateBase = CompiledTemplateBase.class$("com.sap.ide.generationfwk.velocity.runtime.CompiledTemplateBase")) : class$com$sap$ide$generationfwk$velocity$runtime$CompiledTemplateBase).getName());
    private Writer mOut = null;
    private String lineSeparator = "\r\n";
    protected int _velocityCount = 0;
    static /* synthetic */ Class class$com$sap$ide$generationfwk$velocity$runtime$CompiledTemplateBase;

    protected CompiledTemplateBase() {
    }

    public final void generate(Map context, Writer writer) throws Exception {
        this.mOut = writer;
        Object lHelper = this.doCreateTemplateHelper();
        if (lHelper != null) {
            context.put("helper", lHelper);
        }
        this.doRegisterCodeBranches();
        this.doGenerate(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void generate(Map context, String outputPath) throws Exception {
        File outputFile = new File(outputPath);
        if (outputFile.getParentFile() != null && !outputFile.getParentFile().isDirectory()) {
            if (outputFile.getParentFile().exists()) {
                throw new IllegalArgumentException(outputFile.getParent() + " is not a directory");
            }
            if (!outputFile.getParentFile().mkdirs()) {
                throw new IllegalArgumentException("failed to create dirs for " + outputFile.getParent());
            }
        }
        String outputEncoding = (String)context.get("encoding");
        String codeBody = (String)context.get("codeBody");
        this.mOut = null;
        try {
            try {
                this.mOut = codeBody != null && codeBody.length() > 0 ? new UCAMergeWriter(UCAMergeWriter.readUCAs(codeBody), new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), outputEncoding)) : new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), outputEncoding);
                this.mOut = new BufferedWriter(this.mOut);
                Object helper = this.doCreateTemplateHelper();
                if (helper != null) {
                    context.put("helper", helper);
                }
                this.doRegisterCodeBranches();
                this.doGenerate(context);
            }
            catch (Throwable th) {
                TRACE_LOCATION.errorT("Compiled template used for generating " + outputPath + " throws an exception / error: ", new Object[]{th});
                th.printStackTrace();
                throw new Exception("Problem running compiled template used for generating " + outputPath + ": " + th.getMessage());
            }
            Object var8_8 = null;
            if (this.mOut == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (this.mOut == null) throw throwable;
            this.mOut.flush();
            this.mOut.close();
            throw throwable;
        }
        this.mOut.flush();
        this.mOut.close();
    }

    public final String generate(Map context) throws Exception {
        String outputEncoding = (String)context.get("encoding");
        String codeBody = (String)context.get("codeBody");
        this.mOut = codeBody != null && codeBody.length() > 0 ? new UCAMergeWriter(UCAMergeWriter.readUCAs(codeBody), new StringWriter()) : new StringWriter();
        Object helper = this.doCreateTemplateHelper();
        if (helper != null) {
            context.put("helper", helper);
        }
        this.doRegisterCodeBranches();
        this.doGenerate(context);
        return this.mOut.toString();
    }

    protected Object doCreateTemplateHelper() {
        return null;
    }

    protected void doRegisterCodeBranches() {
    }

    protected abstract void doGenerate(Map var1) throws IOException;

    public final void nl() throws IOException {
        this.mOut.write(this.lineSeparator);
    }

    public final void print(String str) throws IOException {
        if (str != null) {
            this.mOut.write(str);
        }
    }

    public final void print(boolean b) throws IOException {
        this.print(String.valueOf(b));
    }

    public final void print(char c) throws IOException {
        this.print(String.valueOf(c));
    }

    public final void print(byte b) throws IOException {
        this.print(String.valueOf(b));
    }

    public final void print(short s) throws IOException {
        this.print(String.valueOf(s));
    }

    public final void print(int i) throws IOException {
        this.print(String.valueOf(i));
    }

    public final void print(long l) throws IOException {
        this.print(String.valueOf(l));
    }

    public final void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public final void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public final void print(Object o) throws IOException {
        if (o == null) {
            throw new NullPointerException();
        }
        this.print(String.valueOf(o));
    }

    protected boolean isTrue(boolean b) {
        return b;
    }

    protected boolean isTrue(Object o) {
        return o != null;
    }

    protected boolean isNot(boolean b) {
        return !b;
    }

    protected boolean isNot(Object o) {
        return o == null;
    }

    protected boolean isEQ(boolean b1, boolean b2) {
        return b1 == b2;
    }

    protected boolean isEQ(int i1, int i2) {
        return i1 == i2;
    }

    protected boolean isEQ(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o2 != null && o1.equals(o2);
    }

    protected boolean isNE(boolean b1, boolean b2) {
        return b1 != b2;
    }

    protected boolean isNE(int i1, int i2) {
        return i1 != i2;
    }

    protected boolean isNE(Object o1, Object o2) {
        return !this.isEQ(o1, o2);
    }

    protected boolean isGT(int i1, int i2) {
        return i1 > i2;
    }

    protected boolean isGE(int i1, int i2) {
        return i1 >= i2;
    }

    protected boolean isLT(int i1, int i2) {
        return i1 < i2;
    }

    protected boolean isLE(int i1, int i2) {
        return i1 <= i2;
    }

    private Iterator iterate0(Object o) {
        if (o == null) {
            return Collections.EMPTY_SET.iterator();
        }
        if (o instanceof Collection) {
            return ((Collection)o).iterator();
        }
        if (o instanceof Map) {
            return ((Map)o).values().iterator();
        }
        if (o.getClass().isArray()) {
            return Arrays.asList((Object[])o).iterator();
        }
        if (o instanceof Iterator) {
            return (Iterator)o;
        }
        if (o instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)o);
        }
        throw new RuntimeException("can't iterate " + o);
    }

    protected Iterator iterate(Object o) {
        Iterator it = this.iterate0(o);
        return new ForEachIterator(it);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Literals {
        private StringBuffer buf;
        private String lineSeparator = "\r\n";

        protected Literals() {
            this.clear();
        }

        protected void clear() {
            this.buf = new StringBuffer();
        }

        public String toString() {
            return this.buf.toString();
        }

        protected void nl() {
            this.buf.append(this.lineSeparator);
        }

        protected void print(String str) {
            this.buf.append(str);
        }

        protected void print(boolean b) {
            this.print(String.valueOf(b));
        }

        protected void print(int i) {
            this.print(String.valueOf(i));
        }

        protected void print(Object o) {
            this.print(String.valueOf(o));
        }
    }

    private class ForEachIterator
    implements Iterator {
        private final Iterator it;
        private int oldVelocityCount;
        private boolean stopped = false;

        private ForEachIterator(Iterator it) {
            this.it = it;
            this.oldVelocityCount = CompiledTemplateBase.this._velocityCount;
            CompiledTemplateBase.this._velocityCount = -1;
        }

        public boolean hasNext() {
            boolean result = this.it.hasNext();
            if (!result && !this.stopped) {
                CompiledTemplateBase.this._velocityCount = this.oldVelocityCount;
                this.stopped = true;
            }
            return result;
        }

        public Object next() {
            if (this.hasNext()) {
                ++CompiledTemplateBase.this._velocityCount;
            }
            return this.it.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class EnumerationIterator
    implements Iterator {
        private Enumeration enum;

        private EnumerationIterator(Enumeration enumeration) {
            this.enum = enumeration;
        }

        public boolean hasNext() {
            return this.enum.hasMoreElements();
        }

        public Object next() {
            return this.enum.nextElement();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

