/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.text;

import java.io.IOException;
import java.util.ArrayList;

public abstract class FiniteAutomaton {
    private ArrayList states = new ArrayList();
    private State currentState;
    private int initialStateIndex = 0;

    private void setCurrentState(int i) {
        this.currentState = (State)this.states.get(i);
    }

    public void defineTransitions(int stateIndex, String chars, int[] actions, int[] nextStates) {
        State stateInfo = new State(chars, actions, nextStates);
        if (this.states.size() == 0) {
            this.initialStateIndex = stateIndex;
        }
        while (this.states.size() <= stateIndex) {
            this.states.add(null);
        }
        this.states.set(stateIndex, stateInfo);
    }

    public void setInitialState(int initialStateIndex) {
        this.initialStateIndex = initialStateIndex;
    }

    public void reset() {
        this.setCurrentState(this.initialStateIndex);
    }

    public void consume(char c) throws IOException {
        this.currentState.consume(c);
    }

    public void consume(char[] cbuf, int off, int len) throws IOException {
        while (len > 0) {
            this.currentState.consume(cbuf[off++]);
            --len;
        }
    }

    protected abstract void doAction(int var1, char var2) throws IOException;

    private class State {
        char[] chars;
        int[] actions;
        int[] nextStates;

        public State(String chars, int[] actions, int[] nextStates) {
            if (chars == null || actions == null || nextStates == null || chars.length() + 1 != actions.length || nextStates.length != actions.length) {
                throw new IllegalArgumentException();
            }
            this.chars = chars.toCharArray();
            this.actions = actions;
            this.nextStates = nextStates;
        }

        public void consume(char c) throws IOException {
            int i = 0;
            while (i < this.chars.length) {
                if (c == this.chars[i]) break;
                ++i;
            }
            FiniteAutomaton.this.doAction(this.actions[i], c);
            FiniteAutomaton.this.setCurrentState(this.nextStates[i]);
        }
    }
}

