/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.task;

import com.sap.ide.generationfwk.configuration.IGenerationUnit;
import com.sap.ide.generationfwk.configuration.template.ITemplate;
import com.sap.ide.generationfwk.task.GenerationTaskBase;
import com.sap.ide.generationfwk.text.UCAMergeWriter;
import com.sap.ide.generationfwk.trace.VelocityTracer;
import com.sap.ide.generationfwk.util.dir.DirectoryCreationService;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class GenerationTaskVelocity
extends GenerationTaskBase {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$generationfwk$task$GenerationTaskVelocity == null ? (class$com$sap$ide$generationfwk$task$GenerationTaskVelocity = GenerationTaskVelocity.class$("com.sap.ide.generationfwk.task.GenerationTaskVelocity")) : class$com$sap$ide$generationfwk$task$GenerationTaskVelocity).getName());
    private ITemplate mTemplate = null;
    private VelocityEngine mVelocityEngine = new VelocityEngine();
    static /* synthetic */ Class class$com$sap$ide$generationfwk$task$GenerationTaskVelocity;

    public GenerationTaskVelocity(int environment) {
        super(environment);
    }

    public String getType() {
        return "velocityTemplate";
    }

    public final String executeTransient(IGenerationUnit generationUnit, HashMap context) throws Exception {
        this.executeTransient(generationUnit, context, null);
        return null;
    }

    public final String executeTransient(IGenerationUnit generationUnit, HashMap context, String codeBody) throws Exception {
        this.setContext(context);
        this.setTemplate((ITemplate)generationUnit);
        this.setOutputPath("");
        this.setCodeBody(codeBody);
        this.createVelocityConfiguration();
        if (!this.isTestMode()) {
            Writer lWriter = null;
            lWriter = this.getCodeBody() == null || this.getCodeBody().length() == 0 ? new StringWriter() : new UCAMergeWriter(UCAMergeWriter.readUCAs(this.getCodeBody()), new StringWriter());
            Template lVelocityTemplate = this.getVelocityEngine().getTemplate(this.getTemplate().getFileName());
            lVelocityTemplate.merge((Context)this.createVelocityContext(), lWriter);
            return lWriter.toString();
        }
        if (this.getEnvironment() == 1 || this.getEnvironment() == 3) {
            System.out.println("!!! Test mode, no generation !!!");
            return "";
        }
        return null;
    }

    public final void executePersistent(IGenerationUnit generationUnit, HashMap context, String outputPath) throws Exception {
        this.executePersistent(generationUnit, context, outputPath, null);
    }

    public final void executePersistent(IGenerationUnit generationUnit, HashMap context, String outputPath, String codeBody) throws Exception {
        this.setContext(context);
        this.setTemplate((ITemplate)generationUnit);
        this.setOutputPath(outputPath);
        this.setCodeBody(codeBody);
        GenerationTaskBase.checkFilePathLength(outputPath);
        this.createVelocityConfiguration();
        if (!this.isTestMode()) {
            int lIndex = this.getOutputPath().lastIndexOf(47);
            if (lIndex != -1) {
                DirectoryCreationService.createDirectory(this.getOutputPath().substring(0, lIndex));
            }
            Writer lWriter = null;
            lWriter = this.getCodeBody() == null || this.getCodeBody().length() == 0 ? new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.getOutputPath())), this.getTemplate().getOutputEncoding()) : new UCAMergeWriter(UCAMergeWriter.readUCAs(this.getCodeBody()), new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.getOutputPath())), this.getTemplate().getOutputEncoding()));
            Template lVelocityTemplate = this.getVelocityEngine().getTemplate(this.getTemplate().getFileName());
            lVelocityTemplate.merge((Context)this.createVelocityContext(), lWriter);
            lWriter.flush();
            lWriter.close();
        } else if (this.getEnvironment() == 1 || this.getEnvironment() == 3) {
            System.out.println("!!! Test mode, no generation !!!");
        }
    }

    private void createVelocityConfiguration() throws Exception {
        this.getVelocityEngine().setProperty("resource.loader", (Object)"file, class");
        switch (this.getEnvironment()) {
            case 2: {
                this.getVelocityEngine().setProperty("runtime.log.logsystem", (Object)new VelocityTracer());
                this.getVelocityEngine().setProperty("class.resource.loader.class", (Object)"com.sap.ide.generationfwk.eclipse.VelocityClasspathResourceLoader");
                this.getVelocityEngine().setProperty("sap.extension.id", (Object)this.getExtensionId());
                break;
            }
            case 1: 
            case 3: {
                this.getVelocityEngine().setProperty("class.resource.loader.class", (Object)"com.sap.ide.generationfwk.velocity.runtime.ClasspathResourceLoader");
            }
        }
        this.getVelocityEngine().setProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        this.getVelocityEngine().setProperty("file.resource.loader.path", (Object)this.getTemplate().getFilePath());
        this.getVelocityEngine().setProperty("file.resource.loader.cache", (Object)"true");
        this.getVelocityEngine().setProperty("file.resource.loader.modificationCheckInterval", (Object)"0");
        this.getVelocityEngine().setProperty("velocimacro.context.localscope", (Object)"true");
        this.getVelocityEngine().setProperty("directive.foreach.counter.initial.value", (Object)"0");
        this.getVelocityEngine().setProperty("ISO-8859-1", (Object)"UTF-8");
        this.getVelocityEngine().setProperty("input.encoding", (Object)this.getTemplate().getTemplateEncoding());
        this.getVelocityEngine().setProperty("output.encoding", (Object)this.getTemplate().getOutputEncoding());
        this.getVelocityEngine().init();
    }

    private VelocityContext createVelocityContext() {
        VelocityContext lVelocityContext = new VelocityContext();
        Iterator lKeyIterator = this.getContext().keySet().iterator();
        String lKey = "";
        while (lKeyIterator.hasNext()) {
            lKey = (String)lKeyIterator.next();
            lVelocityContext.put(lKey, this.getContext().get(lKey));
        }
        if (this.getTemplate().getTemplateHelperObject() != null) {
            lVelocityContext.put("helper", this.getTemplate().getTemplateHelperObject());
        }
        return lVelocityContext;
    }

    private VelocityEngine getVelocityEngine() {
        return this.mVelocityEngine;
    }

    public final ITemplate getTemplate() {
        return this.mTemplate;
    }

    private void setTemplate(ITemplate template) {
        this.mTemplate = template;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

