/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.internal.ui.TeamUIPlugin;

public class TeamImages {
    private static Hashtable imageDescriptors = new Hashtable(20);

    static {
        TeamImages.initializeImages();
    }

    protected static void createImageDescriptor(String id, URL baseURL) {
        URL url = null;
        try {
            url = new URL(baseURL, "icons/full/" + id);
        }
        catch (MalformedURLException malformedURLException) {}
        ImageDescriptor desc = ImageDescriptor.createFromURL(url);
        imageDescriptors.put(id, desc);
    }

    public static ImageDescriptor getImageDescriptor(String id) {
        return (ImageDescriptor)imageDescriptors.get(id);
    }

    public static ImageDescriptor getImageDescriptorFromExtension(IExtension extension, String subdirectoryAndFilename) {
        IPluginDescriptor pluginDescriptor = extension.getDeclaringPluginDescriptor();
        URL path = pluginDescriptor.getInstallURL();
        URL fullPathString = null;
        try {
            fullPathString = new URL(path, subdirectoryAndFilename);
            return ImageDescriptor.createFromURL((URL)fullPathString);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static void initializeImages() {
        URL baseURL = TeamUIPlugin.getPlugin().getDescriptor().getInstallURL();
        TeamImages.createImageDescriptor("ovr/dirty_ov.gif", baseURL);
        TeamImages.createImageDescriptor("ovr/version_controlled.gif", baseURL);
        TeamImages.createImageDescriptor("ovr/checkedout_ov.gif", baseURL);
        TeamImages.createImageDescriptor("clcl16/site_element.gif", baseURL);
        TeamImages.createImageDescriptor("clcl16/incom_synch.gif", baseURL);
        TeamImages.createImageDescriptor("clcl16/outgo_synch.gif", baseURL);
        TeamImages.createImageDescriptor("clcl16/conflict_synch.gif", baseURL);
        TeamImages.createImageDescriptor("clcl16/refresh.gif", baseURL);
        TeamImages.createImageDescriptor("clcl16/ignorews_edit.gif", baseURL);
        TeamImages.createImageDescriptor("clcl16/contents.gif", baseURL);
        TeamImages.createImageDescriptor("dlcl16/incom_synch.gif", baseURL);
        TeamImages.createImageDescriptor("dlcl16/outgo_synch.gif", baseURL);
        TeamImages.createImageDescriptor("dlcl16/conflict_synch.gif", baseURL);
        TeamImages.createImageDescriptor("dlcl16/refresh.gif", baseURL);
        TeamImages.createImageDescriptor("dlcl16/ignorews_edit.gif", baseURL);
        TeamImages.createImageDescriptor("dlcl16/contents.gif", baseURL);
        TeamImages.createImageDescriptor("elcl16/incom_synch.gif", baseURL);
        TeamImages.createImageDescriptor("elcl16/outgo_synch.gif", baseURL);
        TeamImages.createImageDescriptor("elcl16/conflict_synch.gif", baseURL);
        TeamImages.createImageDescriptor("elcl16/refresh.gif", baseURL);
        TeamImages.createImageDescriptor("elcl16/ignorews_edit.gif", baseURL);
        TeamImages.createImageDescriptor("elcl16/contents.gif", baseURL);
        TeamImages.createImageDescriptor("clcl16/catchup_rls.gif", baseURL);
        TeamImages.createImageDescriptor("clcl16/release_rls.gif", baseURL);
        TeamImages.createImageDescriptor("clcl16/catchuprelease_rls.gif", baseURL);
        TeamImages.createImageDescriptor("dlcl16/catchup_rls.gif", baseURL);
        TeamImages.createImageDescriptor("dlcl16/release_rls.gif", baseURL);
        TeamImages.createImageDescriptor("dlcl16/catchuprelease_rls.gif", baseURL);
        TeamImages.createImageDescriptor("elcl16/catchup_rls.gif", baseURL);
        TeamImages.createImageDescriptor("elcl16/release_rls.gif", baseURL);
        TeamImages.createImageDescriptor("elcl16/catchuprelease_rls.gif", baseURL);
        TeamImages.createImageDescriptor("wizban/share_wizban.gif", baseURL);
        TeamImages.createImageDescriptor("wizban/import_projectset_wizban.gif", baseURL);
        TeamImages.createImageDescriptor("wizban/export_projectset_wizban.gif", baseURL);
    }
}

