/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.InfiniteSubProgressMonitor;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.core.target.TargetProvider;
import org.eclipse.team.internal.ui.IPromptCondition;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.PromptingDialog;
import org.eclipse.team.internal.ui.target.TargetAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class UploadAction
extends TargetAction {
    protected boolean isEnabled() throws TeamException {
        IResource[] resources = this.getSelectedResources();
        if (resources.length == 0) {
            return false;
        }
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            TargetProvider provider = TargetManager.getProvider((IProject)resource.getProject());
            if (provider == null) {
                return false;
            }
            if (!provider.canPut(resource)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run(IAction action) {
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    try {
                        Hashtable table = UploadAction.this.getTargetProviderMapping();
                        Set keySet = table.keySet();
                        monitor.beginTask("", keySet.size() * 1000);
                        Iterator iterator = keySet.iterator();
                        boolean hasOutgoing = false;
                        while (iterator.hasNext()) {
                            InfiniteSubProgressMonitor subMonitor = new InfiniteSubProgressMonitor(monitor, 1024);
                            TargetProvider provider = (TargetProvider)iterator.next();
                            subMonitor.setTaskName(Policy.bind("UploadAction.working", provider.getURL().toExternalForm()));
                            IResource[] providerResources = ((List)table.get(provider)).toArray(new IResource[0]);
                            IResource[] outgoingChanges = UploadAction.this.findResourcesWithOutgoingChanges(providerResources);
                            if (outgoingChanges.length <= 0) continue;
                            PromptingDialog prompt = new PromptingDialog(UploadAction.this.getShell(), outgoingChanges, new IPromptCondition(){

                                public boolean needsPrompt(IResource resource) {
                                    return !resource.exists();
                                }

                                public String promptMessage(IResource resource) {
                                    return Policy.bind("UploadAction.confirmFileDeletionMessage", resource.getFullPath().toString());
                                }
                            }, Policy.bind("UploadAction.confirmDeletionTitle"));
                            hasOutgoing = true;
                            provider.put(prompt.promptForMultiple(), (IProgressMonitor)subMonitor);
                        }
                        if (!hasOutgoing) {
                            UploadAction.this.getShell().getDisplay().syncExec(new Runnable(this){
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    MessageDialog.openInformation((Shell)UploadAction.access$1(1.access$0(this.this$1)), (String)Policy.bind("UploadAction.noDirtyTitle"), (String)Policy.bind("UploadAction.noDirtyMessage"));
                                }
                            });
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var11_15 = null;
                monitor.done();
            }

            static /* synthetic */ UploadAction access$0(1 var0) {
                return var0.UploadAction.this;
            }
        }, Policy.bind("UploadAction.problemMessage"), 1);
    }
}

