/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.internal.core.target.ITargetRunnable;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.core.target.TargetProvider;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.sync.SyncCompareInput;
import org.eclipse.team.internal.ui.target.TargetCatchupReleaseViewer;

public class TargetSyncCompareInput
extends SyncCompareInput {
    private IResource[] resources;

    protected TargetSyncCompareInput(IResource[] resources, int granularity) {
        super(granularity);
        this.resources = resources;
    }

    protected IRemoteSyncElement[] createSyncElements(IProgressMonitor monitor) throws TeamException {
        IRemoteSyncElement[] iRemoteSyncElementArray;
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(null, this.resources.length);
            IRemoteSyncElement[] elements = new IRemoteSyncElement[this.resources.length];
            int i = 0;
            while (i < this.resources.length) {
                IResource resource = this.resources[i];
                TargetProvider provider = TargetManager.getProvider((IProject)resource.getProject());
                elements[i] = provider.getRemoteSyncElement(resource);
                monitor.worked(1);
                ++i;
            }
            iRemoteSyncElementArray = elements;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return iRemoteSyncElementArray;
    }

    public Viewer createDiffViewer(Composite parent) {
        TargetCatchupReleaseViewer viewer = new TargetCatchupReleaseViewer(parent, this);
        this.setViewer(viewer);
        return viewer;
    }

    protected void updateView() {
        if (this.getDiffRoot().hasChildren()) {
            this.getViewer().refresh();
        } else {
            this.getViewer().setInput(null);
        }
        this.updateStatusLine();
    }

    protected IDiffElement collectResourceChanges(final IDiffContainer parent, final IRemoteSyncElement tree, IProgressMonitor pm) throws TeamException {
        final IDiffElement[] result = new IDiffElement[1];
        TargetProvider provider = TargetManager.getProvider((IProject)tree.getLocal().getProject());
        provider.run(new ITargetRunnable(){

            public void run(IProgressMonitor monitor) throws TeamException {
                result[0] = TargetSyncCompareInput.super.collectResourceChanges(parent, tree, monitor);
            }
        }, pm);
        return result[0];
    }
}

